/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jfr.runtime.http.rest.reactive;

import io.quarkus.jfr.runtime.IdProducer;
import io.quarkus.jfr.runtime.http.AbstractHttpEvent;
import io.quarkus.jfr.runtime.http.rest.RestEndEvent;
import io.quarkus.jfr.runtime.http.rest.RestPeriodEvent;
import io.quarkus.jfr.runtime.http.rest.RestStartEvent;
import io.quarkus.jfr.runtime.http.rest.reactive.RequestInfo;
import io.quarkus.jfr.runtime.http.rest.reactive.ResourceInfo;

class ReactiveServerRecorder {
    private final RequestInfo requestInfo;
    private final IdProducer idProducer;
    private volatile ResourceInfo resourceInfo;
    private volatile RestStartEvent startEvent;
    private volatile boolean startEventHandled;
    private volatile RestPeriodEvent durationEvent;

    public ReactiveServerRecorder(RequestInfo requestInfo, IdProducer idProducer) {
        this.requestInfo = requestInfo;
        this.idProducer = idProducer;
    }

    public ReactiveServerRecorder createStartEvent() {
        this.startEvent = new RestStartEvent();
        return this;
    }

    public ReactiveServerRecorder createAndStartPeriodEvent() {
        this.durationEvent = new RestPeriodEvent();
        this.durationEvent.begin();
        return this;
    }

    public ReactiveServerRecorder updateResourceInfo(ResourceInfo resourceInfo) {
        this.resourceInfo = resourceInfo;
        return this;
    }

    public ReactiveServerRecorder commitStartEventIfNecessary() {
        this.startEventHandled = true;
        RestStartEvent se = this.startEvent;
        if (se.shouldCommit()) {
            this.setHttpInfo(this.startEvent);
            se.commit();
        }
        return this;
    }

    public ReactiveServerRecorder recordEndEvent() {
        RestEndEvent endEvent;
        if (!this.startEventHandled) {
            this.commitStartEventIfNecessary();
        }
        if ((endEvent = new RestEndEvent()).shouldCommit()) {
            this.setHttpInfo(endEvent);
            endEvent.commit();
        }
        return this;
    }

    public ReactiveServerRecorder endPeriodEvent() {
        if (this.durationEvent != null) {
            this.durationEvent.end();
            if (this.durationEvent.shouldCommit()) {
                this.setHttpInfo(this.durationEvent);
                this.durationEvent.commit();
            }
        }
        return this;
    }

    private void setHttpInfo(AbstractHttpEvent event) {
        event.setTraceId(this.idProducer.getTraceId());
        event.setSpanId(this.idProducer.getSpanId());
        event.setHttpMethod(this.requestInfo.httpMethod());
        event.setUri(this.requestInfo.uri());
        event.setClient(this.requestInfo.remoteAddress());
        ResourceInfo ri = this.resourceInfo;
        if (this.resourceInfo != null) {
            event.setResourceClass(ri.resourceClass());
            event.setResourceMethod(ri.resourceMethod());
        }
    }
}

