/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jsonb.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.jsonb.JsonbConfigCustomizer;
import io.quarkus.jsonb.JsonbProducer;
import io.quarkus.jsonb.QuarkusJsonbComponentInstanceCreator;
import io.quarkus.jsonb.spi.JsonbDeserializerBuildItem;
import io.quarkus.jsonb.spi.JsonbSerializerBuildItem;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Singleton;
import javax.json.bind.JsonbConfig;
import javax.json.bind.adapter.JsonbAdapter;
import javax.json.bind.annotation.JsonbTypeDeserializer;
import javax.json.bind.annotation.JsonbTypeSerializer;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.bind.serializer.JsonbSerializer;
import org.eclipse.yasson.JsonBindingProvider;
import org.eclipse.yasson.spi.JsonbComponentInstanceCreator;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class JsonbProcessor {
    static final DotName JSONB_ADAPTER_NAME = DotName.createSimple((String)JsonbAdapter.class.getName());
    private static final DotName JSONB_TYPE_SERIALIZER = DotName.createSimple((String)JsonbTypeSerializer.class.getName());
    private static final DotName JSONB_TYPE_DESERIALIZER = DotName.createSimple((String)JsonbTypeDeserializer.class.getName());

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("io.quarkus.jsonb");
    }

    @BuildStep
    void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<AdditionalBeanBuildItem> additionalBeans, CombinedIndexBuildItem combinedIndexBuildItem) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{JsonBindingProvider.class.getName()}));
        resourceBundle.produce((BuildItem)new NativeImageResourceBundleBuildItem("yasson-messages"));
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(JsonbComponentInstanceCreator.class.getName(), new String[]{QuarkusJsonbComponentInstanceCreator.class.getName()}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{JsonbProducer.class}));
        IndexView index = combinedIndexBuildItem.getIndex();
        for (AnnotationInstance serializeInstance : index.getAnnotations(JSONB_TYPE_SERIALIZER)) {
            this.registerInstance(reflectiveClass, serializeInstance);
        }
        for (AnnotationInstance deserializeInstance : index.getAnnotations(JSONB_TYPE_DESERIALIZER)) {
            this.registerInstance(reflectiveClass, deserializeInstance);
        }
    }

    private void registerInstance(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, AnnotationInstance instance) {
        AnnotationValue value;
        AnnotationTarget annotationTarget = instance.target();
        if ((AnnotationTarget.Kind.FIELD.equals((Object)annotationTarget.kind()) || AnnotationTarget.Kind.METHOD.equals((Object)annotationTarget.kind())) && (value = instance.value()) != null) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{value.asClass().toString()}));
        }
    }

    @BuildStep
    void unremovableJsonbAdapters(BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BeanArchiveIndexBuildItem beanArchiveIndex) {
        unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo bean) {
                return bean.isClassBean() && bean.hasType(JSONB_ADAPTER_NAME);
            }
        }));
    }

    @BuildStep
    void generateCustomizer(BuildProducer<GeneratedBeanBuildItem> generatedBeans, List<JsonbSerializerBuildItem> serializers, List<JsonbDeserializerBuildItem> deserializers) {
        if (serializers.isEmpty()) {
            return;
        }
        HashSet customSerializerClasses = new HashSet();
        HashSet customDeserializerClasses = new HashSet();
        for (JsonbSerializerBuildItem serializer : serializers) {
            customSerializerClasses.addAll(serializer.getSerializerClassNames());
        }
        for (JsonbDeserializerBuildItem deserializer : deserializers) {
            customDeserializerClasses.addAll(deserializer.getDeserializerClassNames());
        }
        if (customSerializerClasses.isEmpty() && customDeserializerClasses.isEmpty()) {
            return;
        }
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className("io.quarkus.jsonb.customizer.RegisterSerializersAndDeserializersCustomizer").interfaces(new String[]{JsonbConfigCustomizer.class.getName()}).build();){
            classCreator.addAnnotation(Singleton.class);
            try (MethodCreator customize = classCreator.getMethodCreator("customize", Void.TYPE, new Class[]{JsonbConfig.class});){
                int i;
                ResultHandle jsonbConfig = customize.getMethodParam(0);
                if (!customSerializerClasses.isEmpty()) {
                    ResultHandle serializersArray = customize.newArray(JsonbSerializer.class, customSerializerClasses.size());
                    i = 0;
                    for (String customSerializerClass : customSerializerClasses) {
                        customize.writeArrayValue(serializersArray, i, customize.newInstance(MethodDescriptor.ofConstructor((String)customSerializerClass, (String[])new String[0]), new ResultHandle[0]));
                        ++i;
                    }
                    customize.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonbConfig.class, (String)"withSerializers", JsonbConfig.class, (Class[])new Class[]{JsonbSerializer[].class}), jsonbConfig, new ResultHandle[]{serializersArray});
                }
                if (!customDeserializerClasses.isEmpty()) {
                    ResultHandle deserializersArray = customize.newArray(JsonbDeserializer.class, customDeserializerClasses.size());
                    i = 0;
                    for (String customDeserializerClass : customDeserializerClasses) {
                        customize.writeArrayValue(deserializersArray, i, customize.newInstance(MethodDescriptor.ofConstructor((String)customDeserializerClass, (String[])new String[0]), new ResultHandle[0]));
                        ++i;
                    }
                    customize.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonbConfig.class, (String)"withDeserializers", JsonbConfig.class, (Class[])new Class[]{JsonbDeserializer[].class}), jsonbConfig, new ResultHandle[]{deserializersArray});
                }
                customize.returnValue(null);
            }
        }
    }
}

