/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit4;

import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestResourceManager;
import java.util.ArrayList;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

abstract class AbstractQuarkusRunListener
extends RunListener {
    private final Class<?> testClass;
    private final RunNotifier runNotifier;
    private TestResourceManager testResourceManager;
    private boolean started = false;
    private boolean failed = false;
    private final RestAssuredURLManager restAssuredURLManager;

    protected AbstractQuarkusRunListener(Class<?> testClass, RunNotifier runNotifier) {
        this.testClass = testClass;
        this.runNotifier = runNotifier;
        this.testResourceManager = new TestResourceManager(testClass);
        this.restAssuredURLManager = new RestAssuredURLManager(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(Description description) throws Exception {
        this.restAssuredURLManager.setURL();
        if (!this.started) {
            ArrayList<RunListener> stopListeners = new ArrayList<RunListener>();
            try {
                try {
                    this.testResourceManager.start();
                }
                catch (Exception e) {
                    this.failed = true;
                    throw e;
                }
                stopListeners.add(0, new RunListener(){

                    public void testRunFinished(Result result) throws Exception {
                        AbstractQuarkusRunListener.this.testResourceManager.stop();
                    }
                });
                try {
                    this.startQuarkus();
                    this.started = true;
                    stopListeners.add(0, new RunListener(){

                        public void testRunFinished(Result result) throws Exception {
                            try {
                                AbstractQuarkusRunListener.this.stopQuarkus();
                            }
                            catch (Exception e) {
                                System.err.println("Unable to stop Quarkus");
                            }
                        }
                    });
                }
                catch (Exception e) {
                    this.failed = true;
                    throw new RuntimeException("Unable to boot Quarkus", e);
                }
            }
            finally {
                for (RunListener stopListener : stopListeners) {
                    this.runNotifier.addListener(stopListener);
                }
            }
        }
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        this.restAssuredURLManager.clearURL();
    }

    public void inject(Object testInstance) {
        this.testResourceManager.inject(testInstance);
    }

    protected abstract void startQuarkus() throws Exception;

    protected abstract void stopQuarkus() throws Exception;

    protected Class<?> getTestClass() {
        return this.testClass;
    }

    protected boolean isFailed() {
        return this.failed;
    }

    protected RunNotifier getRunNotifier() {
        return this.runNotifier;
    }
}

