/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit4;

import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit4.AbstractQuarkusRunListener;
import java.util.function.BiFunction;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

abstract class AbstractQuarkusTestRunner
extends BlockJUnit4ClassRunner {
    private static boolean first = true;
    protected static AbstractQuarkusRunListener quarkusRunListener;
    private final BiFunction<Class<?>, RunNotifier, AbstractQuarkusRunListener> quarkusRunListenerSupplier;

    public AbstractQuarkusTestRunner(Class<?> klass, BiFunction<Class<?>, RunNotifier, AbstractQuarkusRunListener> quarkusRunListenerSupplier) throws InitializationError {
        super(klass);
        this.quarkusRunListenerSupplier = quarkusRunListenerSupplier;
    }

    public void run(RunNotifier notifier) {
        if (first) {
            first = false;
            quarkusRunListener = this.quarkusRunListenerSupplier.apply(this.getTestClass().getJavaClass(), notifier);
            notifier.addListener((RunListener)quarkusRunListener);
        }
        super.run(notifier);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (!quarkusRunListener.isFailed()) {
            super.runChild(method, notifier);
        } else {
            notifier.fireTestIgnored(this.describeChild(method));
        }
    }

    protected Object createTest() throws Exception {
        Object instance = super.createTest();
        TestHTTPResourceManager.inject((Object)instance);
        return instance;
    }
}

