/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit4;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.builditem.TestAnnotationBuildItem;
import io.quarkus.runner.RuntimeRunner;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.TestInjectionManager;
import io.quarkus.test.common.TestInstantiator;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit4.AbstractQuarkusRunListener;
import io.quarkus.test.junit4.AbstractQuarkusTestRunner;
import java.io.IOException;
import java.util.function.Consumer;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class QuarkusTest
extends AbstractQuarkusTestRunner {
    public QuarkusTest(Class<?> klass) throws InitializationError {
        super(klass, (c, n) -> new QuarkusRunListener((Class<?>)c, (RunNotifier)n));
    }

    @Override
    protected Object createTest() throws Exception {
        Object instance = TestInstantiator.instantiateTest((Class)this.getTestClass().getJavaClass());
        TestHTTPResourceManager.inject((Object)instance);
        TestInjectionManager.inject((Object)instance);
        quarkusRunListener.inject(instance);
        return instance;
    }

    private static class QuarkusRunListener
    extends AbstractQuarkusRunListener {
        private RuntimeRunner runtimeRunner;

        QuarkusRunListener(Class<?> testClass, RunNotifier runNotifier) {
            super(testClass, runNotifier);
        }

        @Override
        protected void startQuarkus() {
            PropertyTestUtil.setLogFileProperty();
            this.runtimeRunner = RuntimeRunner.builder().setLaunchMode(LaunchMode.TEST).setClassLoader(((Object)((Object)this)).getClass().getClassLoader()).setTarget(PathTestHelper.getAppClassLocation(this.getTestClass())).setFrameworkClassesPath(PathTestHelper.getTestClassesLocation(this.getTestClass())).addChainCustomizer((Consumer)new Consumer<BuildChainBuilder>(){

                @Override
                public void accept(BuildChainBuilder buildChainBuilder) {
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new TestAnnotationBuildItem(RunWith.class.getName()));
                        }
                    }).produces(TestAnnotationBuildItem.class).build();
                }
            }).build();
            this.runtimeRunner.run();
        }

        @Override
        protected void stopQuarkus() throws IOException {
            this.runtimeRunner.close();
        }
    }
}

