/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.test.component.MockBeanConfigurator;
import io.quarkus.test.component.MockBeanConfiguratorImpl;
import io.quarkus.test.component.QuarkusComponentTestConfiguration;
import io.quarkus.test.component.QuarkusComponentTestExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuarkusComponentTestExtensionBuilder {
    public static final int DEFAULT_CONFIG_SOURCE_ORDINAL = 500;
    private final Map<String, String> configProperties = new HashMap<String, String>();
    private final List<Class<?>> componentClasses = new ArrayList();
    private final List<MockBeanConfiguratorImpl<?>> mockConfigurators = new ArrayList();
    private final List<AnnotationsTransformer> annotationsTransformers = new ArrayList<AnnotationsTransformer>();
    private boolean useDefaultConfigProperties = false;
    private boolean addNestedClassesAsComponents = true;
    private int configSourceOrdinal = 500;

    public QuarkusComponentTestExtensionBuilder addComponentClasses(Class<?> ... componentClasses) {
        Collections.addAll(this.componentClasses, componentClasses);
        return this;
    }

    public QuarkusComponentTestExtensionBuilder configProperty(String key, String value) {
        this.configProperties.put(key, value);
        return this;
    }

    public QuarkusComponentTestExtensionBuilder useDefaultConfigProperties() {
        this.useDefaultConfigProperties = true;
        return this;
    }

    public QuarkusComponentTestExtensionBuilder ignoreNestedClasses() {
        this.addNestedClassesAsComponents = false;
        return this;
    }

    public QuarkusComponentTestExtensionBuilder setConfigSourceOrdinal(int val) {
        this.configSourceOrdinal = val;
        return this;
    }

    public QuarkusComponentTestExtensionBuilder addAnnotationsTransformer(AnnotationsTransformer transformer) {
        this.annotationsTransformers.add(transformer);
        return this;
    }

    public <T> MockBeanConfigurator<T> mock(Class<T> beanClass) {
        return new MockBeanConfiguratorImpl(this, beanClass);
    }

    public QuarkusComponentTestExtension build() {
        return new QuarkusComponentTestExtension(new QuarkusComponentTestConfiguration(Map.copyOf(this.configProperties), List.copyOf(this.componentClasses), List.copyOf(this.mockConfigurators), this.useDefaultConfigProperties, this.addNestedClassesAsComponents, this.configSourceOrdinal, List.copyOf(this.annotationsTransformers)));
    }

    void registerMockBean(MockBeanConfiguratorImpl<?> mock) {
        this.mockConfigurators.add(mock);
    }
}

