/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.test.InjectMock;
import io.quarkus.test.component.MockBeanConfiguratorImpl;
import io.quarkus.test.component.QuarkusComponentTest;
import io.quarkus.test.component.QuarkusComponentTestExtension;
import io.quarkus.test.component.SkipInject;
import io.quarkus.test.component.TestConfigProperty;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanContainer;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

class QuarkusComponentTestConfiguration {
    static final QuarkusComponentTestConfiguration DEFAULT = new QuarkusComponentTestConfiguration(Map.of(), List.of(), List.of(), false, true, 500, List.of());
    private static final Logger LOG = Logger.getLogger(QuarkusComponentTestConfiguration.class);
    final Map<String, String> configProperties;
    final List<Class<?>> componentClasses;
    final List<MockBeanConfiguratorImpl<?>> mockConfigurators;
    final boolean useDefaultConfigProperties;
    final boolean addNestedClassesAsComponents;
    final int configSourceOrdinal;
    final List<AnnotationsTransformer> annotationsTransformers;

    QuarkusComponentTestConfiguration(Map<String, String> configProperties, List<Class<?>> componentClasses, List<MockBeanConfiguratorImpl<?>> mockConfigurators, boolean useDefaultConfigProperties, boolean addNestedClassesAsComponents, int configSourceOrdinal, List<AnnotationsTransformer> annotationsTransformers) {
        this.configProperties = configProperties;
        this.componentClasses = componentClasses;
        this.mockConfigurators = mockConfigurators;
        this.useDefaultConfigProperties = useDefaultConfigProperties;
        this.addNestedClassesAsComponents = addNestedClassesAsComponents;
        this.configSourceOrdinal = configSourceOrdinal;
        this.annotationsTransformers = annotationsTransformers;
    }

    QuarkusComponentTestConfiguration update(Class<?> testClass) {
        HashMap<String, String> configProperties = new HashMap<String, String>(this.configProperties);
        ArrayList componentClasses = new ArrayList(this.componentClasses);
        boolean useDefaultConfigProperties = this.useDefaultConfigProperties;
        boolean addNestedClassesAsComponents = this.addNestedClassesAsComponents;
        int configSourceOrdinal = this.configSourceOrdinal;
        ArrayList<AnnotationsTransformer> annotationsTransformers = new ArrayList<AnnotationsTransformer>(this.annotationsTransformers);
        QuarkusComponentTest testAnnotation = testClass.getAnnotation(QuarkusComponentTest.class);
        if (testAnnotation != null) {
            Collections.addAll(componentClasses, testAnnotation.value());
            useDefaultConfigProperties = testAnnotation.useDefaultConfigProperties();
            addNestedClassesAsComponents = testAnnotation.addNestedClassesAsComponents();
            configSourceOrdinal = testAnnotation.configSourceOrdinal();
            Class<? extends AnnotationsTransformer>[] transformers = testAnnotation.annotationsTransformers();
            if (transformers.length > 0) {
                for (AnnotatedElement annotatedElement : transformers) {
                    try {
                        annotationsTransformers.add((AnnotationsTransformer)((Class)annotatedElement).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Exception e) {
                        LOG.errorf("Unable to instantiate %s", (Object)annotatedElement);
                    }
                }
            }
        }
        for (Class<?> current = testClass; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Inject.class) || QuarkusComponentTestConfiguration.resolvesToBuiltinBean(field.getType())) continue;
                componentClasses.add(field.getType());
            }
            if (addNestedClassesAsComponents) {
                for (AnnotatedElement annotatedElement : current.getDeclaredClasses()) {
                    if (!Modifier.isStatic(((Class)annotatedElement).getModifiers())) continue;
                    componentClasses.add((Class<?>)annotatedElement);
                }
            }
            for (AnnotatedElement annotatedElement : current.getDeclaredMethods()) {
                if (!QuarkusComponentTestExtension.isTestMethod((Executable)annotatedElement)) continue;
                for (Parameter param : ((Executable)annotatedElement).getParameters()) {
                    if (QuarkusComponentTestExtension.BUILTIN_PARAMETER.test(param) || param.isAnnotationPresent(InjectMock.class) || param.isAnnotationPresent(SkipInject.class)) continue;
                    componentClasses.add(param.getType());
                }
            }
        }
        ArrayList testConfigProperties = new ArrayList();
        Collections.addAll(testConfigProperties, (TestConfigProperty[])testClass.getAnnotationsByType(TestConfigProperty.class));
        for (TestConfigProperty testConfigProperty : testConfigProperties) {
            configProperties.put(testConfigProperty.key(), testConfigProperty.value());
        }
        return new QuarkusComponentTestConfiguration(Map.copyOf(configProperties), List.copyOf(componentClasses), this.mockConfigurators, useDefaultConfigProperties, addNestedClassesAsComponents, configSourceOrdinal, List.copyOf(annotationsTransformers));
    }

    QuarkusComponentTestConfiguration update(Method testMethod) {
        HashMap<String, String> configProperties = new HashMap<String, String>(this.configProperties);
        ArrayList testConfigProperties = new ArrayList();
        Collections.addAll(testConfigProperties, (TestConfigProperty[])testMethod.getAnnotationsByType(TestConfigProperty.class));
        for (TestConfigProperty testConfigProperty : testConfigProperties) {
            configProperties.put(testConfigProperty.key(), testConfigProperty.value());
        }
        return new QuarkusComponentTestConfiguration(configProperties, this.componentClasses, this.mockConfigurators, this.useDefaultConfigProperties, this.addNestedClassesAsComponents, this.configSourceOrdinal, this.annotationsTransformers);
    }

    private static boolean resolvesToBuiltinBean(Class<?> rawType) {
        return Provider.class.equals(rawType) || Instance.class.equals(rawType) || InjectableInstance.class.equals(rawType) || Event.class.equals(rawType) || BeanContainer.class.equals(rawType) || BeanManager.class.equals(rawType);
    }
}

