/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test;

import io.quarkus.deployment.util.FileUtil;
import io.quarkus.dev.CompilationProvider;
import io.quarkus.dev.DevModeContext;
import io.quarkus.dev.DevModeMain;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstantiationException;

public class QuarkusDevModeTest
implements BeforeEachCallback,
AfterEachCallback,
TestInstanceFactory {
    boolean started = false;
    private DevModeMain devModeMain;
    private Path deploymentDir;
    private Supplier<JavaArchive> archiveProducer;
    private String logFileName;
    private Path deploymentSourcePath;
    private Path deploymentResourcePath;
    private Path projectSourceRoot;
    private Path testLocation;
    private static final List<CompilationProvider> compilationProviders;

    public Supplier<JavaArchive> getArchiveProducer() {
        return this.archiveProducer;
    }

    public QuarkusDevModeTest setArchiveProducer(Supplier<JavaArchive> archiveProducer) {
        this.archiveProducer = archiveProducer;
        return this;
    }

    public QuarkusDevModeTest setLogFileName(String logFileName) {
        this.logFileName = logFileName;
        return this;
    }

    public Object createTestInstance(TestInstanceFactoryContext factoryContext, ExtensionContext extensionContext) throws TestInstantiationException {
        try {
            Object actualTestInstance = factoryContext.getTestClass().newInstance();
            TestHTTPResourceManager.inject(actualTestInstance);
            return actualTestInstance;
        }
        catch (Exception e) {
            throw new TestInstantiationException("Unable to create test proxy", (Throwable)e);
        }
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        if (this.archiveProducer == null) {
            throw new RuntimeException("QuarkusDevModeTest does not have archive producer set");
        }
        if (this.logFileName != null) {
            PropertyTestUtil.setLogFileProperty((String)this.logFileName);
        } else {
            PropertyTestUtil.setLogFileProperty();
        }
        ExtensionContext.Store store = extensionContext.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
        if (store.get((Object)TestResourceManager.class.getName()) == null) {
            final TestResourceManager manager = new TestResourceManager(extensionContext.getRequiredTestClass());
            manager.start();
            store.put((Object)TestResourceManager.class.getName(), (Object)new ExtensionContext.Store.CloseableResource(){

                public void close() throws Throwable {
                    manager.stop();
                }
            });
        }
        Class testClass = extensionContext.getRequiredTestClass();
        try {
            this.deploymentDir = Files.createTempDirectory("quarkus-dev-mode-test", new FileAttribute[0]);
            this.testLocation = PathTestHelper.getTestClassesLocation((Class)testClass);
            String sourcePath = System.getProperty("quarkus.test.source-path");
            this.projectSourceRoot = sourcePath == null ? this.testLocation.getParent().getParent().resolve("src/test/java") : Paths.get(sourcePath, new String[0]);
            DevModeContext context = this.exportArchive(this.deploymentDir, this.projectSourceRoot);
            context.setTest(true);
            context.setAbortOnFailedStart(true);
            this.devModeMain = new DevModeMain(context);
            this.devModeMain.start();
            this.started = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterEach(ExtensionContext extensionContext) throws Exception {
        try {
            if (this.devModeMain != null) {
                this.devModeMain.close();
                this.devModeMain = null;
            }
            if (this.deploymentDir == null) return;
        }
        catch (Throwable throwable) {
            if (this.deploymentDir == null) throw throwable;
            Files.walkFileTree(this.deploymentDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            throw throwable;
        }
        Files.walkFileTree(this.deploymentDir, (FileVisitor<? super Path>)new /* invalid duplicate definition of identical inner class */);
    }

    private DevModeContext exportArchive(Path deploymentDir, Path testSourceDir) {
        try {
            this.deploymentSourcePath = deploymentDir.resolve("src/main/java");
            this.deploymentResourcePath = deploymentDir.resolve("src/main/resources");
            Path classes = deploymentDir.resolve("target/classes");
            Path cache = deploymentDir.resolve("target/dev-cache");
            Files.createDirectories(this.deploymentSourcePath, new FileAttribute[0]);
            Files.createDirectories(this.deploymentResourcePath, new FileAttribute[0]);
            Files.createDirectories(classes, new FileAttribute[0]);
            Files.createDirectories(cache, new FileAttribute[0]);
            JavaArchive archive = this.archiveProducer.get();
            ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExplodedInto(classes.toFile());
            this.copyFromSource(testSourceDir, this.deploymentSourcePath, classes);
            try (Stream<Path> stream = Files.walk(classes, new FileVisitOption[0]);){
                stream.forEach(s -> {
                    if (s.toString().endsWith(".class") || Files.isDirectory(s, new LinkOption[0])) {
                        return;
                    }
                    String relative = classes.relativize((Path)s).toString();
                    try (InputStream in = Files.newInputStream(s, new OpenOption[0]);){
                        byte[] data = FileUtil.readFileContents((InputStream)in);
                        Path resolved = this.deploymentResourcePath.resolve(relative);
                        Files.createDirectories(resolved.getParent(), new FileAttribute[0]);
                        Files.write(resolved, data, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            String exportPath = System.getProperty("quarkus.deploymentExportPath");
            if (exportPath != null) {
                File exportDir = new File(exportPath);
                if (exportDir.exists()) {
                    if (!exportDir.isDirectory()) {
                        throw new IllegalStateException("Export path is not a directory: " + exportPath);
                    }
                    try (Stream<Path> stream = Files.walk(exportDir.toPath(), new FileVisitOption[0]);){
                        stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                } else if (!exportDir.mkdirs()) {
                    throw new IllegalStateException("Export path could not be created: " + exportPath);
                }
                File exportFile = new File(exportDir, archive.getName());
                ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exportFile);
            }
            DevModeContext context = new DevModeContext();
            context.setCacheDir(cache.toFile());
            context.getClassesRoots().add(classes.toFile());
            context.getModules().add(new DevModeContext.ModuleInfo("default", deploymentDir.toAbsolutePath().toString(), Collections.singleton(this.deploymentSourcePath.toAbsolutePath().toString()), classes.toAbsolutePath().toString(), this.deploymentResourcePath.toAbsolutePath().toString()));
            return context;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create the archive", e);
        }
    }

    public void modifySourceFile(String sourceFile, Function<String, String> mutator) {
        this.modifyFile(sourceFile, mutator, this.deploymentSourcePath);
    }

    public void modifySourceFile(Class<?> sourceFile, Function<String, String> mutator) {
        this.modifyFile(sourceFile.getSimpleName() + ".java", mutator, this.deploymentSourcePath);
    }

    public void addSourceFile(Class<?> sourceFile) {
        Path path = this.copySourceFilesForClass(this.projectSourceRoot, this.deploymentSourcePath, this.testLocation, this.testLocation.resolve(sourceFile.getName().replace(".", "/") + ".class"));
        this.sleepForFileChanges(path);
    }

    void modifyFile(String name, Function<String, String> mutator, Path path) {
        try (Stream<Path> sources = Files.walk(path, new FileVisitOption[0]);){
            sources.forEach(s -> {
                if (s.endsWith(name)) {
                    try {
                        byte[] data;
                        try (InputStream in = Files.newInputStream(s, new OpenOption[0]);){
                            data = FileUtil.readFileContents((InputStream)in);
                        }
                        String content = new String(data, StandardCharsets.UTF_8);
                        content = (String)mutator.apply(content);
                        this.sleepForFileChanges(path);
                        Files.write(s, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void sleepForFileChanges(Path path) {
        try {
            long fm;
            long timeToBeat = Math.max(System.currentTimeMillis(), Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
            do {
                Files.setLastModifiedTime(path, FileTime.fromMillis(System.currentTimeMillis()));
                fm = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                Thread.sleep(10L);
            } while (fm <= timeToBeat);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void modifyResourceFile(String path, Function<String, String> mutator) {
        try {
            byte[] data;
            Path resourcePath = this.deploymentResourcePath.resolve(path);
            try (InputStream in = Files.newInputStream(resourcePath, new OpenOption[0]);){
                data = FileUtil.readFileContents((InputStream)in);
            }
            String content = new String(data, StandardCharsets.UTF_8);
            content = mutator.apply(content);
            Files.write(resourcePath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.sleepForFileChanges(resourcePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void addResourceFile(String path, byte[] data) {
        try {
            Files.write(this.deploymentResourcePath.resolve(path), data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void deleteResourceFile(String path) {
        try {
            Files.delete(this.deploymentResourcePath.resolve(path));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void addResourceFile(String path, String data) {
        this.addResourceFile(path, data.getBytes(StandardCharsets.UTF_8));
    }

    private void copyFromSource(Path projectSourcesDir, Path deploymentSourcesDir, Path classesDir) throws IOException {
        try (Stream<Path> classes = Files.walk(classesDir, new FileVisitOption[0]);){
            classes.forEach(c -> {
                if (Files.isDirectory(c, new LinkOption[0]) || !c.toString().endsWith(".class")) {
                    return;
                }
                this.copySourceFilesForClass(projectSourcesDir, deploymentSourcesDir, classesDir, (Path)c);
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path copySourceFilesForClass(Path projectSourcesDir, Path deploymentSourcesDir, Path classesDir, Path classFile) {
        CompilationProvider provider;
        Path source;
        Iterator<CompilationProvider> iterator = compilationProviders.iterator();
        do {
            if (!iterator.hasNext()) return null;
        } while ((source = (provider = iterator.next()).getSourcePath(classFile, Collections.singleton(projectSourcesDir.toAbsolutePath().toString()), classesDir.toAbsolutePath().toString())) == null);
        String relative = projectSourcesDir.relativize(source).toString();
        try (InputStream in = Files.newInputStream(source, new OpenOption[0]);){
            byte[] data = FileUtil.readFileContents((InputStream)in);
            Path resolved = deploymentSourcesDir.resolve(relative);
            Files.createDirectories(resolved.getParent(), new FileAttribute[0]);
            Files.write(resolved, data, new OpenOption[0]);
            Path path = resolved;
            return path;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        ArrayList<CompilationProvider> providers = new ArrayList<CompilationProvider>();
        for (CompilationProvider provider : ServiceLoader.load(CompilationProvider.class)) {
            providers.add(provider);
        }
        compilationProviders = Collections.unmodifiableList(providers);
    }
}

