/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.proxy.ProxyConfiguration;
import io.quarkus.deployment.proxy.ProxyFactory;
import io.quarkus.runner.RuntimeRunner;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.test.DefineClassVisibleClassLoader;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstantiationException;

public class QuarkusUnitTest
implements BeforeAllCallback,
AfterAllCallback,
TestInstanceFactory,
BeforeEachCallback,
AfterEachCallback {
    boolean started = false;
    private RuntimeRunner runtimeRunner;
    private Path deploymentDir;
    private Consumer<Throwable> assertException;
    private Supplier<JavaArchive> archiveProducer;
    private List<Consumer<BuildChainBuilder>> buildChainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>();
    private Runnable afterUndeployListener;
    private String logFileName;
    private static final Timer timeoutTimer;
    private volatile TimerTask timeoutTask;
    private Properties customApplicationProperties;
    private final RestAssuredURLManager restAssuredURLManager;

    public QuarkusUnitTest setExpectedException(Class<? extends Throwable> expectedException) {
        return this.assertException(t -> Assertions.assertEquals((Object)expectedException, t.getClass(), (String)"Build failed with wrong exception"));
    }

    public QuarkusUnitTest() {
        this(false);
    }

    public static QuarkusUnitTest withSecuredConnection() {
        return new QuarkusUnitTest(true);
    }

    private QuarkusUnitTest(boolean useSecureConnection) {
        this.restAssuredURLManager = new RestAssuredURLManager(useSecureConnection);
    }

    public QuarkusUnitTest assertException(Consumer<Throwable> assertException) {
        this.assertException = assertException;
        return this;
    }

    public Supplier<JavaArchive> getArchiveProducer() {
        return this.archiveProducer;
    }

    public QuarkusUnitTest setArchiveProducer(Supplier<JavaArchive> archiveProducer) {
        Objects.requireNonNull(archiveProducer);
        this.archiveProducer = archiveProducer;
        return this;
    }

    public QuarkusUnitTest addBuildChainCustomizer(Consumer<BuildChainBuilder> customizer) {
        this.buildChainCustomizers.add(customizer);
        return this;
    }

    public QuarkusUnitTest setLogFileName(String logFileName) {
        this.logFileName = logFileName;
        return this;
    }

    public Object createTestInstance(TestInstanceFactoryContext factoryContext, ExtensionContext extensionContext) throws TestInstantiationException {
        try {
            Class testClass = extensionContext.getRequiredTestClass();
            ExtensionContext.Store store = extensionContext.getStore(ExtensionContext.Namespace.GLOBAL);
            final Object actualTestInstance = store.get((Object)testClass.getName());
            if (actualTestInstance != null) {
                TestHTTPResourceManager.inject((Object)actualTestInstance);
            }
            ProxyFactory proxyFactory = (ProxyFactory)store.get((Object)this.proxyFactoryKey(testClass));
            return proxyFactory.newInstance(new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (QuarkusUnitTest.this.assertException != null) {
                        return null;
                    }
                    Method realMethod = actualTestInstance.getClass().getMethod(method.getName(), method.getParameterTypes());
                    return realMethod.invoke(actualTestInstance, args);
                }
            });
        }
        catch (Exception e) {
            throw new TestInstantiationException("Unable to create test proxy", (Throwable)e);
        }
    }

    private void exportArchive(Path deploymentDir, Class<?> testClass) {
        try {
            JavaArchive archive = this.getArchiveProducerOrDefault();
            archive.addClass(testClass);
            if (this.customApplicationProperties != null) {
                archive.add((Asset)new PropertiesAsset(this.customApplicationProperties), "application.properties");
            }
            ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExplodedInto(deploymentDir.toFile());
            String exportPath = System.getProperty("quarkus.deploymentExportPath");
            if (exportPath != null) {
                File exportDir = new File(exportPath);
                if (exportDir.exists()) {
                    if (!exportDir.isDirectory()) {
                        throw new IllegalStateException("Export path is not a directory: " + exportPath);
                    }
                    try (Stream<Path> stream = Files.walk(exportDir.toPath(), new FileVisitOption[0]);){
                        stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                } else if (!exportDir.mkdirs()) {
                    throw new IllegalStateException("Export path could not be created: " + exportPath);
                }
                File exportFile = new File(exportDir, archive.getName());
                ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exportFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create the archive", e);
        }
    }

    private JavaArchive getArchiveProducerOrDefault() {
        if (this.archiveProducer == null) {
            return (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        }
        return this.archiveProducer.get();
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        block20: {
            Class testClass;
            this.timeoutTask = new TimerTask(){

                @Override
                public void run() {
                    System.err.println("Test has been running for more than 5 minutes, thread dump is:");
                    for (Map.Entry<Thread, StackTraceElement[]> i : Thread.getAllStackTraces().entrySet()) {
                        System.err.println("\n");
                        System.err.println(i.toString());
                        System.err.println("\n");
                        for (StackTraceElement j : i.getValue()) {
                            System.err.println(j);
                        }
                    }
                }
            };
            timeoutTimer.schedule(this.timeoutTask, 300000L);
            if (this.logFileName != null) {
                PropertyTestUtil.setLogFileProperty((String)this.logFileName);
            } else {
                PropertyTestUtil.setLogFileProperty();
            }
            ExtensionContext.Store store = extensionContext.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
            if (store.get((Object)TestResourceManager.class.getName()) == null) {
                final TestResourceManager manager = new TestResourceManager(extensionContext.getRequiredTestClass());
                manager.start();
                store.put((Object)TestResourceManager.class.getName(), (Object)new ExtensionContext.Store.CloseableResource(){

                    public void close() throws Throwable {
                        manager.stop();
                    }
                });
            }
            if (store.get((Object)this.proxyFactoryKey(testClass = extensionContext.getRequiredTestClass())) == null) {
                ProxyFactory factory = new ProxyFactory(new ProxyConfiguration().setAnchorClass(testClass).setProxyNameSuffix("$$QuarkusUnitTestProxy").setClassLoader((ClassLoader)new DefineClassVisibleClassLoader(testClass.getClassLoader())).setSuperClass(testClass));
                store.put((Object)this.proxyFactoryKey(testClass), (Object)factory);
            }
            try {
                this.deploymentDir = Files.createTempDirectory("quarkus-unit-test", new FileAttribute[0]);
                this.exportArchive(this.deploymentDir, testClass);
                ArrayList<Consumer<BuildChainBuilder>> customizers = new ArrayList<Consumer<BuildChainBuilder>>(this.buildChainCustomizers);
                try {
                    final Class<BuildItem> buildItem = Class.forName("io.quarkus.arc.deployment.AdditionalBeanBuildItem").asSubclass(BuildItem.class);
                    customizers.add(new Consumer<BuildChainBuilder>(){

                        @Override
                        public void accept(BuildChainBuilder buildChainBuilder) {
                            buildChainBuilder.addBuildStep(new BuildStep(){

                                public void execute(BuildContext context) {
                                    try {
                                        Method factoryMethod = buildItem.getMethod("unremovableOf", Class.class);
                                        context.produce((BuildItem)factoryMethod.invoke(null, testClass));
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            }).produces(buildItem).build();
                        }
                    });
                }
                catch (ClassNotFoundException buildItem) {
                    // empty catch block
                }
                Path testLocation = PathTestHelper.getTestClassesLocation((Class)testClass);
                this.runtimeRunner = RuntimeRunner.builder().setLaunchMode(LaunchMode.TEST).setClassLoader(testClass.getClassLoader()).setTarget(this.deploymentDir).excludeFromIndexing(testLocation).setFrameworkClassesPath(testLocation).addChainCustomizers(customizers).build();
                try {
                    Instance factory;
                    this.runtimeRunner.run();
                    if (this.assertException != null) {
                        Assertions.fail((String)"The build was expected to fail");
                    }
                    this.started = true;
                    System.setProperty("test.url", TestHTTPResourceManager.getUri());
                    try {
                        factory = CDI.current().select(Class.forName(testClass.getName(), true, Thread.currentThread().getContextClassLoader()), new Annotation[0]);
                    }
                    catch (Exception e) {
                        throw new TestInstantiationException("Failed to create test instance", (Throwable)e);
                    }
                    Object actualTest = factory.get();
                    extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)testClass.getName(), actualTest);
                }
                catch (Throwable e) {
                    this.started = false;
                    if (this.assertException != null) {
                        if (e instanceof RuntimeException) {
                            Throwable cause = e.getCause();
                            if (cause != null && cause instanceof BuildException) {
                                this.assertException.accept(cause.getCause());
                            } else if (cause != null) {
                                this.assertException.accept(cause);
                            } else {
                                Assertions.fail((String)("Unable to unwrap the build exception from: " + e));
                            }
                        } else {
                            Assertions.fail((String)("Unable to unwrap the build exception from: " + e));
                        }
                        break block20;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String proxyFactoryKey(Class<?> testClass) {
        return testClass + "proxyFactory";
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        try {
            if (this.runtimeRunner != null) {
                this.runtimeRunner.close();
            }
            if (this.afterUndeployListener != null) {
                this.afterUndeployListener.run();
            }
            this.timeoutTask.cancel();
        }
        catch (Throwable throwable) {
            this.timeoutTask.cancel();
            this.timeoutTask = null;
            if (this.deploymentDir != null) {
                Files.walkFileTree(this.deploymentDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (exc == null) {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                        throw exc;
                    }
                });
            }
            throw throwable;
        }
        this.timeoutTask = null;
        if (this.deploymentDir != null) {
            Files.walkFileTree(this.deploymentDir, (FileVisitor<? super Path>)new /* invalid duplicate definition of identical inner class */);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.assertException != null) {
            return;
        }
        this.restAssuredURLManager.clearURL();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.assertException != null) {
            return;
        }
        if (!this.started) {
            Field extensionField;
            Optional testClass = context.getTestClass();
            if (testClass.isPresent() && (extensionField = (Field)Arrays.stream(((Class)testClass.get()).getDeclaredFields()).filter(f -> f.isAnnotationPresent(RegisterExtension.class) && QuarkusUnitTest.class.equals(f.getType())).findAny().orElse(null)) != null && !Modifier.isStatic(extensionField.getModifiers())) {
                throw new IllegalStateException("Test application not started - QuarkusUnitTest must be used with a static field: " + extensionField);
            }
            throw new IllegalStateException("Test application not started for an unknown reason");
        }
        this.restAssuredURLManager.setURL();
    }

    public Runnable getAfterUndeployListener() {
        return this.afterUndeployListener;
    }

    public QuarkusUnitTest setAfterUndeployListener(Runnable afterUndeployListener) {
        this.afterUndeployListener = afterUndeployListener;
        return this;
    }

    public QuarkusUnitTest withConfigurationResource(String resourceName) {
        if (this.customApplicationProperties == null) {
            this.customApplicationProperties = new Properties();
        }
        try {
            try (InputStream in = ClassLoader.getSystemResourceAsStream(resourceName);){
                this.customApplicationProperties.load(in);
            }
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load resource: '" + resourceName + "'");
        }
    }

    public QuarkusUnitTest overrideConfigKey(String propertyKey, String propertyValue) {
        if (this.customApplicationProperties == null) {
            this.customApplicationProperties = new Properties();
        }
        this.customApplicationProperties.put(propertyKey, propertyValue);
        return this;
    }

    static {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        timeoutTimer = new Timer("Test thread dump timer");
    }

    private static class PropertiesAsset
    implements Asset {
        private final Properties props;

        public PropertiesAsset(Properties props) {
            this.props = props;
        }

        public InputStream openStream() {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(128);
            try {
                this.props.store(outputStream, "Unit test Generated Application properties");
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write application properties resource", e);
            }
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
    }
}

