/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.dev.appstate.ApplicationStateNotification;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.test.ExportUtil;
import io.quarkus.test.InMemoryLogHandler;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.stream.Stream;
import org.jboss.logmanager.Logger;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstantiationException;

public class QuarkusDevModeTest
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
TestInstanceFactory {
    private static final Logger rootLogger;
    private Handler[] originalRootLoggerHandlers;
    private DevModeMain devModeMain;
    private Path deploymentDir;
    private Supplier<JavaArchive> archiveProducer;
    private List<String> codeGenSources = Collections.emptyList();
    private String logFileName;
    private InMemoryLogHandler inMemoryLogHandler = new InMemoryLogHandler(r -> false);
    private Path deploymentSourceParentPath;
    private Path deploymentSourcePath;
    private Path deploymentResourcePath;
    private Path projectSourceRoot;
    private Path testLocation;
    private String[] commandLineArgs = new String[0];
    private static final List<CompilationProvider> compilationProviders;

    public Supplier<JavaArchive> getArchiveProducer() {
        return this.archiveProducer;
    }

    public QuarkusDevModeTest setArchiveProducer(Supplier<JavaArchive> archiveProducer) {
        this.archiveProducer = archiveProducer;
        return this;
    }

    public QuarkusDevModeTest setCodeGenSources(String ... codeGenSources) {
        this.codeGenSources = Arrays.asList(codeGenSources);
        return this;
    }

    public QuarkusDevModeTest setLogFileName(String logFileName) {
        this.logFileName = logFileName;
        return this;
    }

    public QuarkusDevModeTest setLogRecordPredicate(Predicate<LogRecord> predicate) {
        this.inMemoryLogHandler = new InMemoryLogHandler(predicate);
        return this;
    }

    public List<LogRecord> getLogRecords() {
        return this.inMemoryLogHandler.records;
    }

    public Object createTestInstance(TestInstanceFactoryContext factoryContext, ExtensionContext extensionContext) throws TestInstantiationException {
        try {
            Object actualTestInstance = factoryContext.getTestClass().newInstance();
            TestHTTPResourceManager.inject(actualTestInstance);
            return actualTestInstance;
        }
        catch (Exception e) {
            throw new TestInstantiationException("Unable to create test proxy", (Throwable)e);
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.originalRootLoggerHandlers = rootLogger.getHandlers();
        rootLogger.addHandler((Handler)this.inMemoryLogHandler);
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        if (this.archiveProducer == null) {
            throw new RuntimeException("QuarkusDevModeTest does not have archive producer set");
        }
        if (this.logFileName != null) {
            PropertyTestUtil.setLogFileProperty((String)this.logFileName);
        } else {
            PropertyTestUtil.setLogFileProperty();
        }
        ExtensionContext.Store store = extensionContext.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
        if (store.get((Object)TestResourceManager.class.getName()) == null) {
            final TestResourceManager manager = new TestResourceManager(extensionContext.getRequiredTestClass());
            manager.init();
            manager.start();
            store.put((Object)TestResourceManager.class.getName(), (Object)new ExtensionContext.Store.CloseableResource(){

                public void close() throws Throwable {
                    manager.close();
                }
            });
        }
        Class testClass = extensionContext.getRequiredTestClass();
        try {
            this.deploymentDir = Files.createTempDirectory("quarkus-dev-mode-test", new FileAttribute[0]);
            this.testLocation = PathTestHelper.getTestClassesLocation((Class)testClass);
            String sourcePath = System.getProperty("quarkus.test.source-path");
            this.projectSourceRoot = sourcePath == null ? this.testLocation.getParent().getParent().resolve("src/test/java") : Paths.get(sourcePath, new String[0]);
            Path projectSourceParent = this.projectSourceRoot.getParent();
            DevModeContext context = this.exportArchive(this.deploymentDir, this.projectSourceRoot, projectSourceParent);
            context.setArgs(this.commandLineArgs);
            context.setTest(true);
            context.setAbortOnFailedStart(true);
            context.getBuildSystemProperties().put("quarkus.banner.enabled", "false");
            this.devModeMain = new DevModeMain(context);
            this.devModeMain.start();
            ApplicationStateNotification.waitForApplicationStart();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        rootLogger.setHandlers(this.originalRootLoggerHandlers);
        this.inMemoryLogHandler.clearRecords();
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        try {
            if (this.devModeMain != null) {
                this.devModeMain.close();
                this.devModeMain = null;
            }
        }
        finally {
            if (this.deploymentDir != null) {
                FileUtil.deleteDirectory((Path)this.deploymentDir);
            }
        }
        rootLogger.removeHandler((Handler)this.inMemoryLogHandler);
    }

    private DevModeContext exportArchive(Path deploymentDir, Path testSourceDir, Path testSourcesParentDir) {
        try {
            this.deploymentSourcePath = deploymentDir.resolve("src/main/java");
            this.deploymentSourceParentPath = deploymentDir.resolve("src/main");
            this.deploymentResourcePath = deploymentDir.resolve("src/main/resources");
            Path classes = deploymentDir.resolve("target/classes");
            Path targetDir = deploymentDir.resolve("target");
            Path cache = deploymentDir.resolve("target/dev-cache");
            Files.createDirectories(this.deploymentSourcePath, new FileAttribute[0]);
            Files.createDirectories(this.deploymentResourcePath, new FileAttribute[0]);
            Files.createDirectories(classes, new FileAttribute[0]);
            Files.createDirectories(cache, new FileAttribute[0]);
            JavaArchive archive = this.archiveProducer.get();
            ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExplodedInto(classes.toFile());
            this.copyFromSource(testSourceDir, this.deploymentSourcePath, classes);
            this.copyCodeGenSources(testSourcesParentDir, this.deploymentSourceParentPath, this.codeGenSources);
            try (Stream<Path> stream = Files.walk(classes, new FileVisitOption[0]);){
                stream.forEach(s -> {
                    if (s.toString().endsWith(".class") || Files.isDirectory(s, new LinkOption[0])) {
                        return;
                    }
                    String relative = classes.relativize((Path)s).toString();
                    try (InputStream in = Files.newInputStream(s, new OpenOption[0]);){
                        byte[] data = FileUtil.readFileContents((InputStream)in);
                        Path resolved = this.deploymentResourcePath.resolve(relative);
                        Files.createDirectories(resolved.getParent(), new FileAttribute[0]);
                        Files.write(resolved, data, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            ExportUtil.exportToQuarkusDeploymentPath(archive);
            DevModeContext context = new DevModeContext();
            context.setCacheDir(cache.toFile());
            context.setApplicationRoot(new DevModeContext.ModuleInfo(AppArtifactKey.fromString((String)"io.quarkus.test:app-under-test"), "default", deploymentDir.toAbsolutePath().toString(), Collections.singleton(this.deploymentSourcePath.toAbsolutePath().toString()), classes.toAbsolutePath().toString(), this.deploymentResourcePath.toAbsolutePath().toString(), this.deploymentSourceParentPath.toAbsolutePath().toString(), targetDir.resolve("generated-sources").toAbsolutePath().toString(), targetDir.toAbsolutePath().toString()));
            QuarkusDevModeTest.setDevModeRunnerJarFile(context);
            return context;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create the archive", e);
        }
    }

    private void copyCodeGenSources(Path testSourcesParent, Path deploymentSourceParentPath, List<String> codeGenSources) {
        for (String codeGenDirName : codeGenSources) {
            Path codeGenSource = testSourcesParent.resolve(codeGenDirName);
            try {
                Path target = deploymentSourceParentPath.resolve(codeGenDirName);
                Stream<Path> files = Files.walk(codeGenSource, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    files.forEach(file -> {
                        Path targetPath = target.resolve(codeGenSource.relativize((Path)file));
                        try {
                            Files.copy(file, targetPath, new CopyOption[0]);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to copy file : " + file + " to " + targetPath.toAbsolutePath().toString());
                        }
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (files == null) continue;
                    if (throwable != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    files.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy code gen directory", e);
            }
        }
    }

    private static void setDevModeRunnerJarFile(DevModeContext context) {
        QuarkusDevModeTest.handleSurefire(context);
        if (context.getDevModeRunnerJarFile() == null) {
            QuarkusDevModeTest.handleIntelliJ(context);
        }
    }

    private static void handleSurefire(DevModeContext context) {
        try {
            boolean foundForkedBooter;
            URL url;
            Enumeration<URL> manifests = QuarkusDevModeTest.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (!(!manifests.hasMoreElements() || (url = manifests.nextElement()).getPath().contains("surefirebooter") && (foundForkedBooter = ((Boolean)ClassPathUtils.readStream((URL)url, is -> {
                try {
                    Manifest manifest = new Manifest((InputStream)is);
                    String mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                    if ("org.apache.maven.surefire.booter.ForkedBooter".equals(mainClass)) {
                        String manifestFilePath = url.getPath();
                        if (manifestFilePath.startsWith("file:")) {
                            String jarFilePath = manifestFilePath.substring(5, manifestFilePath.lastIndexOf(33));
                            File surefirebooterJar = new File(URLDecoder.decode(jarFilePath, StandardCharsets.UTF_8.name()));
                            context.setDevModeRunnerJarFile(surefirebooterJar);
                        }
                        return true;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return false;
            })).booleanValue()))) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void handleIntelliJ(DevModeContext context) {
        try {
            Enumeration<URL> manifests = QuarkusDevModeTest.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL url = manifests.nextElement();
                if (!url.getPath().contains("idea_rt.jar")) continue;
                Path intelliJPath = Paths.get(context.getApplicationRoot().getClassesPath(), new String[0]).getParent().resolve("intellij");
                Path dummyJar = intelliJPath.resolve("dummy.jar");
                FileSystem out = ZipUtils.newZip((Path)dummyJar);
                Throwable throwable = null;
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        out.close();
                    }
                }
                context.setDevModeRunnerJarFile(dummyJar.toFile());
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void modifySourceFile(String sourceFile, Function<String, String> mutator) {
        this.modifyFile(sourceFile, mutator, this.deploymentSourcePath);
    }

    public void modifyFile(String file, Function<String, String> mutator) {
        this.modifyPath(mutator, this.deploymentSourceParentPath, this.deploymentSourceParentPath.resolve(file));
    }

    public void modifySourceFile(Class<?> sourceFile, Function<String, String> mutator) {
        this.modifyFile(sourceFile.getSimpleName() + ".java", mutator, this.deploymentSourcePath);
    }

    public void addSourceFile(Class<?> sourceFile) {
        Path path = this.copySourceFilesForClass(this.projectSourceRoot, this.deploymentSourcePath, this.testLocation, this.testLocation.resolve(sourceFile.getName().replace(".", "/") + ".class"));
        this.sleepForFileChanges(path);
        this.sleepForFileChanges(path.getParent());
    }

    public String[] getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public QuarkusDevModeTest setCommandLineArgs(String[] commandLineArgs) {
        this.commandLineArgs = commandLineArgs;
        return this;
    }

    void modifyFile(String name, Function<String, String> mutator, Path path) {
        AtomicBoolean found = new AtomicBoolean(false);
        try (Stream<Path> sources = Files.walk(path, new FileVisitOption[0]);){
            sources.forEach(s -> {
                if (s.endsWith(name)) {
                    found.set(true);
                    this.modifyPath(mutator, path, (Path)s);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (!found.get()) {
            throw new IllegalArgumentException("File " + name + " was not part of the test application");
        }
    }

    private void modifyPath(Function<String, String> mutator, Path sourceDirectory, Path input) {
        try {
            byte[] data;
            try (InputStream in = Files.newInputStream(input, new OpenOption[0]);){
                data = FileUtil.readFileContents((InputStream)in);
            }
            String oldContent = new String(data, StandardCharsets.UTF_8);
            String content = mutator.apply(oldContent);
            if (content.equals(oldContent)) {
                throw new RuntimeException("File was not modified, mutator function had no effect");
            }
            this.sleepForFileChanges(sourceDirectory);
            Files.write(input, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void sleepForFileChanges(Path path) {
        try {
            long fm;
            long timeToBeat = Math.max(System.currentTimeMillis(), Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
            do {
                Files.setLastModifiedTime(path, FileTime.fromMillis(System.currentTimeMillis()));
                fm = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                Thread.sleep(10L);
            } while (fm <= timeToBeat);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void modifyResourceFile(String path, Function<String, String> mutator) {
        try {
            byte[] data;
            Path resourcePath = this.deploymentResourcePath.resolve(path);
            try (InputStream in = Files.newInputStream(resourcePath, new OpenOption[0]);){
                data = FileUtil.readFileContents((InputStream)in);
            }
            String content = new String(data, StandardCharsets.UTF_8);
            content = mutator.apply(content);
            Files.write(resourcePath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.sleepForFileChanges(resourcePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void addResourceFile(String path, byte[] data) {
        Path resourceFilePath = this.deploymentResourcePath.resolve(path);
        try {
            Files.write(resourceFilePath, data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.sleepForFileChanges(resourceFilePath);
        this.sleepForFileChanges(resourceFilePath.getParent());
    }

    public void deleteResourceFile(String path) {
        Path resourceFilePath = this.deploymentResourcePath.resolve(path);
        long timeout = System.currentTimeMillis() + 5000L;
        while (true) {
            try {
                Files.delete(resourceFilePath);
            }
            catch (IOException e) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() < timeout) continue;
                throw new UncheckedIOException(e);
            }
            break;
        }
        this.sleepForFileChanges(resourceFilePath.getParent());
    }

    public void addResourceFile(String path, String data) {
        this.addResourceFile(path, data.getBytes(StandardCharsets.UTF_8));
    }

    private void copyFromSource(Path projectSourcesDir, Path deploymentSourcesDir, Path classesDir) throws IOException {
        try (Stream<Path> classes = Files.walk(classesDir, new FileVisitOption[0]);){
            classes.forEach(c -> {
                if (Files.isDirectory(c, new LinkOption[0]) || !c.toString().endsWith(".class")) {
                    return;
                }
                this.copySourceFilesForClass(projectSourcesDir, deploymentSourcesDir, classesDir, (Path)c);
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path copySourceFilesForClass(Path projectSourcesDir, Path deploymentSourcesDir, Path classesDir, Path classFile) {
        CompilationProvider provider;
        Path source;
        Iterator<CompilationProvider> iterator = compilationProviders.iterator();
        do {
            if (!iterator.hasNext()) return null;
        } while ((source = (provider = iterator.next()).getSourcePath(classFile, Collections.singleton(projectSourcesDir.toAbsolutePath().toString()), classesDir.toAbsolutePath().toString())) == null);
        String relative = projectSourcesDir.relativize(source).toString();
        try (InputStream in = Files.newInputStream(source, new OpenOption[0]);){
            byte[] data = FileUtil.readFileContents((InputStream)in);
            Path resolved = deploymentSourcesDir.resolve(relative);
            Files.createDirectories(resolved.getParent(), new FileAttribute[0]);
            Files.write(resolved, data, new OpenOption[0]);
            Path path = resolved;
            return path;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        java.util.logging.Logger logger = LogManager.getLogManager().getLogger("");
        if (!(logger instanceof Logger)) {
            throw new IllegalStateException("QuarkusDevModeTest must be used with the the JBoss LogManager. See https://quarkus.io/guides/logging#how-to-configure-logging-for-quarkustest for an example of how to configure it in Maven.");
        }
        rootLogger = (Logger)logger;
        ArrayList<CompilationProvider> providers = new ArrayList<CompilationProvider>();
        for (CompilationProvider provider : ServiceLoader.load(CompilationProvider.class)) {
            providers.add(provider);
        }
        compilationProviders = Collections.unmodifiableList(providers);
    }
}

