/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test;

import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.dev.appstate.ApplicationStateNotification;
import io.quarkus.dev.testing.TestScanningLock;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.test.ClearCache;
import io.quarkus.test.ExclusivityChecker;
import io.quarkus.test.ExportUtil;
import io.quarkus.test.InMemoryLogHandler;
import io.quarkus.test.common.GroovyClassValue;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.TestConfigUtil;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.stream.Stream;
import org.jboss.logmanager.Logger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstantiationException;

public class QuarkusDevModeTest
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
TestInstanceFactory {
    private static final Logger rootLogger;
    public static final OpenOption[] OPEN_OPTIONS;
    private Handler[] originalRootLoggerHandlers;
    private DevModeMain devModeMain;
    private Path deploymentDir;
    private Supplier<JavaArchive> archiveProducer;
    private Supplier<JavaArchive> testArchiveProducer;
    private List<String> codeGenSources = Collections.emptyList();
    private String logFileName;
    private InMemoryLogHandler inMemoryLogHandler = new InMemoryLogHandler(r -> false);
    private Path deploymentSourceParentPath;
    private Path deploymentSourcePath;
    private Path deploymentResourcePath;
    private Path deploymentTestSourceParentPath;
    private Path deploymentTestSourcePath;
    private Path deploymentTestResourcePath;
    private Path projectSourceRoot;
    private Path testLocation;
    private String[] commandLineArgs = new String[0];
    private final Map<String, String> oldSystemProps = new HashMap<String, String>();
    private final Map<String, String> buildSystemProperties = new HashMap<String, String>();
    private boolean allowFailedStart = false;
    private static final List<CompilationProvider> compilationProviders;

    public Supplier<JavaArchive> getArchiveProducer() {
        return this.archiveProducer;
    }

    public QuarkusDevModeTest setArchiveProducer(Supplier<JavaArchive> archiveProducer) {
        this.archiveProducer = archiveProducer;
        return this;
    }

    public QuarkusDevModeTest withApplicationRoot(Consumer<JavaArchive> applicationRootConsumer) {
        Objects.requireNonNull(applicationRootConsumer);
        return this.setArchiveProducer(() -> {
            JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
            applicationRootConsumer.accept(jar);
            return jar;
        });
    }

    public QuarkusDevModeTest withEmptyApplication() {
        return this.withApplicationRoot(new Consumer<JavaArchive>(){

            @Override
            public void accept(JavaArchive javaArchive) {
            }
        });
    }

    public QuarkusDevModeTest setTestArchiveProducer(Supplier<JavaArchive> testArchiveProducer) {
        this.testArchiveProducer = testArchiveProducer;
        return this;
    }

    public QuarkusDevModeTest withTestArchive(Consumer<JavaArchive> testArchiveConsumer) {
        Objects.requireNonNull(testArchiveConsumer);
        return this.setTestArchiveProducer(() -> {
            JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
            testArchiveConsumer.accept(jar);
            return jar;
        });
    }

    public QuarkusDevModeTest setCodeGenSources(String ... codeGenSources) {
        this.codeGenSources = Arrays.asList(codeGenSources);
        return this;
    }

    public QuarkusDevModeTest setLogFileName(String logFileName) {
        this.logFileName = logFileName;
        return this;
    }

    public QuarkusDevModeTest setLogRecordPredicate(Predicate<LogRecord> predicate) {
        this.inMemoryLogHandler = new InMemoryLogHandler(predicate);
        return this;
    }

    public List<LogRecord> getLogRecords() {
        return this.inMemoryLogHandler.records;
    }

    public void clearLogRecords() {
        this.inMemoryLogHandler.clearRecords();
    }

    public QuarkusDevModeTest setBuildSystemProperty(String name, String value) {
        this.buildSystemProperties.put(name, value);
        return this;
    }

    public Object createTestInstance(TestInstanceFactoryContext factoryContext, ExtensionContext extensionContext) throws TestInstantiationException {
        try {
            Object actualTestInstance = factoryContext.getTestClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            TestHTTPResourceManager.inject(actualTestInstance);
            return actualTestInstance;
        }
        catch (Exception e) {
            throw new TestInstantiationException("Unable to create test proxy", (Throwable)e);
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        TestConfigUtil.cleanUp();
        GroovyClassValue.disable();
        ProfileManager.setLaunchMode((LaunchMode)LaunchMode.DEVELOPMENT);
        this.originalRootLoggerHandlers = rootLogger.getHandlers();
        rootLogger.addHandler((Handler)((Object)this.inMemoryLogHandler));
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        if (this.archiveProducer == null) {
            throw new RuntimeException("QuarkusDevModeTest does not have archive producer set");
        }
        ExclusivityChecker.checkTestType(extensionContext, QuarkusDevModeTest.class);
        if (this.logFileName != null) {
            PropertyTestUtil.setLogFileProperty((String)this.logFileName);
        } else {
            PropertyTestUtil.setLogFileProperty();
        }
        ExtensionContext.Store store = extensionContext.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
        if (store.get((Object)TestResourceManager.class.getName()) == null) {
            TestResourceManager testResourceManager = new TestResourceManager(extensionContext.getRequiredTestClass());
            testResourceManager.init(null);
            Map properties = testResourceManager.start();
            final TestResourceManager testResourceManager2 = testResourceManager;
            store.put((Object)TestResourceManager.class.getName(), (Object)testResourceManager);
            store.put((Object)TestResourceManager.CLOSEABLE_NAME, (Object)new ExtensionContext.Store.CloseableResource(){

                public void close() throws Throwable {
                    testResourceManager2.close();
                }
            });
        }
        TestResourceManager tm = (TestResourceManager)store.get((Object)TestResourceManager.class.getName());
        for (Map.Entry entry : tm.getConfigProperties().entrySet()) {
            this.oldSystemProps.put((String)entry.getKey(), System.getProperty((String)entry.getKey()));
            if (entry.getValue() == null) {
                System.clearProperty((String)entry.getKey());
                continue;
            }
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        Class testClass = extensionContext.getRequiredTestClass();
        try {
            this.deploymentDir = Files.createTempDirectory("quarkus-dev-mode-test", new FileAttribute[0]);
            this.testLocation = PathTestHelper.getTestClassesLocation((Class)testClass);
            String string = System.getProperty("quarkus.test.source-path");
            this.projectSourceRoot = string == null ? this.testLocation.getParent().getParent().resolve("src/test/java") : Paths.get(string, new String[0]);
            Path projectSourceParent = this.projectSourceRoot.getParent();
            DevModeContext context = this.exportArchive(this.deploymentDir, this.projectSourceRoot, projectSourceParent);
            context.setBaseName(extensionContext.getDisplayName() + " (QuarkusDevModeTest)");
            context.setArgs(this.commandLineArgs);
            context.setTest(true);
            context.setAbortOnFailedStart(!this.allowFailedStart);
            context.getBuildSystemProperties().put("quarkus.banner.enabled", "false");
            context.getBuildSystemProperties().put("quarkus.console.disable-input", "true");
            context.getBuildSystemProperties().putAll(this.buildSystemProperties);
            this.devModeMain = new DevModeMain(context);
            this.devModeMain.start();
            ApplicationStateNotification.waitForApplicationStart();
        }
        catch (Exception exception) {
            if (this.allowFailedStart) {
                exception.printStackTrace();
            }
            throw exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        for (Map.Entry<String, String> e : this.oldSystemProps.entrySet()) {
            if (e.getValue() == null) {
                System.clearProperty(e.getKey());
                continue;
            }
            System.setProperty(e.getKey(), e.getValue());
        }
        rootLogger.setHandlers(this.originalRootLoggerHandlers);
        this.inMemoryLogHandler.clearRecords();
        this.inMemoryLogHandler.setFilter(null);
        ClearCache.clearAnnotationCache();
        TestConfigUtil.cleanUp();
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        try {
            if (this.devModeMain != null) {
                this.devModeMain.close();
                this.devModeMain = null;
            }
        }
        finally {
            if (this.deploymentDir != null) {
                FileUtil.deleteDirectory((Path)this.deploymentDir);
            }
        }
        this.inMemoryLogHandler.clearRecords();
    }

    private DevModeContext exportArchive(Path deploymentDir, Path testSourceDir, Path testSourcesParentDir) {
        try {
            this.deploymentSourcePath = deploymentDir.resolve("src/main/java");
            this.deploymentSourceParentPath = deploymentDir.resolve("src/main");
            this.deploymentResourcePath = deploymentDir.resolve("src/main/resources");
            Path classes = deploymentDir.resolve("target/classes");
            Path targetDir = deploymentDir.resolve("target");
            Path cache = deploymentDir.resolve("target/dev-cache");
            Files.createDirectories(this.deploymentSourcePath, new FileAttribute[0]);
            Files.createDirectories(this.deploymentResourcePath, new FileAttribute[0]);
            Files.createDirectories(classes, new FileAttribute[0]);
            Files.createDirectories(cache, new FileAttribute[0]);
            JavaArchive archive = this.archiveProducer.get();
            ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExplodedInto(classes.toFile());
            this.copyFromSource(testSourceDir, this.deploymentSourcePath, classes);
            this.copyCodeGenSources(testSourcesParentDir, this.deploymentSourceParentPath, this.codeGenSources);
            try (Stream<Path> stream = Files.walk(classes, new FileVisitOption[0]);){
                stream.forEach(s -> {
                    if (s.toString().endsWith(".class") || Files.isDirectory(s, new LinkOption[0])) {
                        return;
                    }
                    String relative = classes.relativize((Path)s).toString();
                    try (InputStream in = Files.newInputStream(s, new OpenOption[0]);){
                        byte[] data = FileUtil.readFileContents((InputStream)in);
                        Path resolved = this.deploymentResourcePath.resolve(relative);
                        Files.createDirectories(resolved.getParent(), new FileAttribute[0]);
                        Files.write(resolved, data, OPEN_OPTIONS);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            ExportUtil.exportToQuarkusDeploymentPath(archive);
            DevModeContext context = new DevModeContext();
            context.setCacheDir(cache.toFile());
            DevModeContext.ModuleInfo.Builder moduleBuilder = new DevModeContext.ModuleInfo.Builder().setArtifactKey((ArtifactKey)GACT.fromString((String)"io.quarkus.test:app-under-test")).setProjectDirectory(deploymentDir.toAbsolutePath().toString()).setSourcePaths((PathCollection)PathList.of((Path[])new Path[]{this.deploymentSourcePath.toAbsolutePath()})).setClassesPath(classes.toAbsolutePath().toString()).setResourcePaths((PathCollection)PathList.of((Path[])new Path[]{this.deploymentResourcePath.toAbsolutePath()})).setResourcesOutputPath(classes.toAbsolutePath().toString()).setSourceParents((PathCollection)PathList.of((Path[])new Path[]{this.deploymentSourceParentPath.toAbsolutePath()})).setPreBuildOutputDir(targetDir.resolve("generated-sources").toAbsolutePath().toString()).setTargetDir(targetDir.toAbsolutePath().toString());
            if (this.testArchiveProducer != null) {
                this.deploymentTestSourcePath = deploymentDir.resolve("src/test/java");
                this.deploymentTestSourceParentPath = deploymentDir.resolve("src/test");
                this.deploymentTestResourcePath = deploymentDir.resolve("src/test/resources");
                Path testClasses = deploymentDir.resolve("target/test-classes");
                Files.createDirectories(this.deploymentTestSourcePath, new FileAttribute[0]);
                Files.createDirectories(this.deploymentTestResourcePath, new FileAttribute[0]);
                Files.createDirectories(testClasses, new FileAttribute[0]);
                JavaArchive testArchive = this.testArchiveProducer.get();
                ((ExplodedExporter)testArchive.as(ExplodedExporter.class)).exportExplodedInto(testClasses.toFile());
                this.copyFromSource(testSourceDir, this.deploymentTestSourcePath, testClasses);
                try (Stream<Path> stream = Files.walk(testClasses, new FileVisitOption[0]);){
                    stream.forEach(s -> {
                        if (s.toString().endsWith(".class") || Files.isDirectory(s, new LinkOption[0])) {
                            return;
                        }
                        String relative = testClasses.relativize((Path)s).toString();
                        try (InputStream in = Files.newInputStream(s, new OpenOption[0]);){
                            byte[] data = FileUtil.readFileContents((InputStream)in);
                            Path resolved = this.deploymentTestResourcePath.resolve(relative);
                            Files.createDirectories(resolved.getParent(), new FileAttribute[0]);
                            Files.write(resolved, data, OPEN_OPTIONS);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                }
                moduleBuilder.setTestSourcePaths((PathCollection)PathList.of((Path[])new Path[]{this.deploymentTestSourcePath.toAbsolutePath()})).setTestClassesPath(testClasses.toAbsolutePath().toString()).setTestResourcePaths((PathCollection)PathList.of((Path[])new Path[]{this.deploymentTestResourcePath.toAbsolutePath()})).setTestResourcesOutputPath(testClasses.toAbsolutePath().toString());
            }
            context.setApplicationRoot(moduleBuilder.build());
            return context;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create the archive", e);
        }
    }

    private void copyCodeGenSources(Path testSourcesParent, Path deploymentSourceParentPath, List<String> codeGenSources) {
        for (String codeGenDirName : codeGenSources) {
            Path codeGenSource = testSourcesParent.resolve(codeGenDirName);
            try {
                Path target = deploymentSourceParentPath.resolve(codeGenDirName);
                Stream<Path> files = Files.walk(codeGenSource, new FileVisitOption[0]);
                try {
                    files.forEach(file -> {
                        Path targetPath = target.resolve(codeGenSource.relativize((Path)file));
                        try {
                            Files.copy(file, targetPath, new CopyOption[0]);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to copy file : " + file + " to " + targetPath.toAbsolutePath().toString());
                        }
                    });
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy code gen directory", e);
            }
        }
    }

    public void modifySourceFile(String sourceFile, Function<String, String> mutator) {
        this.modifyFile(sourceFile, mutator, this.deploymentSourcePath);
    }

    public void modifyFile(String file, Function<String, String> mutator) {
        this.modifyPath(mutator, this.deploymentSourceParentPath, this.deploymentSourceParentPath.resolve(file));
    }

    public void modifySourceFile(Class<?> sourceFile, Function<String, String> mutator) {
        this.modifyFile(sourceFile.getSimpleName() + ".java", mutator, this.deploymentSourcePath);
    }

    public void modifyTestSourceFile(Class<?> sourceFile, Function<String, String> mutator) {
        this.modifyFile(sourceFile.getSimpleName() + ".java", mutator, this.deploymentTestSourcePath);
    }

    public void addSourceFile(Class<?> sourceFile) {
        Path path = this.findTargetSourceFilesForPath(this.projectSourceRoot, this.deploymentSourcePath, this.testLocation, this.testLocation.resolve(sourceFile.getName().replace(".", "/") + ".class"));
        long old = this.modTime(path.getParent());
        this.copySourceFilesForClass(this.projectSourceRoot, this.deploymentSourcePath, this.testLocation, this.testLocation.resolve(sourceFile.getName().replace(".", "/") + ".class"));
        this.sleepForFileChanges(path.getParent(), old);
    }

    public String[] getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public QuarkusDevModeTest setCommandLineArgs(String[] commandLineArgs) {
        this.commandLineArgs = commandLineArgs;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyFile(String name, Function<String, String> mutator, Path path) {
        TestScanningLock.lockForTests();
        try {
            AtomicBoolean found = new AtomicBoolean(false);
            try (Stream<Path> sources = Files.walk(path, new FileVisitOption[0]);){
                sources.forEach(s -> {
                    if (s.endsWith(name)) {
                        found.set(true);
                        this.modifyPath(mutator, path, (Path)s);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (!found.get()) {
                throw new IllegalArgumentException("File " + name + " was not part of the test application");
            }
        }
        finally {
            TestScanningLock.unlockForTests();
        }
    }

    private void modifyPath(Function<String, String> mutator, Path sourceDirectory, Path input) {
        TestScanningLock.lockForTests();
        try {
            byte[] data;
            long old = this.modTime(input);
            long oldSrc = this.modTime(sourceDirectory);
            try (InputStream in = Files.newInputStream(input, new OpenOption[0]);){
                data = FileUtil.readFileContents((InputStream)in);
            }
            String oldContent = new String(data, StandardCharsets.UTF_8);
            String content = mutator.apply(oldContent);
            if (content.equals(oldContent)) {
                throw new RuntimeException("File was not modified, mutator function had no effect");
            }
            Files.write(input, content.getBytes(StandardCharsets.UTF_8), OPEN_OPTIONS);
            this.sleepForFileChanges(sourceDirectory, oldSrc);
            this.sleepForFileChanges(input, old);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            TestScanningLock.unlockForTests();
        }
    }

    private void sleepForFileChanges(Path path, long oldTime) {
        try {
            long fm = this.modTime(path);
            if (fm > oldTime) {
                return;
            }
            long timeToBeat = Math.max(System.currentTimeMillis(), this.modTime(path));
            do {
                Thread.sleep(1000L);
                Files.setLastModifiedTime(path, FileTime.fromMillis(System.currentTimeMillis()));
                fm = this.modTime(path);
                Thread.sleep(100L);
            } while (fm <= timeToBeat);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private long modTime(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void modifyResourceFile(String path, Function<String, String> mutator) {
        Path resourcePath = this.deploymentResourcePath.resolve(path);
        this.internalModifyResource(mutator, resourcePath);
    }

    private void internalModifyResource(Function<String, String> mutator, Path resourcePath) {
        try {
            byte[] data;
            long old = this.modTime(resourcePath);
            try (InputStream in = Files.newInputStream(resourcePath, new OpenOption[0]);){
                data = FileUtil.readFileContents((InputStream)in);
            }
            String content = new String(data, StandardCharsets.UTF_8);
            content = mutator.apply(content);
            Files.write(resourcePath, content.getBytes(StandardCharsets.UTF_8), OPEN_OPTIONS);
            this.sleepForFileChanges(resourcePath, old);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void modifyTestResourceFile(String path, Function<String, String> mutator) {
        Path resourcePath = this.deploymentTestResourcePath.resolve(path);
        this.internalModifyResource(mutator, resourcePath);
    }

    public void addResourceFile(String path, byte[] data) {
        Path resourceFilePath = this.deploymentResourcePath.resolve(path);
        long oldParent = this.modTime(resourceFilePath.getParent());
        try {
            Files.write(resourceFilePath, data, OPEN_OPTIONS);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.sleepForFileChanges(resourceFilePath.getParent(), oldParent);
    }

    public void deleteResourceFile(String path) {
        Path resourceFilePath = this.deploymentResourcePath.resolve(path);
        long old = this.modTime(resourceFilePath.getParent());
        long timeout = System.currentTimeMillis() + 5000L;
        while (true) {
            try {
                Files.delete(resourceFilePath);
            }
            catch (IOException e) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() < timeout) continue;
                throw new UncheckedIOException(e);
            }
            break;
        }
        this.sleepForFileChanges(resourceFilePath.getParent(), old);
    }

    public void addResourceFile(String path, String data) {
        this.addResourceFile(path, data.getBytes(StandardCharsets.UTF_8));
    }

    private void copyFromSource(Path projectSourcesDir, Path deploymentSourcesDir, Path classesDir) throws IOException {
        try (Stream<Path> classes = Files.walk(classesDir, new FileVisitOption[0]);){
            classes.forEach(c -> {
                if (Files.isDirectory(c, new LinkOption[0]) || !c.toString().endsWith(".class")) {
                    return;
                }
                this.copySourceFilesForClass(projectSourcesDir, deploymentSourcesDir, classesDir, (Path)c);
            });
        }
    }

    private Path copySourceFilesForClass(Path projectSourcesDir, Path deploymentSourcesDir, Path classesDir, Path classFile) {
        for (CompilationProvider provider : compilationProviders) {
            Path path;
            block9: {
                Path source = provider.getSourcePath(classFile, (PathCollection)PathList.of((Path[])new Path[]{projectSourcesDir.toAbsolutePath()}), classesDir.toAbsolutePath().toString());
                if (source == null) continue;
                String relative = projectSourcesDir.relativize(source).toString();
                InputStream in = Files.newInputStream(source, new OpenOption[0]);
                try {
                    byte[] data = FileUtil.readFileContents((InputStream)in);
                    Path resolved = deploymentSourcesDir.resolve(relative);
                    Files.createDirectories(resolved.getParent(), new FileAttribute[0]);
                    Files.write(resolved, data, OPEN_OPTIONS);
                    path = resolved;
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                in.close();
            }
            return path;
        }
        return null;
    }

    private Path findTargetSourceFilesForPath(Path projectSourcesDir, Path deploymentSourcesDir, Path classesDir, Path classFile) {
        for (CompilationProvider provider : compilationProviders) {
            Path source = provider.getSourcePath(classFile, (PathCollection)PathList.of((Path[])new Path[]{projectSourcesDir.toAbsolutePath()}), classesDir.toAbsolutePath().toString());
            if (source == null) continue;
            String relative = projectSourcesDir.relativize(source).toString();
            try {
                Path resolved = deploymentSourcesDir.resolve(relative);
                Files.createDirectories(resolved.getParent(), new FileAttribute[0]);
                return resolved;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        throw new RuntimeException("Could not find source file for " + classFile);
    }

    public boolean isAllowFailedStart() {
        return this.allowFailedStart;
    }

    public QuarkusDevModeTest setAllowFailedStart(boolean allowFailedStart) {
        this.allowFailedStart = allowFailedStart;
        return this;
    }

    static {
        OPEN_OPTIONS = new OpenOption[]{StandardOpenOption.SYNC, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        java.util.logging.Logger logger = LogManager.getLogManager().getLogger("");
        if (!(logger instanceof Logger)) {
            throw new IllegalStateException("QuarkusDevModeTest must be used with the the JBoss LogManager. See https://quarkus.io/guides/logging#how-to-configure-logging-for-quarkustest for an example of how to configure it in Maven.");
        }
        rootLogger = (Logger)logger;
        ArrayList<CompilationProvider> providers = new ArrayList<CompilationProvider>();
        for (CompilationProvider provider : ServiceLoader.load(CompilationProvider.class)) {
            providers.add(provider);
        }
        compilationProviders = Collections.unmodifiableList(providers);
    }

    static class ChangeSet {
        final String name;
        final Function<String, String> mutator;
        final Path path;

        ChangeSet(String name, Function<String, String> mutator, Path path) {
            this.name = name;
            this.mutator = mutator;
            this.path = path;
        }
    }
}

