/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test;

import io.quarkus.test.InMemoryLogHandler;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.junit.jupiter.api.Assertions;

public class LogCollectingTestResource
implements QuarkusTestResourceLifecycleManager {
    public static final String LOGGER = "logger";
    public static final String LEVEL = "level";
    public static final String EXCLUDE = "exclude";
    public static final String INCLUDE = "include";
    private static final Formatter LOG_FORMATTER = new PatternFormatter("%s");
    private static final java.util.logging.Logger rootLogger;
    private static LogCollectingTestResource current;
    private java.util.logging.Logger logger;
    private volatile boolean logHandlerDidHandleLogs = false;
    private InMemoryLogHandler inMemoryLogHandler;

    public static String format(LogRecord record) {
        return LOG_FORMATTER.format(record);
    }

    public static LogCollectingTestResource current() {
        if (current == null) {
            throw new IllegalStateException(LogCollectingTestResource.class.getName() + " must be registered with @QuarkusTestResource");
        }
        return current;
    }

    public List<LogRecord> getRecords() {
        Assertions.assertTrue((boolean)this.logHandlerDidHandleLogs, (String)"The log handler didn't handle even one log record (ignoring filters); something is wrong with the setup. Note this test resource will only work correctly with @QuarkusTest: QuarkusDevModeTest, QuarkusProdModeTest and QuarkusUnitTest expose their own log assertion features, and @QuarkusIntegrationTest simply cannot support this feature in its current form.");
        return this.inMemoryLogHandler.getRecords();
    }

    public void clear() {
        this.inMemoryLogHandler.clearRecords();
    }

    public void init(Map<String, String> initArgs) {
        String loggerName = initArgs.get(LOGGER);
        this.logger = loggerName == null ? rootLogger : LogManager.getLogManager().getLogger(loggerName);
        List<Pattern> excludes = this.fromCommaSeparatedRegexStrings(initArgs.get(EXCLUDE));
        List<Pattern> includes = this.fromCommaSeparatedRegexStrings(initArgs.get(INCLUDE));
        String levelAsString = initArgs.get(LEVEL);
        Level level = levelAsString != null ? Level.parse(levelAsString) : Level.INFO;
        this.inMemoryLogHandler = new InMemoryLogHandler(record -> {
            this.logHandlerDidHandleLogs = true;
            if (record.getLevel().intValue() < level.intValue()) {
                return false;
            }
            String recordLoggerName = record.getLoggerName();
            for (Pattern exclude : excludes) {
                if (!exclude.matcher(recordLoggerName).matches()) continue;
                return false;
            }
            if (includes.isEmpty()) {
                return true;
            }
            for (Pattern include : includes) {
                if (!include.matcher(recordLoggerName).matches()) continue;
                return true;
            }
            return false;
        });
    }

    private List<Pattern> fromCommaSeparatedRegexStrings(String raw) {
        if (raw == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(raw.split(",")).map(Pattern::compile).collect(Collectors.toList());
    }

    public Map<String, String> start() {
        this.inMemoryLogHandler.getRecords().clear();
        this.logHandlerDidHandleLogs = false;
        this.logger.addHandler(this.inMemoryLogHandler);
        if (current != null) {
            throw new IllegalStateException(LogCollectingTestResource.class.getName() + " used concurrently from multiple tests?");
        }
        current = this;
        return Map.of();
    }

    public void stop() {
        current = null;
        this.logger.removeHandler(this.inMemoryLogHandler);
    }

    static {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        java.util.logging.Logger logger = LogManager.getLogManager().getLogger("");
        if (!(logger instanceof Logger)) {
            throw new IllegalStateException("LogCollectingTestResource must be used with the the JBoss LogManager. See https://quarkus.io/guides/logging#how-to-configure-logging-for-quarkustest for an example of how to configure it in Maven.");
        }
        rootLogger = logger;
    }
}

