/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.mockito.internal;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.test.junit.callback.QuarkusTestBeforeAllCallback;
import io.quarkus.test.junit.mockito.InjectMock;
import io.quarkus.test.junit.mockito.internal.MockitoMocksTracker;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.inject.Qualifier;
import org.mockito.Mockito;

public class CreateMockitoMocksCallback
implements QuarkusTestBeforeAllCallback {
    public void beforeAll(Object testInstance) {
        Class<?> current = testInstance.getClass();
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                InjectMock injectMockAnnotation = field.getAnnotation(InjectMock.class);
                if (injectMockAnnotation == null) continue;
                Object beanInstance = this.getBeanInstance(testInstance, field);
                Object mock = this.createMockAndSetTestField(testInstance, field, beanInstance);
                MockitoMocksTracker.track(testInstance, mock, beanInstance);
            }
            current = current.getSuperclass();
        }
    }

    private Object createMockAndSetTestField(Object testInstance, Field field, Object beanInstance) {
        Object mock = Mockito.mock(beanInstance.getClass());
        field.setAccessible(true);
        try {
            field.set(testInstance, mock);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return mock;
    }

    private Object getBeanInstance(Object testInstance, Field field) {
        Class<?> fieldClass = field.getType();
        InstanceHandle instance = Arc.container().instance(fieldClass, this.getQualifiers(field));
        if (!instance.isAvailable()) {
            throw new IllegalStateException("Invalid use of @InjectMock - could not determine bean of type: " + fieldClass + ". Offending field is " + field.getName() + " of test class " + testInstance.getClass());
        }
        return instance.get();
    }

    private Annotation[] getQualifiers(Field fieldToMock) {
        Annotation[] fieldAnnotations;
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        block0: for (Annotation fieldAnnotation : fieldAnnotations = fieldToMock.getDeclaredAnnotations()) {
            for (Annotation annotationOfFieldAnnotation : fieldAnnotation.annotationType().getAnnotations()) {
                if (!annotationOfFieldAnnotation.annotationType().equals(Qualifier.class)) continue;
                qualifiers.add(fieldAnnotation);
                continue block0;
            }
        }
        return qualifiers.toArray(new Annotation[0]);
    }
}

