/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.mockito.internal;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.test.junit.callback.QuarkusTestAfterConstructCallback;
import io.quarkus.test.junit.mockito.InjectMock;
import io.quarkus.test.junit.mockito.internal.MockitoMocksTracker;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Qualifier;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class CreateMockitoMocksCallback
implements QuarkusTestAfterConstructCallback {
    public void afterConstruct(Object testInstance) {
        Class<?> current = testInstance.getClass();
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                InjectMock injectMockAnnotation = field.getAnnotation(InjectMock.class);
                if (injectMockAnnotation == null) continue;
                boolean returnsDeepMocks = injectMockAnnotation.returnsDeepMocks();
                Object beanInstance = CreateMockitoMocksCallback.getBeanInstance(testInstance, field, InjectMock.class);
                Optional<Object> result = this.createMockAndSetTestField(testInstance, field, beanInstance, new MockConfiguration(returnsDeepMocks));
                if (!result.isPresent()) continue;
                MockitoMocksTracker.track(testInstance, result.get(), beanInstance);
            }
            current = current.getSuperclass();
        }
    }

    private Optional<Object> createMockAndSetTestField(Object testInstance, Field field, Object beanInstance, MockConfiguration mockConfiguration) {
        boolean isNew;
        Object mock;
        Optional<Object> currentMock;
        Class<?> beanClass = beanInstance.getClass();
        if (ClientProxy.class.isAssignableFrom(beanClass) && beanClass.getSuperclass() != Object.class) {
            beanClass = beanClass.getSuperclass();
        }
        if ((currentMock = MockitoMocksTracker.currentMock(testInstance, beanInstance)).isPresent()) {
            mock = currentMock.get();
            isNew = false;
        } else {
            mock = mockConfiguration.useDeepMocks ? Mockito.mock(beanClass, (Answer)Mockito.RETURNS_DEEP_STUBS) : Mockito.mock(beanClass);
            isNew = true;
        }
        field.setAccessible(true);
        try {
            field.set(testInstance, mock);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (isNew) {
            return Optional.of(mock);
        }
        return Optional.empty();
    }

    static Object getBeanInstance(Object testInstance, Field field, Class<? extends Annotation> annotationType) {
        Class<?> fieldClass = field.getType();
        InstanceHandle instance = Arc.container().instance(fieldClass, CreateMockitoMocksCallback.getQualifiers(field));
        if (!instance.isAvailable()) {
            throw new IllegalStateException("Invalid use of " + annotationType.getTypeName() + " - could not determine bean of type: " + fieldClass + ". Offending field is " + field.getName() + " of test class " + testInstance.getClass());
        }
        return instance.get();
    }

    static Annotation[] getQualifiers(Field fieldToMock) {
        Annotation[] fieldAnnotations;
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        block0: for (Annotation fieldAnnotation : fieldAnnotations = fieldToMock.getDeclaredAnnotations()) {
            for (Annotation annotationOfFieldAnnotation : fieldAnnotation.annotationType().getAnnotations()) {
                if (!annotationOfFieldAnnotation.annotationType().equals(Qualifier.class)) continue;
                qualifiers.add(fieldAnnotation);
                continue block0;
            }
        }
        return qualifiers.toArray(new Annotation[0]);
    }

    private static class MockConfiguration {
        final boolean useDeepMocks;

        private MockConfiguration(boolean useDeepMocks) {
            this.useDeepMocks = useDeepMocks;
        }
    }
}

