/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.mockito.internal;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.test.junit.buildchain.TestBuildChainCustomizerProducer;
import io.quarkus.test.junit.mockito.InjectMock;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;

public class SingletonToApplicationScopedTestBuildChainCustomizerProducer
implements TestBuildChainCustomizerProducer {
    private static final DotName INJECT_MOCK = DotName.createSimple((String)InjectMock.class.getName());

    public Consumer<BuildChainBuilder> produce(final Index testClassesIndex) {
        return new Consumer<BuildChainBuilder>(){

            @Override
            public void accept(BuildChainBuilder buildChainBuilder) {
                buildChainBuilder.addBuildStep(new BuildStep(){

                    public void execute(BuildContext context) {
                        final HashSet<DotName> mockTypes = new HashSet<DotName>();
                        List instances = testClassesIndex.getAnnotations(INJECT_MOCK);
                        for (AnnotationInstance instance : instances) {
                            AnnotationValue allowScopeConversionValue;
                            if (instance.target().kind() != AnnotationTarget.Kind.FIELD || (allowScopeConversionValue = instance.value("convertScopes")) == null || !allowScopeConversionValue.asBoolean()) continue;
                            mockTypes.add(instance.target().asField().type().name());
                        }
                        if (mockTypes.isEmpty()) {
                            return;
                        }
                        final CustomScopeAnnotationsBuildItem scopes = (CustomScopeAnnotationsBuildItem)context.consume(CustomScopeAnnotationsBuildItem.class);
                        final HashSet<DotName> singletonBeanDefiningAnnotations = new HashSet<DotName>();
                        for (BeanDefiningAnnotationBuildItem annotation : context.consumeMulti(BeanDefiningAnnotationBuildItem.class)) {
                            if (!DotNames.SINGLETON.equals((Object)annotation.getDefaultScope())) continue;
                            singletonBeanDefiningAnnotations.add(annotation.getName());
                        }
                        context.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

                            public boolean appliesTo(AnnotationTarget.Kind kind) {
                                return kind == AnnotationTarget.Kind.CLASS || kind == AnnotationTarget.Kind.METHOD;
                            }

                            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                                DotName returnType;
                                MethodInfo methodInfo;
                                AnnotationTarget target = transformationContext.getTarget();
                                if (target.kind() == AnnotationTarget.Kind.CLASS) {
                                    ClassInfo classInfo = target.asClass();
                                    if (this.isMatchingBean(classInfo) && (Annotations.contains((Collection)transformationContext.getAnnotations(), (DotName)DotNames.SINGLETON) || this.hasSingletonBeanDefiningAnnotation(transformationContext))) {
                                        this.replaceSingletonWithApplicationScoped(transformationContext);
                                    }
                                } else if (target.kind() == AnnotationTarget.Kind.METHOD && (methodInfo = target.asMethod()).annotation(DotNames.PRODUCES) != null && (Annotations.contains((Collection)transformationContext.getAnnotations(), (DotName)DotNames.SINGLETON) || this.hasSingletonBeanDefiningAnnotation(transformationContext)) && mockTypes.contains(returnType = methodInfo.returnType().name())) {
                                    this.replaceSingletonWithApplicationScoped(transformationContext);
                                }
                            }

                            private void replaceSingletonWithApplicationScoped(AnnotationsTransformer.TransformationContext transformationContext) {
                                ((Transformation)((Transformation)transformationContext.transform().remove((Predicate)new IsSingletonPredicate())).add(DotNames.APPLICATION_SCOPED, new AnnotationValue[0])).done();
                            }

                            private boolean isMatchingBean(ClassInfo classInfo) {
                                if (mockTypes.contains(classInfo.name())) {
                                    return true;
                                }
                                if (mockTypes.contains(classInfo.superName())) {
                                    return true;
                                }
                                for (DotName iface : classInfo.interfaceNames()) {
                                    if (!mockTypes.contains(iface)) continue;
                                    return true;
                                }
                                return false;
                            }

                            private boolean hasSingletonBeanDefiningAnnotation(AnnotationsTransformer.TransformationContext transformationContext) {
                                if (singletonBeanDefiningAnnotations.isEmpty() || scopes.isScopeIn(transformationContext.getAnnotations())) {
                                    return false;
                                }
                                return Annotations.containsAny((Collection)transformationContext.getAnnotations(), (Iterable)singletonBeanDefiningAnnotations);
                            }
                        }));
                    }
                }).produces(AnnotationsTransformerBuildItem.class).consumes(CustomScopeAnnotationsBuildItem.class).consumes(BeanDefiningAnnotationBuildItem.class).build();
            }
        };
    }

    private static class IsSingletonPredicate
    implements Predicate<AnnotationInstance> {
        private IsSingletonPredicate() {
        }

        @Override
        public boolean test(AnnotationInstance annotationInstance) {
            return annotationInstance.name().equals((Object)DotNames.SINGLETON);
        }
    }
}

