/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.mockito.internal;

import io.quarkus.arc.ClientProxy;
import io.quarkus.test.junit.callback.QuarkusTestAfterConstructCallback;
import io.quarkus.test.junit.mockito.InjectSpy;
import io.quarkus.test.junit.mockito.internal.CreateMockitoMocksCallback;
import io.quarkus.test.junit.mockito.internal.MockitoMocksTracker;
import java.lang.reflect.Field;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class CreateMockitoSpiesCallback
implements QuarkusTestAfterConstructCallback {
    public void afterConstruct(Object testInstance) {
        Class<?> current = testInstance.getClass();
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                InjectSpy injectSpyAnnotation = field.getAnnotation(InjectSpy.class);
                if (injectSpyAnnotation == null) continue;
                Object contextualReference = CreateMockitoMocksCallback.getContextualReference(testInstance, field, InjectSpy.class);
                Object spy = this.createSpyAndSetTestField(testInstance, field, contextualReference, injectSpyAnnotation.delegate());
                MockitoMocksTracker.track(testInstance, spy, contextualReference);
            }
            current = current.getSuperclass();
        }
    }

    private Object createSpyAndSetTestField(Object testInstance, Field field, Object contextualReference, boolean delegate) {
        Object contextualInstance = ClientProxy.unwrap((Object)contextualReference);
        Object spy = delegate ? Mockito.mock(CreateMockitoMocksCallback.getImplementationClass(contextualReference), (Answer)AdditionalAnswers.delegatesTo((Object)contextualInstance)) : Mockito.spy((Object)contextualInstance);
        field.setAccessible(true);
        try {
            field.set(testInstance, spy);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return spy;
    }
}

