/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.BootstrapClassLoaderFactory;
import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.QuarkusClassWriter;
import io.quarkus.deployment.builditem.TestAnnotationBuildItem;
import io.quarkus.deployment.builditem.TestClassPredicateBuildItem;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.runner.RuntimeRunner;
import io.quarkus.runner.TransformerTarget;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.test.common.NativeImageLauncher;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestInjectionManager;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestScopeManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.SubstrateTest;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.builder.BuildChainBuilder;
import org.jboss.builder.BuildContext;
import org.jboss.builder.BuildStep;
import org.jboss.builder.item.BuildItem;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.platform.commons.JUnitException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.opentest4j.TestAbortedException;

public class QuarkusTestExtension
implements BeforeEachCallback,
AfterEachCallback,
TestInstanceFactory,
BeforeAllCallback {
    private URLClassLoader appCl;
    private ClassLoader originalCl;
    private static boolean failedBoot;

    private ExtensionState doJavaStart(ExtensionContext context, TestResourceManager testResourceManager) {
        final LinkedBlockingDeque shutdownTasks = new LinkedBlockingDeque();
        Path appClassLocation = PathTestHelper.getAppClassLocation((Class)context.getRequiredTestClass());
        final Path testClassLocation = PathTestHelper.getTestClassesLocation((Class)context.getRequiredTestClass());
        final ClassLoader testClassLoader = context.getRequiredTestClass().getClassLoader();
        try {
            this.appCl = BootstrapClassLoaderFactory.newInstance().setAppClasses(appClassLocation).addToClassPath(testClassLocation).setParent(this.getClass().getClassLoader()).setOffline(PropertyUtils.getBooleanOrNull((String)"quarkus-bootstrap-offline")).setLocalProjectsDiscovery(PropertyUtils.getBoolean((String)"quarkus-workspace-discovery", (boolean)true)).setEnableClasspathCache(PropertyUtils.getBoolean((String)"quarkus-classpath-cache", (boolean)true)).newDeploymentClassLoader();
        }
        catch (BootstrapException e) {
            throw new IllegalStateException("Failed to create the boostrap class loader", e);
        }
        this.originalCl = QuarkusTestExtension.setCCL(this.appCl);
        final RuntimeRunner runtimeRunner = RuntimeRunner.builder().setLaunchMode(LaunchMode.TEST).setClassLoader((ClassLoader)this.appCl).setTarget(appClassLocation).addAdditionalArchive(testClassLocation).setClassOutput(new ClassOutput(){

            public void writeClass(boolean applicationClass, String className, byte[] data) throws IOException {
                Path location = testClassLocation.resolve(className.replace('.', '/') + ".class");
                Files.createDirectories(location.getParent(), new FileAttribute[0]);
                try (FileOutputStream out = new FileOutputStream(location.toFile());){
                    out.write(data);
                }
                shutdownTasks.add(new DeleteRunnable(location));
            }

            public void writeResource(String name, byte[] data) throws IOException {
                Path location = testClassLocation.resolve(name);
                Files.createDirectories(location.getParent(), new FileAttribute[0]);
                try (FileOutputStream out = new FileOutputStream(location.toFile());){
                    out.write(data);
                }
                shutdownTasks.add(new DeleteRunnable(location));
            }
        }).setTransformerTarget(new TransformerTarget(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setTransformers(Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> functions) {
                final ClassLoader main = Thread.currentThread().getContextClassLoader();
                final ClassLoader temp = new ClassLoader(){

                    @Override
                    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                        Class<?> c = this.findLoadedClass(name);
                        if (c == null) {
                            c = this.findClass(name);
                        }
                        if (resolve) {
                            this.resolveClass(c);
                        }
                        return c;
                    }

                    @Override
                    public URL getResource(String name) {
                        return main.getResource(name);
                    }

                    @Override
                    public Enumeration<URL> getResources(String name) throws IOException {
                        return main.getResources(name);
                    }
                };
                for (Map.Entry<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> e : functions.entrySet()) {
                    String resourceName = e.getKey().replace('.', '/') + ".class";
                    try {
                        InputStream stream = temp.getResourceAsStream(resourceName);
                        Throwable throwable = null;
                        try {
                            if (stream == null) {
                                System.err.println("Failed to transform " + e.getKey());
                                continue;
                            }
                            byte[] data = IoUtil.readBytes((InputStream)stream);
                            ClassReader cr = new ClassReader(data);
                            QuarkusClassWriter cw = new QuarkusClassWriter(cr, 3){

                                protected ClassLoader getClassLoader() {
                                    return temp;
                                }
                            };
                            ClassLoader old = Thread.currentThread().getContextClassLoader();
                            Thread.currentThread().setContextClassLoader(temp);
                            try {
                                QuarkusClassWriter visitor = cw;
                                for (BiFunction<String, ClassVisitor, ClassVisitor> i : e.getValue()) {
                                    visitor = i.apply(e.getKey(), (ClassVisitor)visitor);
                                }
                                cr.accept((ClassVisitor)visitor, 0);
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(old);
                            }
                            Path location = testClassLocation.resolve(resourceName);
                            Files.createDirectories(location.getParent(), new FileAttribute[0]);
                            try (FileOutputStream out = new FileOutputStream(location.toFile());){
                                out.write(cw.toByteArray());
                            }
                            shutdownTasks.add(new DeleteRunnable(location));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }).addChainCustomizer((Consumer)new Consumer<BuildChainBuilder>(){

            @Override
            public void accept(BuildChainBuilder buildChainBuilder) {
                buildChainBuilder.addBuildStep(new BuildStep(){

                    public void execute(BuildContext context) {
                        context.produce((BuildItem)new TestClassPredicateBuildItem((Predicate)new Predicate<String>(){

                            @Override
                            public boolean test(String className) {
                                return PathTestHelper.isTestClass((String)className, (ClassLoader)testClassLoader);
                            }
                        }));
                    }
                }).produces(TestClassPredicateBuildItem.class).build();
            }
        }).addChainCustomizer((Consumer)new Consumer<BuildChainBuilder>(){

            @Override
            public void accept(BuildChainBuilder buildChainBuilder) {
                buildChainBuilder.addBuildStep(new BuildStep(){

                    public void execute(BuildContext context) {
                        context.produce((BuildItem)new TestAnnotationBuildItem(QuarkusTest.class.getName()));
                    }
                }).produces(TestAnnotationBuildItem.class).build();
            }
        }).build();
        runtimeRunner.run();
        final Closeable shutdownTask = new Closeable(){

            @Override
            public void close() throws IOException {
                runtimeRunner.close();
                while (!shutdownTasks.isEmpty()) {
                    ((Runnable)shutdownTasks.pop()).run();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    shutdownTask.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, "Quarkus Test Cleanup Shutdown task"));
        return new ExtensionState(testResourceManager, shutdownTask, false);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        RestAssuredURLManager.clearURL();
        TestScopeManager.setup();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        RestAssuredURLManager.setURL();
        TestScopeManager.tearDown();
    }

    public Object createTestInstance(TestInstanceFactoryContext factoryContext, ExtensionContext extensionContext) throws TestInstantiationException {
        if (failedBoot) {
            try {
                return extensionContext.getRequiredTestClass().newInstance();
            }
            catch (Exception e) {
                throw new TestInstantiationException("Boot failed", (Throwable)e);
            }
        }
        ExtensionContext root = extensionContext.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        ExtensionState state = (ExtensionState)store.get((Object)ExtensionState.class.getName(), ExtensionState.class);
        PropertyTestUtil.setLogFileProperty();
        boolean substrateTest = extensionContext.getRequiredTestClass().isAnnotationPresent(SubstrateTest.class);
        if (state == null) {
            TestResourceManager testResourceManager = new TestResourceManager(extensionContext.getRequiredTestClass());
            try {
                testResourceManager.start();
                if (substrateTest) {
                    NativeImageLauncher launcher = new NativeImageLauncher(extensionContext.getRequiredTestClass());
                    try {
                        launcher.start();
                    }
                    catch (IOException e) {
                        throw new JUnitException("Quarkus native image start failed, original cause: " + e);
                    }
                    state = new ExtensionState(testResourceManager, (Closeable)launcher, true);
                } else {
                    state = this.doJavaStart(extensionContext, testResourceManager);
                }
                store.put((Object)ExtensionState.class.getName(), (Object)state);
            }
            catch (RuntimeException e) {
                testResourceManager.stop();
                failedBoot = true;
                throw e;
            }
        }
        if (substrateTest != state.isSubstrate()) {
            throw new RuntimeException("Attempted to mix @SubstrateTest and JVM mode tests in the same test run. This is not allowed.");
        }
        try {
            Constructor ctor = factoryContext.getTestClass().getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            Object instance = ctor.newInstance(new Object[0]);
            TestHTTPResourceManager.inject(instance);
            TestInjectionManager.inject(instance);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TestInstantiationException("Failed to create test instance", (Throwable)e);
        }
    }

    private static ClassLoader setCCL(ClassLoader cl) {
        Thread thread = Thread.currentThread();
        ClassLoader original = thread.getContextClassLoader();
        thread.setContextClassLoader(cl);
        return original;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        if (failedBoot) {
            throw new TestAbortedException("Not running test as boot failed");
        }
    }

    static class DeleteRunnable
    implements Runnable {
        final Path path;

        DeleteRunnable(Path path) {
            this.path = path;
        }

        @Override
        public void run() {
            try {
                Files.deleteIfExists(this.path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class ExtensionState
    implements ExtensionContext.Store.CloseableResource {
        private final TestResourceManager testResourceManager;
        private final Closeable resource;
        private final boolean substrate;

        ExtensionState(TestResourceManager testResourceManager, Closeable resource, boolean substrate) {
            this.testResourceManager = testResourceManager;
            this.resource = resource;
            this.substrate = substrate;
        }

        public void close() throws Throwable {
            this.testResourceManager.stop();
            try {
                this.resource.close();
            }
            finally {
                if (QuarkusTestExtension.this.originalCl != null) {
                    QuarkusTestExtension.setCCL(QuarkusTestExtension.this.originalCl);
                }
            }
            if (QuarkusTestExtension.this.appCl != null) {
                QuarkusTestExtension.this.appCl.close();
            }
        }

        public boolean isSubstrate() {
            return this.substrate;
        }
    }
}

