/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.runtime.test.TestHttpEndpointProvider;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.NativeImageLauncher;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestScopeManager;
import io.quarkus.test.junit.IntegrationTestExtensionState;
import io.quarkus.test.junit.IntegrationTestUtil;
import io.quarkus.test.junit.QuarkusTestExtension;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfileAndProperties;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.opentest4j.TestAbortedException;

public class NativeTestExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
TestInstancePostProcessor {
    private static boolean failedBoot;
    private static List<Function<Class<?>, String>> testHttpEndpointProviders;
    private static boolean ssl;
    private static Class<? extends QuarkusTestProfile> quarkusTestProfile;
    private static Throwable firstException;
    private static Class<?> currentJUnitTestClass;
    private static boolean hasPerTestResources;

    public void afterEach(ExtensionContext context) throws Exception {
        if (!failedBoot) {
            RestAssuredURLManager.clearURL();
            TestScopeManager.tearDown((boolean)true);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (failedBoot) {
            this.throwBootFailureException();
        } else {
            RestAssuredURLManager.setURL((boolean)ssl, (String)QuarkusTestExtension.getEndpointPath(context, testHttpEndpointProviders));
            TestScopeManager.setup((boolean)true);
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.ensureStarted(extensionContext);
    }

    private IntegrationTestExtensionState ensureStarted(ExtensionContext extensionContext) {
        boolean reloadTestResources;
        Class testClass = extensionContext.getRequiredTestClass();
        IntegrationTestUtil.ensureNoInjectAnnotationIsUsed(testClass);
        ExtensionContext root = extensionContext.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        IntegrationTestExtensionState state = (IntegrationTestExtensionState)store.get((Object)IntegrationTestExtensionState.class.getName(), IntegrationTestExtensionState.class);
        Class<? extends QuarkusTestProfile> selectedProfile = IntegrationTestUtil.findProfile(testClass);
        boolean wrongProfile = !Objects.equals(selectedProfile, quarkusTestProfile);
        boolean bl = reloadTestResources = !Objects.equals(extensionContext.getRequiredTestClass(), currentJUnitTestClass) && (hasPerTestResources || QuarkusTestExtension.hasPerTestResources(extensionContext));
        if (state == null && !failedBoot || wrongProfile || reloadTestResources) {
            if ((wrongProfile || reloadTestResources) && state != null) {
                try {
                    state.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            try {
                state = this.doNativeStart(extensionContext, selectedProfile);
                store.put((Object)IntegrationTestExtensionState.class.getName(), (Object)state);
            }
            catch (Throwable e) {
                failedBoot = true;
                firstException = e;
            }
        }
        return state;
    }

    private IntegrationTestExtensionState doNativeStart(ExtensionContext context, Class<? extends QuarkusTestProfile> profile) throws Throwable {
        Map<String, String> devDbProps = IntegrationTestUtil.handleDevDb(context);
        quarkusTestProfile = profile;
        currentJUnitTestClass = context.getRequiredTestClass();
        TestResourceManager testResourceManager = null;
        try {
            Class requiredTestClass = context.getRequiredTestClass();
            Map<String, String> sysPropRestore = IntegrationTestUtil.getSysPropsToRestore();
            TestProfileAndProperties testProfileAndProperties = IntegrationTestUtil.determineTestProfileAndProperties(profile, sysPropRestore);
            testResourceManager = new TestResourceManager(requiredTestClass, quarkusTestProfile, Collections.emptyList(), testProfileAndProperties.testProfile != null && testProfileAndProperties.testProfile.disableGlobalTestResources());
            testResourceManager.init();
            hasPerTestResources = testResourceManager.hasPerTestResources();
            HashMap<String, String> additionalProperties = new HashMap<String, String>(testProfileAndProperties.properties);
            additionalProperties.putAll(devDbProps);
            additionalProperties.putAll(testResourceManager.start());
            NativeImageLauncher launcher = new NativeImageLauncher(requiredTestClass);
            IntegrationTestUtil.startLauncher((ArtifactLauncher)launcher, additionalProperties, () -> {
                ssl = true;
            });
            IntegrationTestExtensionState state = new IntegrationTestExtensionState(testResourceManager, (Closeable)launcher, sysPropRestore);
            testHttpEndpointProviders = TestHttpEndpointProvider.load();
            return state;
        }
        catch (Throwable e) {
            try {
                if (testResourceManager != null) {
                    testResourceManager.close();
                }
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        if (!failedBoot) {
            IntegrationTestUtil.doProcessTestInstance(testInstance, context);
        }
    }

    private void throwBootFailureException() {
        if (firstException != null) {
            Throwable throwable = firstException;
            firstException = null;
            throw new RuntimeException(throwable);
        }
        throw new TestAbortedException("Boot failed");
    }
}

