/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.builditem.TestAnnotationBuildItem;
import io.quarkus.deployment.builditem.TestClassPredicateBuildItem;
import io.quarkus.runtime.Timing;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestScopeManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit.NativeImageTest;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.RunningAppConfigResolver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.opentest4j.TestAbortedException;

public class QuarkusTestExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
InvocationInterceptor,
AfterAllCallback {
    protected static final String TEST_LOCATION = "test-location";
    private static boolean failedBoot;
    private static Class<?> actualTestClass;
    private static Object actualTestInstance;
    private static ClassLoader originalCl;
    private static RunningQuarkusApplication runningQuarkusApplication;
    private static Path testClassLocation;

    private ExtensionState doJavaStart(ExtensionContext context, TestResourceManager testResourceManager) {
        try {
            final LinkedBlockingDeque shutdownTasks = new LinkedBlockingDeque();
            Path appClassLocation = PathTestHelper.getAppClassLocation((Class)context.getRequiredTestClass());
            QuarkusBootstrap.Builder runnerBuilder = QuarkusBootstrap.builder((Path)appClassLocation).setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.TEST);
            originalCl = Thread.currentThread().getContextClassLoader();
            testClassLocation = PathTestHelper.getTestClassesLocation((Class)context.getRequiredTestClass());
            if (!appClassLocation.equals(testClassLocation)) {
                runnerBuilder.addAdditionalApplicationArchive(new AdditionalDependency(testClassLocation, false, true, true));
            }
            final CuratedApplication curatedApplication = runnerBuilder.setTest(true).setProjectRoot(new File("").toPath()).build().bootstrap();
            Timing.staticInitStarted((ClassLoader)curatedApplication.getBaseRuntimeClassLoader());
            AugmentAction augmentAction = curatedApplication.createAugmentor(TestBuildChainFunction.class.getName(), Collections.singletonMap(TEST_LOCATION, testClassLocation));
            runningQuarkusApplication = augmentAction.createInitialRuntimeApplication().run(new String[0]);
            ConfigProviderResolver.setInstance((ConfigProviderResolver)new RunningAppConfigResolver(runningQuarkusApplication));
            Thread.currentThread().setContextClassLoader(runningQuarkusApplication.getClassLoader());
            System.setProperty("test.url", TestHTTPResourceManager.getUri((RunningQuarkusApplication)runningQuarkusApplication));
            final Closeable shutdownTask = new Closeable(){

                @Override
                public void close() throws IOException {
                    try {
                        runningQuarkusApplication.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        while (!shutdownTasks.isEmpty()) {
                            ((Runnable)shutdownTasks.pop()).run();
                        }
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        shutdownTask.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        curatedApplication.close();
                    }
                }
            }, "Quarkus Test Cleanup Shutdown task"));
            return new ExtensionState(testResourceManager, shutdownTask);
        }
        catch (Exception | ServiceConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.isNativeTest(context)) {
            return;
        }
        if (!failedBoot) {
            boolean nativeImageTest = this.isNativeTest(context);
            runningQuarkusApplication.getClassLoader().loadClass(RestAssuredURLManager.class.getName()).getDeclaredMethod("clearURL", new Class[0]).invoke(null, new Object[0]);
            runningQuarkusApplication.getClassLoader().loadClass(TestScopeManager.class.getName()).getDeclaredMethod("tearDown", Boolean.TYPE).invoke(null, nativeImageTest);
        }
    }

    private boolean isNativeTest(ExtensionContext context) {
        return context.getRequiredTestClass().isAnnotationPresent(NativeImageTest.class);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.isNativeTest(context)) {
            return;
        }
        if (!failedBoot) {
            boolean nativeImageTest = this.isNativeTest(context);
            if (runningQuarkusApplication != null) {
                runningQuarkusApplication.getClassLoader().loadClass(RestAssuredURLManager.class.getName()).getDeclaredMethod("setURL", Boolean.TYPE).invoke(null, false);
                runningQuarkusApplication.getClassLoader().loadClass(TestScopeManager.class.getName()).getDeclaredMethod("setup", Boolean.TYPE).invoke(null, nativeImageTest);
            }
        }
    }

    private ExtensionState ensureStarted(ExtensionContext extensionContext) {
        ExtensionContext root = extensionContext.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        ExtensionState state = (ExtensionState)store.get((Object)ExtensionState.class.getName(), ExtensionState.class);
        if (state == null && !failedBoot) {
            PropertyTestUtil.setLogFileProperty();
            TestResourceManager testResourceManager = new TestResourceManager(extensionContext.getRequiredTestClass());
            try {
                testResourceManager.start();
                state = this.doJavaStart(extensionContext, testResourceManager);
                store.put((Object)ExtensionState.class.getName(), (Object)state);
            }
            catch (Throwable e) {
                try {
                    testResourceManager.stop();
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
                failedBoot = true;
                throw e;
            }
        }
        return state;
    }

    private static ClassLoader setCCL(ClassLoader cl) {
        Thread thread = Thread.currentThread();
        ClassLoader original = thread.getContextClassLoader();
        thread.setContextClassLoader(cl);
        return original;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        if (this.isNativeTest(context)) {
            return;
        }
        this.ensureStarted(context);
        if (runningQuarkusApplication != null) {
            QuarkusTestExtension.setCCL(runningQuarkusApplication.getClassLoader());
        }
        if (failedBoot) {
            throw new TestAbortedException("Not running test as boot failed");
        }
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeTest(extensionContext)) {
            invocation.proceed();
            return;
        }
        this.ensureStarted(extensionContext);
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T interceptTestClassConstructor(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Constructor<T>> invocationContext, ExtensionContext extensionContext) throws Throwable {
        Object result;
        if (this.isNativeTest(extensionContext)) {
            return (T)invocation.proceed();
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(extensionContext.getRequiredTestClass().getClassLoader());
            result = invocation.proceed();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        ExtensionState state = this.ensureStarted(extensionContext);
        if (failedBoot) {
            return (T)invocation.proceed();
        }
        this.initTestState(extensionContext, state);
        return (T)result;
    }

    private void initTestState(ExtensionContext extensionContext, ExtensionState state) {
        try {
            actualTestClass = Class.forName(extensionContext.getRequiredTestClass().getName(), true, Thread.currentThread().getContextClassLoader());
            actualTestInstance = runningQuarkusApplication.instance(actualTestClass, new Annotation[0]);
            Class<?> resM = Thread.currentThread().getContextClassLoader().loadClass(TestHTTPResourceManager.class.getName());
            resM.getDeclaredMethod("inject", Object.class).invoke(null, actualTestInstance);
            state.testResourceManager.inject(actualTestInstance);
        }
        catch (Exception e) {
            throw new TestInstantiationException("Failed to create test instance", (Throwable)e);
        }
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeTest(extensionContext)) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeTest(extensionContext)) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeTest(extensionContext)) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeTest(extensionContext)) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeTest(extensionContext)) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    private void runExtensionMethod(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        Method newMethod = null;
        try {
            for (Class<?> c = Class.forName(extensionContext.getRequiredTestClass().getName(), true, Thread.currentThread().getContextClassLoader()); c != Object.class; c = c.getSuperclass()) {
                if (!c.getName().equals(((Method)invocationContext.getExecutable()).getDeclaringClass().getName())) continue;
                try {
                    newMethod = c.getDeclaredMethod(((Method)invocationContext.getExecutable()).getName(), ((Method)invocationContext.getExecutable()).getParameterTypes());
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (newMethod == null) {
                throw new RuntimeException("Could not find method " + invocationContext.getExecutable() + " on test class");
            }
            newMethod.setAccessible(true);
            newMethod.invoke(actualTestInstance, invocationContext.getArguments().toArray());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (originalCl != null) {
            QuarkusTestExtension.setCCL(originalCl);
        }
    }

    public static class TestBuildChainFunction
    implements Function<Map<String, Object>, List<Consumer<BuildChainBuilder>>> {
        @Override
        public List<Consumer<BuildChainBuilder>> apply(Map<String, Object> stringObjectMap) {
            final Path testLocation = (Path)stringObjectMap.get(QuarkusTestExtension.TEST_LOCATION);
            return Collections.singletonList(new Consumer<BuildChainBuilder>(){

                @Override
                public void accept(BuildChainBuilder buildChainBuilder) {
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new TestClassPredicateBuildItem((Predicate)new Predicate<String>(){

                                @Override
                                public boolean test(String className) {
                                    return PathTestHelper.isTestClass((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader(), (Path)testLocation);
                                }
                            }));
                        }
                    }).produces(TestClassPredicateBuildItem.class).build();
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new TestAnnotationBuildItem(QuarkusTest.class.getName()));
                        }
                    }).produces(TestAnnotationBuildItem.class).build();
                }
            });
        }
    }

    class ExtensionState
    implements ExtensionContext.Store.CloseableResource {
        private final TestResourceManager testResourceManager;
        private final Closeable resource;

        ExtensionState(TestResourceManager testResourceManager, Closeable resource) {
            this.testResourceManager = testResourceManager;
            this.resource = resource;
        }

        public void close() throws Throwable {
            try {
                this.resource.close();
            }
            finally {
                ExtensionState extensionState = this;
                if (originalCl != null) {
                    ExtensionState extensionState2 = this;
                    QuarkusTestExtension.setCCL(originalCl);
                }
                this.testResourceManager.stop();
            }
        }
    }
}

