/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.resolver.model.QuarkusModel;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.TestAnnotationBuildItem;
import io.quarkus.deployment.builditem.TestClassBeanBuildItem;
import io.quarkus.deployment.builditem.TestClassPredicateBuildItem;
import io.quarkus.deployment.dev.testing.CurrentTestApplication;
import io.quarkus.dev.testing.TracingHandler;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.DurationConverter;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.runtime.test.TestHttpEndpointProvider;
import io.quarkus.test.common.GroovyCacheCleaner;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestScopeManager;
import io.quarkus.test.common.http.TestHTTPEndpoint;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit.DotNames;
import io.quarkus.test.junit.MockSupport;
import io.quarkus.test.junit.NativeImageTest;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.RunningAppConfigResolver;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.junit.buildchain.TestBuildChainCustomizerProducer;
import io.quarkus.test.junit.callback.QuarkusTestAfterConstructCallback;
import io.quarkus.test.junit.callback.QuarkusTestAfterEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestBeforeAllCallback;
import io.quarkus.test.junit.callback.QuarkusTestBeforeClassCallback;
import io.quarkus.test.junit.callback.QuarkusTestBeforeEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import io.quarkus.test.junit.internal.DeepClone;
import io.quarkus.test.junit.internal.SerializationWithXStreamFallbackDeepClone;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.inject.Alternative;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.opentest4j.TestAbortedException;

public class QuarkusTestExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
InvocationInterceptor,
AfterAllCallback,
ParameterResolver,
ExecutionCondition {
    private static final Logger log = Logger.getLogger(QuarkusTestExtension.class);
    protected static final String TEST_LOCATION = "test-location";
    protected static final String TEST_CLASS = "test-class";
    public static final String QUARKUS_TEST_HANG_DETECTION_TIMEOUT = "quarkus.test.hang-detection-timeout";
    private static boolean failedBoot;
    private static Class<?> actualTestClass;
    private static Object actualTestInstance;
    private static ClassLoader originalCl;
    private static RunningQuarkusApplication runningQuarkusApplication;
    private static Throwable firstException;
    private static List<Object> beforeClassCallbacks;
    private static List<Object> afterConstructCallbacks;
    private static List<Object> legacyAfterConstructCallbacks;
    private static List<Object> beforeEachCallbacks;
    private static List<Object> afterEachCallbacks;
    private static Class<?> quarkusTestMethodContextClass;
    private static Class<? extends QuarkusTestProfile> quarkusTestProfile;
    private static boolean hasPerTestResources;
    private static Class<?> currentJUnitTestClass;
    private static List<Function<Class<?>, String>> testHttpEndpointProviders;
    private static DeepClone deepClone;
    private static final Deque<Class<?>> currentTestClassStack;
    private static ScheduledExecutorService hangDetectionExecutor;
    private static Duration hangTimeout;
    private static ScheduledFuture<?> hangTaskKey;
    private static final Runnable hangDetectionTask;

    private ExtensionState doJavaStart(ExtensionContext context, Class<? extends QuarkusTestProfile> profile) throws Throwable {
        TracingHandler.quarkusStarting();
        hangDetectionExecutor = Executors.newSingleThreadScheduledExecutor();
        String time = "10m";
        String sysPropString = System.getProperty(QUARKUS_TEST_HANG_DETECTION_TIMEOUT);
        if (sysPropString != null) {
            time = sysPropString;
        }
        hangTimeout = new DurationConverter().convert(time);
        hangTaskKey = hangDetectionExecutor.schedule(hangDetectionTask, hangTimeout.toMillis(), TimeUnit.MILLISECONDS);
        quarkusTestProfile = profile;
        currentJUnitTestClass = context.getRequiredTestClass();
        Closeable testResourceManager = null;
        try {
            ExtensionState state;
            CuratedApplication curatedApplication;
            Path outputDir;
            final LinkedBlockingDeque shutdownTasks = new LinkedBlockingDeque();
            final Class requiredTestClass = context.getRequiredTestClass();
            Path testClassLocation = PathTestHelper.getTestClassesLocation((Class)requiredTestClass);
            Path appClassLocation = PathTestHelper.getAppClassLocationForTestLocation((String)testClassLocation.toString());
            PathsCollection.Builder rootBuilder = PathsCollection.builder();
            if (!appClassLocation.equals(testClassLocation)) {
                rootBuilder.add(testClassLocation);
                Path testResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)testClassLocation, (String)"test");
                if (testResourcesLocation != null) {
                    rootBuilder.add(testResourcesLocation);
                }
            }
            originalCl = Thread.currentThread().getContextClassLoader();
            final HashMap<String, String> sysPropRestore = new HashMap<String, String>();
            sysPropRestore.put("quarkus.test.profile", System.getProperty("quarkus.test.profile"));
            System.clearProperty("test.url");
            QuarkusTestProfile profileInstance = null;
            if (profile != null) {
                profileInstance = profile.getConstructor(new Class[0]).newInstance(new Object[0]);
                HashMap<String, String> additional = new HashMap<String, String>(profileInstance.getConfigOverrides());
                if (!profileInstance.getEnabledAlternatives().isEmpty()) {
                    additional.put("quarkus.arc.selected-alternatives", profileInstance.getEnabledAlternatives().stream().peek(c -> {
                        if (!c.isAnnotationPresent(Alternative.class)) {
                            throw new RuntimeException("Enabled alternative " + c + " is not annotated with @Alternative");
                        }
                    }).map(Class::getName).collect(Collectors.joining(",")));
                }
                if (profileInstance.disableApplicationLifecycleObservers()) {
                    additional.put("quarkus.arc.test.disable-application-lifecycle-observers", "true");
                }
                if (profileInstance.getConfigProfile() != null) {
                    System.setProperty("quarkus.test.profile", profileInstance.getConfigProfile());
                }
                for (Map.Entry i : additional.entrySet()) {
                    sysPropRestore.put((String)i.getKey(), System.getProperty((String)i.getKey()));
                }
                for (Map.Entry i : additional.entrySet()) {
                    System.setProperty((String)i.getKey(), (String)i.getValue());
                }
            }
            Path projectRoot = Paths.get("", new String[0]).normalize().toAbsolutePath();
            try {
                outputDir = projectRoot.resolve(projectRoot.relativize(testClassLocation).getName(0));
            }
            catch (Exception e) {
                outputDir = projectRoot;
            }
            rootBuilder.add(appClassLocation);
            Path appResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)appClassLocation, (String)"main");
            if (appResourcesLocation != null) {
                rootBuilder.add(appResourcesLocation);
            }
            if (System.getProperty("quarkus-internal-test.serialized-app-model.path") == null) {
                QuarkusModel model = BuildToolHelper.enableGradleAppModelForTest((Path)projectRoot);
                if (model != null) {
                    Set classDirectories = model.getWorkspace().getMainModule().getSourceSet().getSourceDirectories();
                    Iterator iterator = classDirectories.iterator();
                    while (iterator.hasNext()) {
                        File classes = (File)iterator.next();
                        if (!classes.exists() || rootBuilder.contains(classes.toPath())) continue;
                        rootBuilder.add(classes.toPath());
                    }
                }
            } else if (System.getProperty("OUTPUT_SOURCES_DIR") != null) {
                String[] sourceDirectories = System.getProperty("OUTPUT_SOURCES_DIR").split(",");
                for (String sourceDirectory : sourceDirectories) {
                    Path directory = Paths.get(sourceDirectory, new String[0]);
                    if (!Files.exists(directory, new LinkOption[0]) || rootBuilder.contains(directory)) continue;
                    rootBuilder.add(directory);
                }
            }
            if (CurrentTestApplication.curatedApplication != null) {
                curatedApplication = CurrentTestApplication.curatedApplication;
            } else {
                QuarkusBootstrap.Builder runnerBuilder = QuarkusBootstrap.builder().setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.TEST);
                runnerBuilder.setTargetDirectory(outputDir);
                runnerBuilder.setProjectRoot(projectRoot);
                runnerBuilder.setApplicationRoot(rootBuilder.build());
                curatedApplication = runnerBuilder.setTest(true).build().bootstrap();
            }
            Index testClassesIndex = TestClassIndexer.indexTestClasses((Class)requiredTestClass);
            TestClassIndexer.writeIndex((Index)testClassesIndex, (Class)requiredTestClass);
            Timing.staticInitStarted((ClassLoader)curatedApplication.getBaseRuntimeClassLoader(), (boolean)curatedApplication.getQuarkusBootstrap().isAuxiliaryApplication());
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put(TEST_LOCATION, testClassLocation);
            props.put(TEST_CLASS, requiredTestClass);
            AugmentAction augmentAction = curatedApplication.createAugmentor(TestBuildChainFunction.class.getName(), props);
            testHttpEndpointProviders = TestHttpEndpointProvider.load();
            StartupAction startupAction = augmentAction.createInitialRuntimeApplication();
            Thread.currentThread().setContextClassLoader(startupAction.getClassLoader());
            this.populateDeepCloneField(startupAction);
            testResourceManager = (Closeable)startupAction.getClassLoader().loadClass(TestResourceManager.class.getName()).getConstructor(Class.class, Class.class, List.class, Boolean.TYPE).newInstance(requiredTestClass, profile != null ? profile : null, this.getAdditionalTestResources(profileInstance, startupAction.getClassLoader()), profileInstance != null && profileInstance.disableGlobalTestResources());
            testResourceManager.getClass().getMethod("init", new Class[0]).invoke((Object)testResourceManager, new Object[0]);
            Map properties = (Map)testResourceManager.getClass().getMethod("start", new Class[0]).invoke((Object)testResourceManager, new Object[0]);
            startupAction.overrideConfig(properties);
            hasPerTestResources = (Boolean)testResourceManager.getClass().getMethod("hasPerTestResources", new Class[0]).invoke((Object)testResourceManager, new Object[0]);
            this.populateCallbacks(startupAction.getClassLoader());
            runningQuarkusApplication = startupAction.run(new String[0]);
            TracingHandler.quarkusStarted();
            if (hangTaskKey != null) {
                hangTaskKey.cancel(false);
                hangTimeout = runningQuarkusApplication.getConfigValue(QUARKUS_TEST_HANG_DETECTION_TIMEOUT, Duration.class).orElse(Duration.of(10L, ChronoUnit.MINUTES));
                hangTaskKey = hangDetectionExecutor.schedule(hangDetectionTask, hangTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            ConfigProviderResolver.setInstance((ConfigProviderResolver)new RunningAppConfigResolver(runningQuarkusApplication));
            System.setProperty("test.url", TestHTTPResourceManager.getUri((RunningQuarkusApplication)runningQuarkusApplication));
            final Closeable tm = testResourceManager;
            Closeable shutdownTask = new Closeable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    TracingHandler.quarkusStopping();
                    try {
                        runningQuarkusApplication.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        TracingHandler.quarkusStopped();
                        try {
                            while (!shutdownTasks.isEmpty()) {
                                ((Runnable)shutdownTasks.pop()).run();
                            }
                        }
                        finally {
                            try {
                                for (Map.Entry entry : sysPropRestore.entrySet()) {
                                    String val = (String)entry.getValue();
                                    if (val == null) {
                                        System.clearProperty((String)entry.getKey());
                                        continue;
                                    }
                                    System.setProperty((String)entry.getKey(), val);
                                }
                                tm.close();
                            }
                            finally {
                                GroovyCacheCleaner.clearGroovyCache();
                                if (hangTaskKey != null) {
                                    hangTaskKey.cancel(true);
                                    hangTaskKey = null;
                                }
                                hangDetectionExecutor.shutdownNow();
                                hangDetectionExecutor = null;
                            }
                        }
                        try {
                            TestClassIndexer.removeIndex((Class)requiredTestClass);
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            ExtensionState extensionState = state = new ExtensionState(testResourceManager, shutdownTask);
            return extensionState;
        }
        catch (Throwable e) {
            try {
                if (testResourceManager != null) {
                    testResourceManager.close();
                }
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
        finally {
            if (originalCl != null) {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }
    }

    private List<Object> getAdditionalTestResources(QuarkusTestProfile profileInstance, ClassLoader classLoader) {
        if (profileInstance == null || profileInstance.testResources().isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Constructor<?> testResourceClassEntryConstructor = Class.forName(TestResourceManager.TestResourceClassEntry.class.getName(), true, classLoader).getConstructor(Class.class, Map.class, Annotation.class, Boolean.TYPE);
            List<QuarkusTestProfile.TestResourceEntry> testResources = profileInstance.testResources();
            ArrayList<Object> result = new ArrayList<Object>(testResources.size());
            for (QuarkusTestProfile.TestResourceEntry testResource : testResources) {
                Object instance = testResourceClassEntryConstructor.newInstance(Class.forName(testResource.getClazz().getName(), true, classLoader), testResource.getArgs(), null, testResource.isParallel());
                result.add(instance);
            }
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to handle profile " + profileInstance.getClass(), e);
        }
    }

    private void populateDeepCloneField(StartupAction startupAction) {
        deepClone = new SerializationWithXStreamFallbackDeepClone(startupAction.getClassLoader());
    }

    private void populateCallbacks(ClassLoader classLoader) throws ClassNotFoundException {
        quarkusTestMethodContextClass = null;
        beforeClassCallbacks = new ArrayList<Object>();
        afterConstructCallbacks = new ArrayList<Object>();
        legacyAfterConstructCallbacks = new ArrayList<Object>();
        beforeEachCallbacks = new ArrayList<Object>();
        afterEachCallbacks = new ArrayList<Object>();
        ServiceLoader<Object> quarkusTestBeforeClassLoader = ServiceLoader.load(Class.forName(QuarkusTestBeforeClassCallback.class.getName(), false, classLoader), classLoader);
        for (Iterator<Object> quarkusTestBeforeClassCallback : quarkusTestBeforeClassLoader) {
            beforeClassCallbacks.add(quarkusTestBeforeClassCallback);
        }
        ServiceLoader<Object> quarkusTestAfterConstructLoader = ServiceLoader.load(Class.forName(QuarkusTestAfterConstructCallback.class.getName(), false, classLoader), classLoader);
        for (Iterator<Object> quarkusTestAfterConstructCallback : quarkusTestAfterConstructLoader) {
            afterConstructCallbacks.add(quarkusTestAfterConstructCallback);
        }
        ServiceLoader<Object> quarkusTestLegacyAfterConstructLoader = ServiceLoader.load(Class.forName(QuarkusTestBeforeAllCallback.class.getName(), false, classLoader), classLoader);
        for (Iterator quarkusTestLegacyAfterConstructCallback : quarkusTestLegacyAfterConstructLoader) {
            legacyAfterConstructCallbacks.add(quarkusTestLegacyAfterConstructCallback);
        }
        ServiceLoader quarkusTestBeforeEachLoader = ServiceLoader.load(Class.forName(QuarkusTestBeforeEachCallback.class.getName(), false, classLoader), classLoader);
        for (Object quarkusTestBeforeEachCallback : quarkusTestBeforeEachLoader) {
            beforeEachCallbacks.add(quarkusTestBeforeEachCallback);
        }
        ServiceLoader<?> quarkusTestAfterEachLoader = ServiceLoader.load(Class.forName(QuarkusTestAfterEachCallback.class.getName(), false, classLoader), classLoader);
        for (Object quarkusTestAfterEach : quarkusTestAfterEachLoader) {
            afterEachCallbacks.add(quarkusTestAfterEach);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.isNativeOrIntegrationTest()) {
            return;
        }
        QuarkusTestExtension.resetHangTimeout();
        if (!failedBoot) {
            ClassLoader original = QuarkusTestExtension.setCCL(runningQuarkusApplication.getClassLoader());
            try {
                this.pushMockContext();
                for (Object beforeEachCallback : beforeEachCallbacks) {
                    Map.Entry<Class<?>, ?> tuple = this.createQuarkusTestMethodContextTuple(context);
                    beforeEachCallback.getClass().getMethod("beforeEach", tuple.getKey()).invoke(beforeEachCallback, tuple.getValue());
                }
                String endpointPath = QuarkusTestExtension.getEndpointPath(context, testHttpEndpointProviders);
                if (runningQuarkusApplication == null) return;
                boolean secure = false;
                Optional insecureAllowed = runningQuarkusApplication.getConfigValue("quarkus.http.insecure-requests", String.class);
                if (insecureAllowed.isPresent()) {
                    secure = !((String)insecureAllowed.get()).toLowerCase(Locale.ENGLISH).equals("enabled");
                }
                runningQuarkusApplication.getClassLoader().loadClass(RestAssuredURLManager.class.getName()).getDeclaredMethod("setURL", Boolean.TYPE, String.class).invoke(null, secure, endpointPath);
                runningQuarkusApplication.getClassLoader().loadClass(TestScopeManager.class.getName()).getDeclaredMethod("setup", Boolean.TYPE).invoke(null, false);
                return;
            }
            finally {
                QuarkusTestExtension.setCCL(original);
            }
        } else {
            this.throwBootFailureException();
            return;
        }
    }

    public static String getEndpointPath(ExtensionContext context, List<Function<Class<?>, String>> testHttpEndpointProviders) {
        String endpointPath = null;
        TestHTTPEndpoint testHTTPEndpoint = context.getRequiredTestMethod().getAnnotation(TestHTTPEndpoint.class);
        if (testHTTPEndpoint == null) {
            Class clazz = context.getRequiredTestClass();
            while ((testHTTPEndpoint = clazz.getAnnotation(TestHTTPEndpoint.class)) == null && (clazz = clazz.getSuperclass()) != Object.class) {
            }
        }
        if (testHTTPEndpoint != null) {
            Function<Class<?>, String> i;
            Iterator<Function<Class<?>, String>> iterator = testHttpEndpointProviders.iterator();
            while (iterator.hasNext() && (endpointPath = (i = iterator.next()).apply(testHTTPEndpoint.value())) == null) {
            }
            if (endpointPath == null) {
                throw new RuntimeException("Cannot determine HTTP path for endpoint " + testHTTPEndpoint.value() + " for test method " + context.getRequiredTestMethod());
            }
        }
        return endpointPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterEach(ExtensionContext context) throws Exception {
        if (this.isNativeOrIntegrationTest()) {
            return;
        }
        QuarkusTestExtension.resetHangTimeout();
        if (!failedBoot) {
            this.popMockContext();
            ClassLoader original = QuarkusTestExtension.setCCL(runningQuarkusApplication.getClassLoader());
            for (Object afterEachCallback : afterEachCallbacks) {
                Map.Entry<Class<?>, ?> tuple = this.createQuarkusTestMethodContextTuple(context);
                afterEachCallback.getClass().getMethod("afterEach", tuple.getKey()).invoke(afterEachCallback, tuple.getValue());
            }
            try {
                runningQuarkusApplication.getClassLoader().loadClass(RestAssuredURLManager.class.getName()).getDeclaredMethod("clearURL", new Class[0]).invoke(null, new Object[0]);
                runningQuarkusApplication.getClassLoader().loadClass(TestScopeManager.class.getName()).getDeclaredMethod("tearDown", Boolean.TYPE).invoke(null, false);
            }
            finally {
                QuarkusTestExtension.setCCL(original);
            }
        }
    }

    private Map.Entry<Class<?>, ?> createQuarkusTestMethodContextTuple(ExtensionContext context) throws Exception {
        ClassLoader classLoader = runningQuarkusApplication.getClassLoader();
        if (quarkusTestMethodContextClass == null) {
            quarkusTestMethodContextClass = Class.forName(QuarkusTestMethodContext.class.getName(), true, classLoader);
        }
        Method originalTestMethod = context.getRequiredTestMethod();
        Class<?>[] originalParameterTypes = originalTestMethod.getParameterTypes();
        Method actualTestMethod = null;
        Class<?> c = actualTestClass;
        ArrayList parameterTypesFromTccl = new ArrayList(originalParameterTypes.length);
        for (Class<?> type : originalParameterTypes) {
            if (type.isPrimitive()) {
                parameterTypesFromTccl.add(type);
                continue;
            }
            parameterTypesFromTccl.add(Class.forName(type.getName(), true, classLoader));
        }
        Class[] parameterTypes = parameterTypesFromTccl.toArray(new Class[0]);
        while (c != Object.class) {
            try {
                actualTestMethod = c.getDeclaredMethod(originalTestMethod.getName(), parameterTypes);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                c = c.getSuperclass();
            }
        }
        if (actualTestMethod == null) {
            throw new RuntimeException("Could not find method " + originalTestMethod + " on test class");
        }
        Constructor<?> constructor = quarkusTestMethodContextClass.getConstructor(Object.class, Method.class);
        return new AbstractMap.SimpleEntry(quarkusTestMethodContextClass, constructor.newInstance(actualTestInstance, actualTestMethod));
    }

    private boolean isNativeOrIntegrationTest() {
        for (Class<?> i : currentTestClassStack) {
            if (!i.isAnnotationPresent(NativeImageTest.class) && !i.isAnnotationPresent(QuarkusIntegrationTest.class)) continue;
            return true;
        }
        return false;
    }

    private ExtensionState ensureStarted(ExtensionContext extensionContext) {
        boolean reloadTestResources;
        ExtensionContext root = extensionContext.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        ExtensionState state = (ExtensionState)store.get((Object)ExtensionState.class.getName(), ExtensionState.class);
        Class<? extends QuarkusTestProfile> selectedProfile = this.getQuarkusTestProfile(extensionContext);
        boolean wrongProfile = !Objects.equals(selectedProfile, quarkusTestProfile);
        boolean bl = reloadTestResources = !Objects.equals(extensionContext.getRequiredTestClass(), currentJUnitTestClass) && (hasPerTestResources || QuarkusTestExtension.hasPerTestResources(extensionContext));
        if (state == null && !failedBoot || wrongProfile || reloadTestResources) {
            if ((wrongProfile || reloadTestResources) && state != null) {
                try {
                    state.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            PropertyTestUtil.setLogFileProperty();
            try {
                state = this.doJavaStart(extensionContext, selectedProfile);
                store.put((Object)ExtensionState.class.getName(), (Object)state);
            }
            catch (Throwable e) {
                failedBoot = true;
                firstException = e;
                store.put((Object)FailedCleanup.class.getName(), (Object)new FailedCleanup());
            }
        }
        return state;
    }

    private Class<? extends QuarkusTestProfile> getQuarkusTestProfile(ExtensionContext extensionContext) {
        TestProfile annotation = extensionContext.getRequiredTestClass().getAnnotation(TestProfile.class);
        Class<? extends QuarkusTestProfile> selectedProfile = null;
        if (annotation != null) {
            selectedProfile = annotation.value();
        }
        return selectedProfile;
    }

    private static ClassLoader setCCL(ClassLoader cl) {
        Thread thread = Thread.currentThread();
        ClassLoader original = thread.getContextClassLoader();
        thread.setContextClassLoader(cl);
        return original;
    }

    private void throwBootFailureException() throws Exception {
        if (firstException != null) {
            Throwable throwable = firstException;
            firstException = null;
            throw new RuntimeException(throwable);
        }
        throw new TestAbortedException("Boot failed");
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        currentTestClassStack.push(context.getRequiredTestClass());
        ProfileManager.setLaunchMode((LaunchMode)LaunchMode.TEST);
        if (this.isNativeOrIntegrationTest()) {
            return;
        }
        QuarkusTestExtension.resetHangTimeout();
        this.ensureStarted(context);
        if (runningQuarkusApplication != null) {
            this.pushMockContext();
        }
    }

    private void pushMockContext() {
        try {
            Method pushContext = runningQuarkusApplication.getClassLoader().loadClass(MockSupport.class.getName()).getDeclaredMethod("pushContext", new Class[0]);
            pushContext.setAccessible(true);
            pushContext.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void popMockContext() {
        try {
            Method popContext = runningQuarkusApplication.getClassLoader().loadClass(MockSupport.class.getName()).getDeclaredMethod("popContext", new Class[0]);
            popContext.setAccessible(true);
            popContext.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest()) {
            invocation.proceed();
            return;
        }
        QuarkusTestExtension.resetHangTimeout();
        this.ensureStarted(extensionContext);
        if (failedBoot) {
            this.throwBootFailureException();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T interceptTestClassConstructor(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Constructor<T>> invocationContext, ExtensionContext extensionContext) throws Throwable {
        Object result;
        if (this.isNativeOrIntegrationTest()) {
            return (T)invocation.proceed();
        }
        QuarkusTestExtension.resetHangTimeout();
        ExtensionState state = this.ensureStarted(extensionContext);
        if (failedBoot) {
            this.throwBootFailureException();
            return null;
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Class requiredTestClass = extensionContext.getRequiredTestClass();
        if (runningQuarkusApplication != null) {
            try {
                Thread.currentThread().setContextClassLoader(runningQuarkusApplication.getClassLoader());
                for (Object beforeClassCallback : beforeClassCallbacks) {
                    beforeClassCallback.getClass().getMethod("beforeClass", Class.class).invoke(beforeClassCallback, runningQuarkusApplication.getClassLoader().loadClass(requiredTestClass.getName()));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        } else {
            for (Object beforeClassCallback : beforeClassCallbacks) {
                beforeClassCallback.getClass().getMethod("beforeClass", Class.class).invoke(beforeClassCallback, requiredTestClass);
            }
        }
        try {
            Thread.currentThread().setContextClassLoader(requiredTestClass.getClassLoader());
            result = invocation.proceed();
        }
        catch (NullPointerException e) {
            throw new RuntimeException("When using constructor injection in a test, the only legal operation is to assign the constructor values to fields. Offending class is " + requiredTestClass, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        old = null;
        if (runningQuarkusApplication != null) {
            old = QuarkusTestExtension.setCCL(runningQuarkusApplication.getClassLoader());
        }
        this.initTestState(extensionContext, state);
        if (old != null) {
            QuarkusTestExtension.setCCL(old);
        }
        return (T)result;
    }

    private void initTestState(ExtensionContext extensionContext, ExtensionState state) {
        try {
            Class<?> previousActualTestClass = actualTestClass;
            actualTestClass = Class.forName(extensionContext.getRequiredTestClass().getName(), true, Thread.currentThread().getContextClassLoader());
            if (extensionContext.getRequiredTestClass().isAnnotationPresent(Nested.class)) {
                Class<?> parent = actualTestClass.getEnclosingClass();
                Object parentInstance = runningQuarkusApplication.instance(parent, new Annotation[0]);
                Constructor<?> declaredConstructor = actualTestClass.getDeclaredConstructor(parent);
                declaredConstructor.setAccessible(true);
                actualTestInstance = declaredConstructor.newInstance(parentInstance);
            } else {
                actualTestInstance = runningQuarkusApplication.instance(actualTestClass, new Annotation[0]);
            }
            Class<?> resM = Thread.currentThread().getContextClassLoader().loadClass(TestHTTPResourceManager.class.getName());
            resM.getDeclaredMethod("inject", Object.class, List.class).invoke(null, actualTestInstance, testHttpEndpointProviders);
            state.testResourceManager.getClass().getMethod("inject", Object.class).invoke((Object)state.testResourceManager, actualTestInstance);
            for (Object afterConstructCallback : afterConstructCallbacks) {
                afterConstructCallback.getClass().getMethod("afterConstruct", Object.class).invoke(afterConstructCallback, actualTestInstance);
            }
            for (Object legacyAfterConstructCallback : legacyAfterConstructCallbacks) {
                legacyAfterConstructCallback.getClass().getMethod("beforeAll", Object.class).invoke(legacyAfterConstructCallback, actualTestInstance);
            }
        }
        catch (Exception e) {
            throw new TestInstantiationException("Failed to create test instance", (Throwable)e);
        }
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest()) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest()) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest()) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest()) {
            return (T)invocation.proceed();
        }
        Object result = this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
        return (T)result;
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest()) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest()) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    private Object runExtensionMethod(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        QuarkusTestExtension.resetHangTimeout();
        Method newMethod = null;
        ClassLoader old = QuarkusTestExtension.setCCL(runningQuarkusApplication.getClassLoader());
        try {
            for (Class<?> c = Class.forName(extensionContext.getRequiredTestClass().getName(), true, Thread.currentThread().getContextClassLoader()); c != Object.class; c = c.getSuperclass()) {
                if (!c.getName().equals(((Method)invocationContext.getExecutable()).getDeclaringClass().getName())) continue;
                try {
                    Class<?>[] originalParameterTypes = ((Method)invocationContext.getExecutable()).getParameterTypes();
                    ArrayList parameterTypesFromTccl = new ArrayList(originalParameterTypes.length);
                    for (Class<?> type : originalParameterTypes) {
                        if (type.isPrimitive()) {
                            parameterTypesFromTccl.add(type);
                            continue;
                        }
                        parameterTypesFromTccl.add(Class.forName(type.getName(), true, Thread.currentThread().getContextClassLoader()));
                    }
                    newMethod = c.getDeclaredMethod(((Method)invocationContext.getExecutable()).getName(), parameterTypesFromTccl.toArray(new Class[0]));
                    break;
                }
                catch (NoSuchMethodException originalParameterTypes) {
                    // empty catch block
                }
            }
            if (newMethod == null) {
                throw new RuntimeException("Could not find method " + invocationContext.getExecutable() + " on test class");
            }
            newMethod.setAccessible(true);
            List originalArguments = invocationContext.getArguments();
            ArrayList<Object> argumentsFromTccl = new ArrayList<Object>();
            for (Object arg : originalArguments) {
                argumentsFromTccl.add(deepClone.clone(arg));
            }
            Object object = newMethod.invoke(actualTestInstance, argumentsFromTccl.toArray(new Object[0]));
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        finally {
            QuarkusTestExtension.setCCL(old);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        QuarkusTestExtension.resetHangTimeout();
        try {
            if (!this.isNativeOrIntegrationTest() && runningQuarkusApplication != null) {
                this.popMockContext();
            }
            if (originalCl != null) {
                QuarkusTestExtension.setCCL(originalCl);
            }
        }
        finally {
            currentTestClassStack.pop();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getDeclaringExecutable() instanceof Constructor;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        String className;
        switch (className = parameterContext.getParameter().getType().getName()) {
            case "boolean": {
                return false;
            }
            case "byte": 
            case "short": 
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
            case "char": {
                return Character.valueOf('\u0000');
            }
        }
        return null;
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        String[] tags;
        QuarkusTestProfile profileInstance;
        if (!context.getTestClass().isPresent()) {
            return ConditionEvaluationResult.enabled((String)"No test class specified");
        }
        if (context.getTestInstance().isPresent()) {
            return ConditionEvaluationResult.enabled((String)"Quarkus Test Profile tags only affect classes");
        }
        String tagsStr = System.getProperty("quarkus.test.profile.tags");
        if (tagsStr == null || tagsStr.isEmpty()) {
            return ConditionEvaluationResult.enabled((String)"No Quarkus Test Profile tags");
        }
        Class<? extends QuarkusTestProfile> testProfile = this.getQuarkusTestProfile(context);
        if (testProfile == null) {
            return ConditionEvaluationResult.disabled((String)("Test '" + context.getRequiredTestClass() + "' is not annotated with '@QuarkusTestProfile' but 'quarkus.profile.test.tags' was set"));
        }
        try {
            profileInstance = testProfile.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set<String> testProfileTags = profileInstance.tags();
        for (String tag : tags = tagsStr.split(",")) {
            String trimmedTag = tag.trim();
            if (!testProfileTags.contains(trimmedTag)) continue;
            return ConditionEvaluationResult.enabled((String)("Tag '" + trimmedTag + "' is present on '" + testProfile + "' which is used on test '" + context.getRequiredTestClass()));
        }
        return ConditionEvaluationResult.disabled((String)("Test '" + context.getRequiredTestClass() + "' disabled because 'quarkus.profile.test.tags' don't match the tags of '" + testProfile + "'"));
    }

    private static void resetHangTimeout() {
        if (hangTaskKey != null) {
            hangTaskKey.cancel(false);
            hangTaskKey = hangDetectionExecutor.schedule(hangDetectionTask, hangTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    static boolean hasPerTestResources(ExtensionContext extensionContext) {
        return QuarkusTestExtension.hasPerTestResources(extensionContext.getRequiredTestClass());
    }

    public static boolean hasPerTestResources(Class<?> requiredTestClass) {
        while (requiredTestClass != Object.class) {
            for (QuarkusTestResource quarkusTestResource : (QuarkusTestResource[])requiredTestClass.getAnnotationsByType(QuarkusTestResource.class)) {
                if (!quarkusTestResource.restrictToAnnotatedClass()) continue;
                return true;
            }
            for (Annotation annotation : requiredTestClass.getAnnotations()) {
                if (annotation.annotationType() == QuarkusTestResource.class || ((QuarkusTestResource[])annotation.annotationType().getAnnotationsByType(QuarkusTestResource.class)).length <= 0) continue;
                return true;
            }
            requiredTestClass = requiredTestClass.getSuperclass();
        }
        return false;
    }

    static {
        currentTestClassStack = new ArrayDeque();
        hangDetectionTask = new Runnable(){
            final AtomicBoolean runOnce = new AtomicBoolean();

            @Override
            public void run() {
                ThreadInfo[] threads;
                if (!this.runOnce.compareAndSet(false, true)) {
                    return;
                }
                System.err.println("@QuarkusTest has detected a hang, as there has been no test activity in " + hangTimeout);
                System.err.println("To configure this timeout use the quarkus.test.hang-detection-timeout config property");
                System.err.println("A stack track is below to help diagnose the potential hang");
                System.err.println("=== Stack Trace ===");
                for (ThreadInfo info : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                    if (info == null) {
                        System.err.println("  Inactive");
                        continue;
                    }
                    Thread.State state = info.getThreadState();
                    System.err.println("Thread " + info.getThreadName() + ": " + state);
                    if (state == Thread.State.WAITING) {
                        System.err.println("  Waiting on " + info.getLockName());
                    } else if (state == Thread.State.BLOCKED) {
                        System.err.println("  Blocked on " + info.getLockName());
                        System.err.println("  Blocked by " + info.getLockOwnerName());
                    }
                    System.err.println("  Stack:");
                    for (StackTraceElement frame : info.getStackTrace()) {
                        System.err.println("    " + frame.toString());
                    }
                }
                System.err.println("=== End Stack Trace ===");
            }
        };
    }

    public static class TestBuildChainFunction
    implements Function<Map<String, Object>, List<Consumer<BuildChainBuilder>>> {
        @Override
        public List<Consumer<BuildChainBuilder>> apply(Map<String, Object> stringObjectMap) {
            final Path testLocation = (Path)stringObjectMap.get(QuarkusTestExtension.TEST_LOCATION);
            final Index testClassesIndex = TestClassIndexer.readIndex((Class)((Class)stringObjectMap.get(QuarkusTestExtension.TEST_CLASS)));
            ArrayList<Consumer<BuildChainBuilder>> allCustomizers = new ArrayList<Consumer<BuildChainBuilder>>(1);
            Consumer<BuildChainBuilder> defaultCustomizer = new Consumer<BuildChainBuilder>(){
                private static final int ANNOTATION = 8192;

                boolean isAnnotation(int mod) {
                    return (mod & 0x2000) != 0;
                }

                @Override
                public void accept(BuildChainBuilder buildChainBuilder) {
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new TestClassPredicateBuildItem((Predicate)new Predicate<String>(){

                                @Override
                                public boolean test(String className) {
                                    return PathTestHelper.isTestClass((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader(), (Path)testLocation);
                                }
                            }));
                        }
                    }).produces(TestClassPredicateBuildItem.class).build();
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new ApplicationClassPredicateBuildItem((Predicate)new Predicate<String>(){

                                @Override
                                public boolean test(String s) {
                                    QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
                                    List res = cl.getElementsWithResource(s.replace(".", "/") + ".class", true);
                                    return !res.isEmpty();
                                }
                            }));
                        }
                    }).produces(ApplicationClassPredicateBuildItem.class).build();
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new TestAnnotationBuildItem(QuarkusTest.class.getName()));
                        }
                    }).produces(TestAnnotationBuildItem.class).build();
                    final ArrayList<String> testClassBeans = new ArrayList<String>();
                    List extendWith = testClassesIndex.getAnnotations(DotNames.EXTEND_WITH);
                    for (AnnotationInstance annotationInstance : extendWith) {
                        Type[] extendsWithTypes;
                        ClassInfo classInfo;
                        if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS || this.isAnnotation((classInfo = annotationInstance.target().asClass()).flags())) continue;
                        for (Type type : extendsWithTypes = annotationInstance.value().asClassArray()) {
                            if (!DotNames.QUARKUS_TEST_EXTENSION.equals((Object)type.name())) continue;
                            testClassBeans.add(classInfo.name().toString());
                        }
                    }
                    List registerExtension = testClassesIndex.getAnnotations(DotNames.REGISTER_EXTENSION);
                    for (AnnotationInstance annotationInstance : registerExtension) {
                        FieldInfo fieldInfo;
                        if (annotationInstance.target().kind() != AnnotationTarget.Kind.FIELD || !DotNames.QUARKUS_TEST_EXTENSION.equals((Object)(fieldInfo = annotationInstance.target().asField()).type().name())) continue;
                        testClassBeans.add(fieldInfo.declaringClass().name().toString());
                    }
                    if (!testClassBeans.isEmpty()) {
                        buildChainBuilder.addBuildStep(new BuildStep(){

                            public void execute(BuildContext context) {
                                for (String quarkusExtendWithTestClass : testClassBeans) {
                                    context.produce((BuildItem)new TestClassBeanBuildItem(quarkusExtendWithTestClass));
                                }
                            }
                        }).produces(TestClassBeanBuildItem.class).build();
                    }
                }
            };
            allCustomizers.add(defaultCustomizer);
            for (TestBuildChainCustomizerProducer testBuildChainCustomizerProducer : ServiceLoader.load(TestBuildChainCustomizerProducer.class, this.getClass().getClassLoader())) {
                allCustomizers.add(testBuildChainCustomizerProducer.produce(testClassesIndex));
            }
            return allCustomizers;
        }
    }

    class FailedCleanup
    implements ExtensionContext.Store.CloseableResource {
        FailedCleanup() {
        }

        public void close() {
            firstException = null;
            failedBoot = false;
            ConfigProviderResolver.setInstance(null);
        }
    }

    class ExtensionState
    implements ExtensionContext.Store.CloseableResource {
        private final Closeable testResourceManager;
        private final Closeable resource;
        private final AtomicBoolean closed = new AtomicBoolean();
        private final Thread shutdownHook;

        ExtensionState(Closeable testResourceManager, Closeable resource) {
            this.testResourceManager = testResourceManager;
            this.resource = resource;
            this.shutdownHook = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExtensionState.this.close();
                }
            }, "Quarkus Test Cleanup Shutdown task");
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            QuarkusTestExtension.resetHangTimeout();
            if (this.closed.compareAndSet(false, true)) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                if (runningQuarkusApplication != null) {
                    Thread.currentThread().setContextClassLoader(runningQuarkusApplication.getClassLoader());
                }
                try {
                    this.resource.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to shutdown Quarkus", e);
                }
                finally {
                    try {
                        if (originalCl != null) {
                            QuarkusTestExtension.setCCL(originalCl);
                        }
                        this.testResourceManager.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Failed to shutdown Quarkus test resources", (Throwable)e);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(old);
                        ConfigProviderResolver.setInstance(null);
                    }
                }
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
    }
}

