/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.launcher;

import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DefaultJarLauncher;
import io.quarkus.test.common.JarArtifactLauncher;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.junit.ArtifactTypeUtil;
import io.quarkus.test.junit.launcher.ArtifactLauncherProvider;
import io.quarkus.test.junit.launcher.ConfigUtil;
import io.quarkus.test.junit.launcher.DefaultInitContextBase;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.Config;

public class JarLauncherProvider
implements ArtifactLauncherProvider {
    @Override
    public boolean supportsArtifactType(String type) {
        return ArtifactTypeUtil.isJar(type);
    }

    public JarArtifactLauncher create(ArtifactLauncherProvider.CreateContext context) {
        String pathStr = this.getPath(context);
        if (pathStr != null && !pathStr.isEmpty()) {
            ServiceLoader<JarArtifactLauncher> loader = ServiceLoader.load(JarArtifactLauncher.class);
            Iterator<JarArtifactLauncher> iterator = loader.iterator();
            Object launcher = iterator.hasNext() ? iterator.next() : new DefaultJarLauncher();
            Config config = LauncherUtil.installAndGetSomeConfig();
            launcher.init((ArtifactLauncher.InitContext)new DefaultJarInitContext(((OptionalInt)config.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081), ((OptionalInt)config.getValue("quarkus.http.test-ssl-port", OptionalInt.class)).orElse(8444), ConfigUtil.waitTimeValue(config), config.getOptionalValue("quarkus.test.native-image-profile", String.class).orElse(null), this.argLineValue(context, config), context.devServicesLaunchResult(), context.buildOutputDirectory().resolve(pathStr)));
            return launcher;
        }
        throw new IllegalStateException("The path of the native binary could not be determined");
    }

    protected String getPath(ArtifactLauncherProvider.CreateContext context) {
        return context.quarkusArtifactProperties().getProperty("path");
    }

    protected List<String> argLineValue(ArtifactLauncherProvider.CreateContext context, Config config) {
        return ConfigUtil.argLineValue(config);
    }

    static class DefaultJarInitContext
    extends DefaultInitContextBase
    implements JarArtifactLauncher.JarInitContext {
        private final Path jarPath;

        DefaultJarInitContext(int httpPort, int httpsPort, Duration waitTime, String testProfile, List<String> argLine, ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult, Path jarPath) {
            super(httpPort, httpsPort, waitTime, testProfile, argLine, devServicesLaunchResult);
            this.jarPath = jarPath;
        }

        public Path jarPath() {
            return this.jarPath;
        }
    }
}

