/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.deployment.dev.testing.CurrentTestApplication;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.RestorableSystemProperties;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.junit.AbstractQuarkusTestWithContextExtension;
import io.quarkus.test.junit.QuarkusTestExtension;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.inject.Alternative;
import org.jboss.jandex.Index;
import org.junit.jupiter.api.extension.ExtensionContext;

public class AbstractJvmQuarkusTestExtension
extends AbstractQuarkusTestWithContextExtension {
    protected static final String TEST_LOCATION = "test-location";
    protected static final String TEST_CLASS = "test-class";
    protected ClassLoader originalCl;
    protected static Class<? extends QuarkusTestProfile> quarkusTestProfile;
    protected static final Deque<Class<?>> currentTestClassStack;
    protected static Class<?> currentJUnitTestClass;

    protected PrepareResult createAugmentor(ExtensionContext context, Class<? extends QuarkusTestProfile> profile, Collection<Runnable> shutdownTasks) throws Exception {
        CuratedApplication curatedApplication;
        Class requiredTestClass;
        currentJUnitTestClass = requiredTestClass = context.getRequiredTestClass();
        Path testClassLocation = PathTestHelper.getTestClassesLocation((Class)requiredTestClass);
        Path appClassLocation = PathTestHelper.getAppClassLocationForTestLocation((String)testClassLocation.toString());
        PathList.Builder rootBuilder = PathList.builder();
        Consumer<Path> addToBuilderIfConditionMet = path -> {
            if (path != null && Files.exists(path, new LinkOption[0]) && !rootBuilder.contains(path)) {
                rootBuilder.add(path);
            }
        };
        if (!appClassLocation.equals(testClassLocation)) {
            addToBuilderIfConditionMet.accept(testClassLocation);
            Path testResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)testClassLocation, (String)"test");
            addToBuilderIfConditionMet.accept(testResourcesLocation);
        }
        this.originalCl = Thread.currentThread().getContextClassLoader();
        System.clearProperty("test.url");
        HashMap<String, String> additional = new HashMap<String, String>();
        QuarkusTestProfile profileInstance = null;
        if (profile != null) {
            profileInstance = profile.getConstructor(new Class[0]).newInstance(new Object[0]);
            additional.putAll(profileInstance.getConfigOverrides());
            if (!profileInstance.getEnabledAlternatives().isEmpty()) {
                additional.put("quarkus.arc.selected-alternatives", profileInstance.getEnabledAlternatives().stream().peek(c -> {
                    if (!c.isAnnotationPresent(Alternative.class)) {
                        throw new RuntimeException("Enabled alternative " + c + " is not annotated with @Alternative");
                    }
                }).map(Class::getName).collect(Collectors.joining(",")));
            }
            if (profileInstance.disableApplicationLifecycleObservers()) {
                additional.put("quarkus.arc.test.disable-application-lifecycle-observers", "true");
            }
            if (profileInstance.getConfigProfile() != null) {
                additional.put("quarkus.test.profile", profileInstance.getConfigProfile());
            }
            shutdownTasks.add(() -> ((RestorableSystemProperties)RestorableSystemProperties.setProperties(additional, (String[])new String[0])).close());
        }
        Path projectRoot = Paths.get("", new String[0]).normalize().toAbsolutePath();
        addToBuilderIfConditionMet.accept(appClassLocation);
        Path appResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)appClassLocation, (String)"main");
        addToBuilderIfConditionMet.accept(appResourcesLocation);
        if (System.getProperty("quarkus-internal-test.serialized-app-model.path") == null) {
            ApplicationModel model = BuildToolHelper.enableGradleAppModelForTest((Path)projectRoot);
            if (model != null && model.getApplicationModule() != null) {
                Path classesDir;
                ArtifactSources artifactSrc = model.getApplicationModule().getTestSources();
                if (artifactSrc != null) {
                    for (SourceDir src : artifactSrc.getSourceDirs()) {
                        if (!Files.exists(src.getOutputDir(), new LinkOption[0])) continue;
                        classesDir = src.getOutputDir();
                        addToBuilderIfConditionMet.accept(classesDir);
                    }
                }
                for (SourceDir src : model.getApplicationModule().getMainSources().getSourceDirs()) {
                    if (!Files.exists(src.getOutputDir(), new LinkOption[0])) continue;
                    classesDir = src.getOutputDir();
                    addToBuilderIfConditionMet.accept(classesDir);
                }
            }
        } else if (System.getProperty("OUTPUT_SOURCES_DIR") != null) {
            ArtifactSources sourceDirectories;
            for (ArtifactSources sourceDirectory : sourceDirectories = System.getProperty("OUTPUT_SOURCES_DIR").split(",")) {
                Path directory = Paths.get((String)sourceDirectory, new String[0]);
                addToBuilderIfConditionMet.accept(directory);
            }
        }
        if (CurrentTestApplication.curatedApplication != null) {
            curatedApplication = CurrentTestApplication.curatedApplication;
        } else {
            QuarkusBootstrap.Builder runnerBuilder = QuarkusBootstrap.builder().setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.TEST);
            runnerBuilder.setTargetDirectory(PathTestHelper.getProjectBuildDir((Path)projectRoot, (Path)testClassLocation));
            runnerBuilder.setProjectRoot(projectRoot);
            runnerBuilder.setApplicationRoot((PathCollection)rootBuilder.build());
            curatedApplication = runnerBuilder.setTest(true).build().bootstrap();
            shutdownTasks.add(() -> ((CuratedApplication)curatedApplication).close());
        }
        if (curatedApplication.getApplicationModel().getRuntimeDependencies().isEmpty()) {
            throw new RuntimeException("The tests were run against a directory that does not contain a Quarkus project. Please ensure that the test is configured to use the proper working directory.");
        }
        Index testClassesIndex = TestClassIndexer.indexTestClasses((Class)requiredTestClass);
        TestClassIndexer.writeIndex((Index)testClassesIndex, (Class)requiredTestClass);
        Timing.staticInitStarted((ClassLoader)curatedApplication.getBaseRuntimeClassLoader(), (boolean)curatedApplication.getQuarkusBootstrap().isAuxiliaryApplication());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(TEST_LOCATION, testClassLocation);
        props.put(TEST_CLASS, requiredTestClass);
        quarkusTestProfile = profile;
        return new PrepareResult(curatedApplication.createAugmentor(QuarkusTestExtension.TestBuildChainFunction.class.getName(), props), profileInstance, curatedApplication);
    }

    protected Class<? extends QuarkusTestProfile> getQuarkusTestProfile(ExtensionContext extensionContext) {
        for (Class<?> testClass = extensionContext.getRequiredTestClass(); testClass != null; testClass = testClass.getEnclosingClass()) {
            TestProfile annotation = testClass.getAnnotation(TestProfile.class);
            if (annotation == null) continue;
            return annotation.value();
        }
        return null;
    }

    protected static boolean hasPerTestResources(ExtensionContext extensionContext) {
        return AbstractJvmQuarkusTestExtension.hasPerTestResources(extensionContext.getRequiredTestClass());
    }

    public static boolean hasPerTestResources(Class<?> requiredTestClass) {
        while (requiredTestClass != Object.class) {
            for (QuarkusTestResource quarkusTestResource : (QuarkusTestResource[])requiredTestClass.getAnnotationsByType(QuarkusTestResource.class)) {
                if (!quarkusTestResource.restrictToAnnotatedClass()) continue;
                return true;
            }
            for (Annotation annotation : requiredTestClass.getAnnotations()) {
                if (annotation.annotationType() == QuarkusTestResource.class || ((QuarkusTestResource[])annotation.annotationType().getAnnotationsByType(QuarkusTestResource.class)).length <= 0) continue;
                return true;
            }
            requiredTestClass = requiredTestClass.getSuperclass();
        }
        return false;
    }

    static {
        currentTestClassStack = new ArrayDeque();
    }

    protected static class PrepareResult {
        protected final AugmentAction augmentAction;
        protected final QuarkusTestProfile profileInstance;
        protected final CuratedApplication curatedApplication;

        public PrepareResult(AugmentAction augmentAction, QuarkusTestProfile profileInstance, CuratedApplication curatedApplication) {
            this.augmentAction = augmentAction;
            this.profileInstance = profileInstance;
            this.curatedApplication = curatedApplication;
        }
    }
}

