/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.internal;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Optional;

public class OptionalConverter
implements Converter {
    private final Mapper mapper;

    public OptionalConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Optional optional = (Optional)source;
        if (optional.isPresent()) {
            Object item = optional.get();
            String name = this.mapper.serializedClass(item.getClass());
            writer.startNode(name);
            context.convertAnother(item);
            writer.endNode();
        } else {
            String name = this.mapper.serializedClass(null);
            writer.startNode(name);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        Class type = HierarchicalStreams.readClassType((HierarchicalStreamReader)reader, (Mapper)this.mapper);
        Object item = context.convertAnother(null, type);
        reader.moveUp();
        return Optional.ofNullable(item);
    }

    public boolean canConvert(Class type) {
        return type == Optional.class;
    }
}

