/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.launcher;

import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DefaultDockerContainerLauncher;
import io.quarkus.test.common.DockerContainerArtifactLauncher;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.junit.launcher.ArtifactLauncherProvider;
import io.quarkus.test.junit.launcher.ConfigUtil;
import io.quarkus.test.junit.launcher.DefaultInitContextBase;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.Config;

public class DockerContainerLauncherProvider
implements ArtifactLauncherProvider {
    @Override
    public boolean supportsArtifactType(String type) {
        return "jar-container".equals(type) || "native-container".equals(type);
    }

    public DockerContainerArtifactLauncher create(ArtifactLauncherProvider.CreateContext context) {
        String containerImage = context.quarkusArtifactProperties().getProperty("metadata.container-image");
        boolean pullRequired = Boolean.parseBoolean(context.quarkusArtifactProperties().getProperty("metadata.pull-required", "false"));
        if (containerImage != null && !containerImage.isEmpty()) {
            ServiceLoader<DockerContainerArtifactLauncher> loader = ServiceLoader.load(DockerContainerArtifactLauncher.class);
            Iterator<DockerContainerArtifactLauncher> iterator = loader.iterator();
            Object launcher = iterator.hasNext() ? iterator.next() : new DefaultDockerContainerLauncher();
            Config config = LauncherUtil.installAndGetSomeConfig();
            launcher.init((ArtifactLauncher.InitContext)new DefaultDockerInitContext(((OptionalInt)config.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081), ((OptionalInt)config.getValue("quarkus.http.test-ssl-port", OptionalInt.class)).orElse(8444), Duration.ofSeconds(((OptionalLong)config.getValue("quarkus.test.jar-wait-time", OptionalLong.class)).orElse(60L)), config.getOptionalValue("quarkus.test.native-image-profile", String.class).orElse(null), ConfigUtil.argLineValue(config), context.devServicesLaunchResult(), containerImage, pullRequired));
            return launcher;
        }
        throw new IllegalStateException("The container image to be launched could not be determined");
    }

    static class DefaultDockerInitContext
    extends DefaultInitContextBase
    implements DockerContainerArtifactLauncher.DockerInitContext {
        private final String containerImage;
        private final boolean pullRequired;

        public DefaultDockerInitContext(int httpPort, int httpsPort, Duration waitTime, String testProfile, List<String> argLine, ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult, String containerImage, boolean pullRequired) {
            super(httpPort, httpsPort, waitTime, testProfile, argLine, devServicesLaunchResult);
            this.containerImage = containerImage;
            this.pullRequired = pullRequired;
        }

        public String containerImage() {
            return this.containerImage;
        }

        public boolean pullRequired() {
            return this.pullRequired;
        }
    }
}

