/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.junit.DisabledOnIntegrationTest;
import io.quarkus.test.junit.DisabledOnNativeImage;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.main.QuarkusMainIntegrationTest;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.StringUtils;

public class DisabledOnIntegrationTestCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"@DisabledOnIntegrationTest is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        ConditionEvaluationResult disabledOnIntegrationTestReason = this.check(context, element, DisabledOnIntegrationTest.class, DisabledOnIntegrationTest::value);
        if (disabledOnIntegrationTestReason != null) {
            return disabledOnIntegrationTestReason;
        }
        ConditionEvaluationResult disabledOnNativeImageReason = this.check(context, element, DisabledOnNativeImage.class, DisabledOnNativeImage::value);
        if (disabledOnNativeImageReason != null) {
            return disabledOnNativeImageReason;
        }
        return ENABLED;
    }

    private <T extends Annotation> ConditionEvaluationResult check(ExtensionContext context, Optional<AnnotatedElement> element, Class<T> annotationClass, Function<T, String> valueExtractor) {
        Optional disabled = AnnotationUtils.findAnnotation(element, annotationClass);
        if (disabled.isPresent()) {
            boolean it;
            boolean bl = it = AnnotationUtils.findAnnotation((Optional)context.getTestClass(), QuarkusIntegrationTest.class).isPresent() || AnnotationUtils.findAnnotation((Optional)context.getTestClass(), QuarkusMainIntegrationTest.class).isPresent();
            if (it) {
                String reason = disabled.map(valueExtractor).filter(StringUtils::isNotBlank).orElseGet(() -> element.get() + " is @DisabledOnIntegrationTest");
                return ConditionEvaluationResult.disabled((String)reason);
            }
        }
        return null;
    }
}

