/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.internal;

import com.thoughtworks.xstream.XStream;
import io.quarkus.test.junit.internal.DeepClone;
import java.util.function.Supplier;

class XStreamDeepClone
implements DeepClone {
    private final Supplier<XStream> xStreamSupplier = () -> {
        XStream result = new XStream();
        XStream.setupDefaultSecurity((XStream)result);
        result.allowTypesByRegExp(new String[]{".*"});
        result.setClassLoader(classLoader);
        return result;
    };

    XStreamDeepClone(ClassLoader classLoader) {
    }

    @Override
    public Object clone(Object objectToClone) {
        if (objectToClone == null) {
            return null;
        }
        if (objectToClone instanceof Supplier) {
            return this.handleSupplier((Supplier)objectToClone);
        }
        return this.doClone(objectToClone);
    }

    private Supplier<Object> handleSupplier(final Supplier<?> supplier) {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return XStreamDeepClone.this.doClone(supplier.get());
            }
        };
    }

    private Object doClone(Object objectToClone) {
        String serialized;
        XStream xStream = this.xStreamSupplier.get();
        Object result = xStream.fromXML(serialized = xStream.toXML(objectToClone));
        if (result == null) {
            throw new IllegalStateException("Unable to deep clone object of type '" + objectToClone.getClass().getName() + "'. Please report the issue on the Quarkus issue tracker.");
        }
        return result;
    }
}

