/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.runtime.test.TestHttpEndpointProvider;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DevServicesContext;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestScopeManager;
import io.quarkus.test.junit.IntegrationTestExtensionState;
import io.quarkus.test.junit.IntegrationTestUtil;
import io.quarkus.test.junit.NativeTestExtension;
import io.quarkus.test.junit.QuarkusTestExtension;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfileAndProperties;
import io.quarkus.test.junit.launcher.ArtifactLauncherProvider;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.opentest4j.TestAbortedException;

public class QuarkusIntegrationTestExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
TestInstancePostProcessor {
    private static boolean failedBoot;
    private static List<Function<Class<?>, String>> testHttpEndpointProviders;
    private static boolean ssl;
    private static Class<? extends QuarkusTestProfile> quarkusTestProfile;
    private static Throwable firstException;
    private static Class<?> currentJUnitTestClass;
    private static boolean hasPerTestResources;
    private static Map<String, String> devServicesProps;
    private static String containerNetworkId;

    public void afterEach(ExtensionContext context) throws Exception {
        if (!failedBoot) {
            RestAssuredURLManager.clearURL();
            TestScopeManager.tearDown((boolean)true);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (failedBoot) {
            this.throwBootFailureException();
        } else {
            RestAssuredURLManager.setURL((boolean)ssl, (String)QuarkusTestExtension.getEndpointPath(context, testHttpEndpointProviders));
            TestScopeManager.setup((boolean)true);
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.ensureStarted(extensionContext);
    }

    private IntegrationTestExtensionState ensureStarted(ExtensionContext extensionContext) {
        boolean reloadTestResources;
        Class testClass = extensionContext.getRequiredTestClass();
        IntegrationTestUtil.ensureNoInjectAnnotationIsUsed(testClass);
        Properties quarkusArtifactProperties = IntegrationTestUtil.readQuarkusArtifactProperties(extensionContext);
        ExtensionContext root = extensionContext.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        IntegrationTestExtensionState state = (IntegrationTestExtensionState)store.get((Object)IntegrationTestExtensionState.class.getName(), IntegrationTestExtensionState.class);
        Class<? extends QuarkusTestProfile> selectedProfile = IntegrationTestUtil.findProfile(testClass);
        boolean wrongProfile = !Objects.equals(selectedProfile, quarkusTestProfile);
        boolean bl = reloadTestResources = !Objects.equals(extensionContext.getRequiredTestClass(), currentJUnitTestClass) && (hasPerTestResources || QuarkusTestExtension.hasPerTestResources(extensionContext));
        if (state == null && !failedBoot || wrongProfile || reloadTestResources) {
            if ((wrongProfile || reloadTestResources) && state != null) {
                try {
                    state.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            try {
                state = this.doProcessStart(quarkusArtifactProperties, selectedProfile, extensionContext);
                store.put((Object)IntegrationTestExtensionState.class.getName(), (Object)state);
            }
            catch (Throwable e) {
                try {
                    Path appLogPath = PropertyTestUtil.getLogFilePath();
                    File appLogFile = appLogPath.toFile();
                    if (appLogFile.exists() && appLogFile.length() > 0L) {
                        System.err.println("Failed to launch the application. The application logs can be found at: " + appLogPath.toAbsolutePath());
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                failedBoot = true;
                firstException = e;
            }
        }
        return state;
    }

    private IntegrationTestExtensionState doProcessStart(Properties quarkusArtifactProperties, Class<? extends QuarkusTestProfile> profile, ExtensionContext context) throws Throwable {
        String artifactType = quarkusArtifactProperties.getProperty("type");
        if (artifactType == null) {
            throw new IllegalStateException("Unable to determine the type of artifact created by the Quarkus build");
        }
        boolean isDockerLaunch = "jar-container".equals(artifactType) || "native-container".equals(artifactType);
        ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult = IntegrationTestUtil.handleDevServices(context, isDockerLaunch);
        devServicesProps = devServicesLaunchResult.properties();
        containerNetworkId = devServicesLaunchResult.networkId();
        quarkusTestProfile = profile;
        currentJUnitTestClass = context.getRequiredTestClass();
        TestResourceManager testResourceManager = null;
        try {
            Class requiredTestClass = context.getRequiredTestClass();
            Map<String, String> sysPropRestore = IntegrationTestUtil.getSysPropsToRestore();
            TestProfileAndProperties testProfileAndProperties = IntegrationTestUtil.determineTestProfileAndProperties(profile, sysPropRestore);
            testResourceManager = new TestResourceManager(requiredTestClass, quarkusTestProfile, IntegrationTestUtil.getAdditionalTestResources(testProfileAndProperties.testProfile, context.getRequiredTestClass().getClassLoader()), testProfileAndProperties.testProfile != null && testProfileAndProperties.testProfile.disableGlobalTestResources(), devServicesProps, containerNetworkId == null ? Optional.empty() : Optional.of(containerNetworkId));
            testResourceManager.init(testProfileAndProperties.testProfile != null ? testProfileAndProperties.testProfile.getClass().getName() : null);
            hasPerTestResources = testResourceManager.hasPerTestResources();
            HashMap<String, String> additionalProperties = new HashMap<String, String>(testProfileAndProperties.properties);
            additionalProperties.putAll(devServicesProps);
            Map resourceManagerProps = testResourceManager.start();
            final HashMap<String, String> old = new HashMap<String, String>();
            for (Map.Entry i : resourceManagerProps.entrySet()) {
                old.put((String)i.getKey(), System.getProperty((String)i.getKey()));
                if (i.getValue() == null) {
                    System.clearProperty((String)i.getKey());
                    continue;
                }
                System.setProperty((String)i.getKey(), (String)i.getValue());
            }
            context.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)(NativeTestExtension.class.getName() + ".systemProps"), (Object)new ExtensionContext.Store.CloseableResource(){

                public void close() throws Throwable {
                    for (Map.Entry i : old.entrySet()) {
                        old.put((String)i.getKey(), System.getProperty((String)i.getKey()));
                        if (i.getValue() == null) {
                            System.clearProperty((String)i.getKey());
                            continue;
                        }
                        System.setProperty((String)i.getKey(), (String)i.getValue());
                    }
                }
            });
            additionalProperties.putAll(resourceManagerProps);
            ArtifactLauncher<? extends ArtifactLauncher.InitContext> launcher = null;
            String testHost = System.getProperty("quarkus.http.test-host");
            if (testHost != null && !testHost.isEmpty()) {
                launcher = new ArtifactLauncher<ArtifactLauncher.InitContext>();
            } else {
                ServiceLoader<ArtifactLauncherProvider> loader = ServiceLoader.load(ArtifactLauncherProvider.class);
                for (ArtifactLauncherProvider launcherProvider : loader) {
                    if (!launcherProvider.supportsArtifactType(artifactType)) continue;
                    launcher = launcherProvider.create(new DefaultArtifactLauncherCreateContext(quarkusArtifactProperties, context, requiredTestClass, devServicesLaunchResult));
                    break;
                }
            }
            if (launcher == null) {
                throw new IllegalStateException("Artifact type + '" + artifactType + "' is not supported by @QuarkusIntegrationTest");
            }
            IntegrationTestUtil.activateLogging();
            IntegrationTestUtil.startLauncher((ArtifactLauncher)launcher, additionalProperties, () -> {
                ssl = true;
            });
            IntegrationTestExtensionState state = new IntegrationTestExtensionState(testResourceManager, (Closeable)launcher, sysPropRestore);
            testHttpEndpointProviders = TestHttpEndpointProvider.load();
            return state;
        }
        catch (Throwable e) {
            if (!InitialConfigurator.DELAYED_HANDLER.isActivated()) {
                IntegrationTestUtil.activateLogging();
            }
            try {
                if (testResourceManager != null) {
                    testResourceManager.close();
                }
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        this.ensureStarted(context);
        if (!failedBoot) {
            IntegrationTestUtil.doProcessTestInstance(testInstance, context);
            this.injectTestContext(testInstance);
        }
    }

    private void injectTestContext(Object testInstance) {
        for (Class<?> c = testInstance.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (f.getType().equals(DevServicesContext.class)) {
                    try {
                        f.setAccessible(true);
                        f.set(testInstance, this.createTestContext());
                        return;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to set field '" + f.getName() + "' with the proper test context", e);
                    }
                }
                if (!DevServicesContext.ContextAware.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                try {
                    DevServicesContext.ContextAware val = (DevServicesContext.ContextAware)f.get(testInstance);
                    val.setIntegrationTestContext(this.createTestContext());
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to inject context into field " + f.getName(), e);
                }
            }
        }
    }

    private DevServicesContext createTestContext() {
        Map<String, String> devServicesPropsCopy = devServicesProps.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(devServicesProps);
        return new DefaultQuarkusIntegrationTestContext(devServicesPropsCopy, containerNetworkId == null ? Optional.empty() : Optional.of(containerNetworkId));
    }

    private void throwBootFailureException() {
        if (firstException != null) {
            Throwable throwable = firstException;
            firstException = null;
            throw new RuntimeException(throwable);
        }
        throw new TestAbortedException("Boot failed");
    }

    private static class DefaultQuarkusIntegrationTestContext
    implements DevServicesContext {
        private final Map<String, String> devServicesProperties;
        private final Optional<String> containerNetworkId;

        private DefaultQuarkusIntegrationTestContext(Map<String, String> devServicesProperties, Optional<String> containerNetworkId) {
            this.devServicesProperties = devServicesProperties;
            this.containerNetworkId = containerNetworkId;
        }

        public Map<String, String> devServicesProperties() {
            return this.devServicesProperties;
        }

        public Optional<String> containerNetworkId() {
            return this.containerNetworkId;
        }
    }

    private static class DefaultArtifactLauncherCreateContext
    implements ArtifactLauncherProvider.CreateContext {
        private final Properties quarkusArtifactProperties;
        private final ExtensionContext context;
        private final Class<?> requiredTestClass;
        private final ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult;

        DefaultArtifactLauncherCreateContext(Properties quarkusArtifactProperties, ExtensionContext context, Class<?> requiredTestClass, ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult) {
            this.quarkusArtifactProperties = quarkusArtifactProperties;
            this.context = context;
            this.requiredTestClass = requiredTestClass;
            this.devServicesLaunchResult = devServicesLaunchResult;
        }

        @Override
        public Properties quarkusArtifactProperties() {
            return this.quarkusArtifactProperties;
        }

        @Override
        public Path buildOutputDirectory() {
            return IntegrationTestUtil.determineBuildOutputDirectory(this.context);
        }

        @Override
        public Class<?> testClass() {
            return this.requiredTestClass;
        }

        @Override
        public ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult() {
            return this.devServicesLaunchResult;
        }
    }
}

