/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.launcher;

import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DefaultNativeImageLauncher;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.NativeImageLauncher;
import io.quarkus.test.junit.ArtifactTypeUtil;
import io.quarkus.test.junit.launcher.ArtifactLauncherProvider;
import io.quarkus.test.junit.launcher.ConfigUtil;
import io.quarkus.test.junit.launcher.DefaultInitContextBase;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.Config;

public class NativeImageLauncherProvider
implements ArtifactLauncherProvider {
    @Override
    public boolean supportsArtifactType(String type) {
        return ArtifactTypeUtil.isNativeBinary(type);
    }

    public NativeImageLauncher create(ArtifactLauncherProvider.CreateContext context) {
        String pathStr = context.quarkusArtifactProperties().getProperty("path");
        if (pathStr != null && !pathStr.isEmpty()) {
            ServiceLoader<NativeImageLauncher> loader = ServiceLoader.load(NativeImageLauncher.class);
            Iterator<NativeImageLauncher> iterator = loader.iterator();
            Object launcher = iterator.hasNext() ? iterator.next() : new DefaultNativeImageLauncher();
            Config config = LauncherUtil.installAndGetSomeConfig();
            launcher.init((ArtifactLauncher.InitContext)new DefaultNativeImageInitContext(((OptionalInt)config.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081), ((OptionalInt)config.getValue("quarkus.http.test-ssl-port", OptionalInt.class)).orElse(8444), ConfigUtil.waitTimeValue(config), config.getOptionalValue("quarkus.test.native-image-profile", String.class).orElse(null), ConfigUtil.argLineValue(config), context.devServicesLaunchResult(), System.getProperty("native.image.path"), context.testClass()));
            return launcher;
        }
        throw new IllegalStateException("The path of the native binary could not be determined");
    }

    public static class DefaultNativeImageInitContext
    extends DefaultInitContextBase
    implements NativeImageLauncher.NativeImageInitContext {
        private final String nativeImagePath;
        private final Class<?> testClass;

        public DefaultNativeImageInitContext(int httpPort, int httpsPort, Duration waitTime, String testProfile, List<String> argLine, ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult, String nativeImagePath, Class<?> testClass) {
            super(httpPort, httpsPort, waitTime, testProfile, argLine, devServicesLaunchResult);
            this.nativeImagePath = nativeImagePath;
            this.testClass = testClass;
        }

        public String nativeImagePath() {
            return this.nativeImagePath;
        }

        public Class<?> testClass() {
            return this.testClass;
        }
    }
}

