/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.junit.MockSupport;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

public class QuarkusMock {
    public static <T> void installMockForInstance(T mock, T instance) {
        MockSupport.installMock(instance, mock);
    }

    public static <T> void installMockForType(T mock, Class<? super T> instance, Annotation ... qualifiers) {
        if (!instance.isAssignableFrom(mock.getClass()) && !instance.getClass().getSuperclass().isAssignableFrom(mock.getClass())) {
            throw new RuntimeException(mock + " is not assignable to type " + instance.getClass().getSuperclass());
        }
        MockSupport.installMock(CDI.current().select(instance, qualifiers).get(), mock);
    }
}

