/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.common.TestResourceManager;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.extension.ExtensionContext;

public class QuarkusTestExtensionState
implements ExtensionContext.Store.CloseableResource {
    private final AtomicBoolean closed = new AtomicBoolean();
    protected final Closeable testResourceManager;
    protected final Closeable resource;
    private final Thread shutdownHook;
    private final Runnable clearCallbacks;
    private Throwable testErrorCause;

    public QuarkusTestExtensionState(Closeable testResourceManager, Closeable resource, Runnable clearCallbacks) {
        this.testResourceManager = testResourceManager;
        this.resource = resource;
        this.clearCallbacks = clearCallbacks;
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    QuarkusTestExtensionState.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, "Quarkus Test Cleanup Shutdown task");
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public Throwable getTestErrorCause() {
        return this.testErrorCause;
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.doClose();
            this.clearCallbacks.run();
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void setTestFailed(Throwable failure) {
        try {
            this.testErrorCause = failure;
            if (this.testResourceManager instanceof TestResourceManager) {
                ((TestResourceManager)this.testResourceManager).setTestErrorCause(this.testErrorCause);
            } else {
                this.testResourceManager.getClass().getClassLoader().loadClass(TestResourceManager.class.getName()).getMethod("setTestErrorCause", Throwable.class).invoke((Object)this.testResourceManager, this.testErrorCause);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doClose() throws IOException {
    }
}

