/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.util;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.TestResourceScope;
import io.quarkus.test.common.WithTestResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.junit.main.QuarkusMainTest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.ClassDescriptor;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.ClassOrdererContext;
import org.junit.jupiter.api.Nested;

public class QuarkusTestProfileAwareClassOrderer
implements ClassOrderer {
    protected static final String DEFAULT_ORDER_PREFIX_QUARKUS_TEST = "20_";
    protected static final String DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE = "40_";
    protected static final String DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_RESTRICTED_RES = "45_";
    protected static final String DEFAULT_ORDER_PREFIX_NON_QUARKUS_TEST = "60_";
    static final String CFGKEY_ORDER_PREFIX_QUARKUS_TEST = "junit.quarkus.orderer.prefix.quarkus-test";
    static final String CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE = "junit.quarkus.orderer.prefix.quarkus-test-with-profile";
    static final String CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_RESTRICTED_RES = "junit.quarkus.orderer.prefix.quarkus-test-with-restricted-resource";
    static final String CFGKEY_ORDER_PREFIX_NON_QUARKUS_TEST = "junit.quarkus.orderer.prefix.non-quarkus-test";
    static final String CFGKEY_SECONDARY_ORDERER = "junit.quarkus.orderer.secondary-orderer";

    public void orderClasses(ClassOrdererContext context) {
        if (context.getClassDescriptors().size() <= 1 || ((ClassDescriptor)context.getClassDescriptors().get(0)).isAnnotated(Nested.class)) {
            return;
        }
        String prefixQuarkusTest = this.getConfigParam(CFGKEY_ORDER_PREFIX_QUARKUS_TEST, DEFAULT_ORDER_PREFIX_QUARKUS_TEST, context);
        String prefixQuarkusTestWithProfile = this.getConfigParam(CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE, DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE, context);
        String prefixQuarkusTestWithRestrictedResource = this.getConfigParam(CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_RESTRICTED_RES, DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_RESTRICTED_RES, context);
        String prefixNonQuarkusTest = this.getConfigParam(CFGKEY_ORDER_PREFIX_NON_QUARKUS_TEST, DEFAULT_ORDER_PREFIX_NON_QUARKUS_TEST, context);
        this.buildSecondaryOrderer(context).orderClasses(context);
        List classDecriptors = context.getClassDescriptors();
        Map<ClassDescriptor, String> firstPassIndexMap = IntStream.range(0, classDecriptors.size()).boxed().collect(Collectors.toMap(classDecriptors::get, i -> String.format("%06d", i)));
        classDecriptors.sort(Comparator.comparing(classDescriptor -> {
            String secondaryOrderSuffix = (String)firstPassIndexMap.get(classDescriptor);
            Optional<String> customOrderKey = this.getCustomOrderKey((ClassDescriptor)classDescriptor, context, secondaryOrderSuffix).or(() -> this.getCustomOrderKey((ClassDescriptor)classDescriptor, context));
            if (customOrderKey.isPresent()) {
                return customOrderKey.get();
            }
            if (classDescriptor.isAnnotated(QuarkusTest.class) || classDescriptor.isAnnotated(QuarkusIntegrationTest.class) || classDescriptor.isAnnotated(QuarkusMainTest.class)) {
                return classDescriptor.findAnnotation(TestProfile.class).map(TestProfile::value).map(profileClass -> prefixQuarkusTestWithProfile + profileClass.getName() + "@" + secondaryOrderSuffix).orElseGet(() -> {
                    String prefix = this.hasRestrictedResource((ClassDescriptor)classDescriptor) ? prefixQuarkusTestWithRestrictedResource : prefixQuarkusTest;
                    return prefix + secondaryOrderSuffix;
                });
            }
            return prefixNonQuarkusTest + secondaryOrderSuffix;
        }));
    }

    private String getConfigParam(String key, String fallbackValue, ClassOrdererContext context) {
        return context.getConfigurationParameter(key).orElse(fallbackValue);
    }

    private ClassOrderer buildSecondaryOrderer(ClassOrdererContext context) {
        return Optional.ofNullable(this.getConfigParam(CFGKEY_SECONDARY_ORDERER, null, context)).map(fqcn -> {
            try {
                return (ClassOrderer)Class.forName(fqcn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Failed to instantiate " + fqcn, e);
            }
        }).orElseGet(ClassOrderer.ClassName::new);
    }

    private boolean hasRestrictedResource(ClassDescriptor classDescriptor) {
        return classDescriptor.findRepeatableAnnotations(WithTestResource.class).stream().anyMatch(res -> res.scope() == TestResourceScope.RESTRICTED_TO_CLASS || this.isMetaTestResource((WithTestResource)res, classDescriptor)) || classDescriptor.findRepeatableAnnotations(QuarkusTestResource.class).stream().anyMatch(res -> res.restrictToAnnotatedClass() || this.isMetaTestResource((QuarkusTestResource)res, classDescriptor));
    }

    @Deprecated(forRemoval=true)
    private boolean isMetaTestResource(QuarkusTestResource resource, ClassDescriptor classDescriptor) {
        return Arrays.stream((QuarkusTestResource[])classDescriptor.getTestClass().getAnnotationsByType(QuarkusTestResource.class)).map(QuarkusTestResource::value).noneMatch(resource.value()::equals);
    }

    private boolean isMetaTestResource(WithTestResource resource, ClassDescriptor classDescriptor) {
        return Arrays.stream((WithTestResource[])classDescriptor.getTestClass().getAnnotationsByType(WithTestResource.class)).map(WithTestResource::value).noneMatch(resource.value()::equals);
    }

    @Deprecated(forRemoval=true, since="2.7.0.CR1")
    protected Optional<String> getCustomOrderKey(ClassDescriptor classDescriptor, ClassOrdererContext context) {
        return Optional.empty();
    }

    protected Optional<String> getCustomOrderKey(ClassDescriptor classDescriptor, ClassOrdererContext context, String secondaryOrderSuffix) {
        return Optional.empty();
    }
}

