/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.launcher;

import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DefaultJarLauncher;
import io.quarkus.test.common.JarArtifactLauncher;
import io.quarkus.test.junit.ArtifactTypeUtil;
import io.quarkus.test.junit.launcher.ArtifactLauncherProvider;
import io.quarkus.test.junit.launcher.DefaultInitContextBase;
import io.smallrye.config.SmallRyeConfig;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.ConfigProvider;

public class JarLauncherProvider
implements ArtifactLauncherProvider {
    @Override
    public boolean supportsArtifactType(String type, String testProfile) {
        return ArtifactTypeUtil.isJar(type);
    }

    public JarArtifactLauncher create(ArtifactLauncherProvider.CreateContext context) {
        String pathStr = context.quarkusArtifactProperties().getProperty("path");
        if (pathStr != null && !pathStr.isEmpty()) {
            ServiceLoader<JarArtifactLauncher> loader = ServiceLoader.load(JarArtifactLauncher.class);
            Iterator<JarArtifactLauncher> iterator = loader.iterator();
            Object launcher = iterator.hasNext() ? iterator.next() : new DefaultJarLauncher();
            SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
            TestConfig testConfig = (TestConfig)config.getConfigMapping(TestConfig.class);
            launcher.init((ArtifactLauncher.InitContext)new DefaultJarInitContext(((OptionalInt)config.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081), ((OptionalInt)config.getValue("quarkus.http.test-ssl-port", OptionalInt.class)).orElse(8444), testConfig.waitTime(), testConfig.integrationTestProfile(), testConfig.argLine().orElse(List.of()), testConfig.env(), context.devServicesLaunchResult(), context.buildOutputDirectory().resolve(pathStr)));
            return launcher;
        }
        throw new IllegalStateException("The path of the native binary could not be determined");
    }

    static class DefaultJarInitContext
    extends DefaultInitContextBase
    implements JarArtifactLauncher.JarInitContext {
        private final Path jarPath;

        DefaultJarInitContext(int httpPort, int httpsPort, Duration waitTime, String testProfile, List<String> argLine, Map<String, String> env, ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult, Path jarPath) {
            super(httpPort, httpsPort, waitTime, testProfile, argLine, env, devServicesLaunchResult);
            this.jarPath = jarPath;
        }

        public Path jarPath() {
            return this.jarPath;
        }
    }
}

