/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.logging.Log;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.RestorableSystemProperties;
import io.quarkus.test.junit.AbstractQuarkusTestWithContextExtension;
import io.quarkus.test.junit.QuarkusTestExtensionState;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestBuildChainFunction;
import io.quarkus.test.junit.TestProfile;
import io.smallrye.config.SmallRyeConfig;
import jakarta.enterprise.inject.Alternative;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class AbstractJvmQuarkusTestExtension
extends AbstractQuarkusTestWithContextExtension
implements ExecutionCondition {
    protected static final String TEST_LOCATION = "test-location";
    protected static final String TEST_CLASS = "test-class";
    protected static final String TEST_PROFILE = "test-profile";
    protected ClassLoader originalCl;
    protected static RunningQuarkusApplication runningQuarkusApplication;
    protected static Class<? extends QuarkusTestProfile> quarkusTestProfile;
    protected static final Deque<Class<?>> currentTestClassStack;
    protected static Class<?> currentJUnitTestClass;

    protected PrepareResult createAugmentor(ExtensionContext context, Class<? extends QuarkusTestProfile> profile, Collection<Runnable> shutdownTasks) throws Exception {
        this.originalCl = Thread.currentThread().getContextClassLoader();
        Class requiredTestClass = context.getRequiredTestClass();
        CuratedApplication curatedApplication = this.getCuratedApplication(requiredTestClass, context, shutdownTasks);
        Path testClassLocation = PathTestHelper.getTestClassesLocation((Class)requiredTestClass, (CuratedApplication)curatedApplication);
        Timing.staticInitStarted((ClassLoader)curatedApplication.getOrCreateBaseRuntimeClassLoader(), (boolean)curatedApplication.getQuarkusBootstrap().isAuxiliaryApplication());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(TEST_LOCATION, testClassLocation);
        props.put(TEST_CLASS, requiredTestClass);
        System.clearProperty("test.url");
        HashMap<String, String> additional = new HashMap<String, String>();
        QuarkusTestProfile profileInstance = AbstractJvmQuarkusTestExtension.getQuarkusTestProfile(profile, shutdownTasks, additional);
        if (profile != null) {
            props.put(TEST_PROFILE, profile.getName());
        }
        quarkusTestProfile = profile;
        return new PrepareResult(curatedApplication.createAugmentor(TestBuildChainFunction.class.getName(), props), profileInstance, curatedApplication, testClassLocation);
    }

    protected CuratedApplication getCuratedApplication(Class<?> requiredTestClass, ExtensionContext context, Collection<Runnable> shutdownTasks) throws BootstrapException, AppModelResolverException, IOException {
        CuratedApplication curatedApplication = ((QuarkusClassLoader)requiredTestClass.getClassLoader()).getCuratedApplication();
        return curatedApplication;
    }

    protected static QuarkusTestProfile getQuarkusTestProfile(Class<? extends QuarkusTestProfile> profile, Collection<Runnable> shutdownTasks, Map<String, String> additional) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        QuarkusTestProfile profileInstance = null;
        if (profile != null) {
            profileInstance = profile.getConstructor(new Class[0]).newInstance(new Object[0]);
            additional.putAll(profileInstance.getConfigOverrides());
            if (!profileInstance.getEnabledAlternatives().isEmpty()) {
                additional.put("quarkus.arc.selected-alternatives", profileInstance.getEnabledAlternatives().stream().peek(c -> {
                    if (!c.isAnnotationPresent(Alternative.class)) {
                        throw new RuntimeException("Enabled alternative " + String.valueOf(c) + " is not annotated with @Alternative");
                    }
                }).map(Class::getName).collect(Collectors.joining(",")));
            }
            if (profileInstance.disableApplicationLifecycleObservers()) {
                additional.put("quarkus.arc.test.disable-application-lifecycle-observers", "true");
            }
            if (profileInstance.getConfigProfile() != null) {
                additional.put(LaunchMode.TEST.getProfileKey(), profileInstance.getConfigProfile());
            }
            shutdownTasks.add(() -> ((RestorableSystemProperties)RestorableSystemProperties.setProperties(additional, (String[])new String[0])).close());
        }
        return profileInstance;
    }

    public static Class<? extends QuarkusTestProfile> getQuarkusTestProfile(Class testClass, ExtensionContext extensionContext) {
        Class<? extends QuarkusTestProfile> testProfile = AbstractJvmQuarkusTestExtension.findTestProfileAnnotation(testClass);
        if (testProfile != null) {
            return testProfile;
        }
        if (testClass.isAnnotationPresent(Nested.class)) {
            ExtensionContext currentExtensionContext;
            testProfile = AbstractJvmQuarkusTestExtension.findTestProfileAnnotation(testClass.getEnclosingClass());
            if (testProfile != null) {
                return testProfile;
            }
            Optional parentContext = extensionContext.getParent();
            while (parentContext.isPresent() && !(currentExtensionContext = (ExtensionContext)parentContext.get()).getTestClass().isEmpty()) {
                testProfile = AbstractJvmQuarkusTestExtension.findTestProfileAnnotation((Class)currentExtensionContext.getTestClass().get());
                if (testProfile != null) {
                    return testProfile;
                }
                parentContext = currentExtensionContext.getParent();
            }
        }
        return null;
    }

    protected Class<? extends QuarkusTestProfile> getQuarkusTestProfile(ExtensionContext extensionContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        Class<? extends QuarkusTestProfile> testProfile = AbstractJvmQuarkusTestExtension.getQuarkusTestProfile(testClass, extensionContext);
        if (testProfile != null) {
            return testProfile;
        }
        if (testClass.isAnnotationPresent(Nested.class)) {
            ExtensionContext currentExtensionContext;
            Optional parentContext = extensionContext.getParent();
            while (parentContext.isPresent() && !(currentExtensionContext = (ExtensionContext)parentContext.get()).getTestClass().isEmpty()) {
                testProfile = AbstractJvmQuarkusTestExtension.findTestProfileAnnotation((Class)currentExtensionContext.getTestClass().get());
                if (testProfile != null) {
                    return testProfile;
                }
                parentContext = currentExtensionContext.getParent();
            }
        }
        return null;
    }

    private static Class<? extends QuarkusTestProfile> findTestProfileAnnotation(Class<?> clazz) {
        for (Class<?> testClass = clazz; testClass != null; testClass = testClass.getEnclosingClass()) {
            TestProfile annotation = testClass.getAnnotation(TestProfile.class);
            if (annotation == null) continue;
            return annotation.value();
        }
        return null;
    }

    protected boolean isNewApplication(QuarkusTestExtensionState state, Class<?> currentJUnitTestClass) {
        return runningQuarkusApplication == null || runningQuarkusApplication.getClassLoader() != currentJUnitTestClass.getClassLoader();
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        QuarkusTestProfile profileInstance;
        TestConfig testConfig;
        if (!context.getTestClass().isPresent()) {
            return ConditionEvaluationResult.enabled((String)"No test class specified");
        }
        if (context.getTestInstance().isPresent()) {
            return ConditionEvaluationResult.enabled((String)"Quarkus Test Profile tags only affect classes");
        }
        boolean isRunningOnSystem = this.getClass().getClassLoader() == ClassLoader.getSystemClassLoader();
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        if (!isRunningOnSystem) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        try {
            testConfig = (TestConfig)((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).getConfigMapping(TestConfig.class);
        }
        catch (Exception | ServiceConfigurationError e) {
            Log.error((Object)("Could not read configuration while evaluating whether to run " + String.valueOf(context.getRequiredTestClass()) + ". This usually happens when re-running a test that has already failed, for example if surefire.rerunFailingTestsCount is set. To work around this limitation, either adjust the test so that it passes, or isolate the test into a project whose tests all use the same combination of @TestProfile and resources."));
            Log.debug((Object)("Underlying exception: " + String.valueOf(e)));
            Log.debug((Object)("Thread Context Classloader: " + String.valueOf(Thread.currentThread().getContextClassLoader())));
            Log.debug((Object)("The class of the class we use for mapping is " + String.valueOf(TestConfig.class.getClassLoader())));
            throw new IllegalStateException("Non-viable test classloader, " + String.valueOf(Thread.currentThread().getContextClassLoader()) + ". Is this a re-run of a failing test?");
        }
        finally {
            if (!isRunningOnSystem) {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        Optional tags = testConfig.profile().tags();
        if (tags.isEmpty() || ((List)tags.get()).isEmpty()) {
            return ConditionEvaluationResult.enabled((String)"No Quarkus Test Profile tags");
        }
        Class<? extends QuarkusTestProfile> testProfile = this.getQuarkusTestProfile(context);
        if (testProfile == null) {
            return ConditionEvaluationResult.disabled((String)("Test '" + String.valueOf(context.getRequiredTestClass()) + "' is not annotated with '@QuarkusTestProfile' but 'quarkus.profile.test.tags' was set"));
        }
        try {
            profileInstance = testProfile.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set<String> testProfileTags = profileInstance.tags();
        for (String tag : (List)tags.get()) {
            String trimmedTag = tag.trim();
            if (!testProfileTags.contains(trimmedTag)) continue;
            return ConditionEvaluationResult.enabled((String)("Tag '" + trimmedTag + "' is present on '" + String.valueOf(testProfile) + "' which is used on test '" + String.valueOf(context.getRequiredTestClass())));
        }
        return ConditionEvaluationResult.disabled((String)("Test '" + String.valueOf(context.getRequiredTestClass()) + "' disabled because 'quarkus.profile.test.tags' don't match the tags of '" + String.valueOf(testProfile) + "'"));
    }

    static {
        currentTestClassStack = new ArrayDeque();
    }

    protected static class PrepareResult {
        protected final AugmentAction augmentAction;
        protected final QuarkusTestProfile profileInstance;
        protected final CuratedApplication curatedApplication;
        protected final Path testClassLocation;

        public PrepareResult(AugmentAction augmentAction, QuarkusTestProfile profileInstance, CuratedApplication curatedApplication, Path testClassLocation) {
            this.augmentAction = augmentAction;
            this.profileInstance = profileInstance;
            this.curatedApplication = curatedApplication;
            this.testClassLocation = testClassLocation;
        }
    }
}

