/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.bootstrap.logging.QuarkusDelayedHandler;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.deployment.dev.testing.CurrentTestApplication;
import io.quarkus.deployment.dev.testing.LogCapturingOutputFilter;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.testing.TracingHandler;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.logging.JBossVersion;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.junit.AbstractJvmQuarkusTestExtension;
import io.quarkus.test.junit.AppMakerHelper;
import io.quarkus.test.junit.IntegrationTestUtil;
import io.quarkus.test.junit.QuarkusTestExtensionState;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestResourceUtil;
import io.quarkus.test.junit.main.Launch;
import io.quarkus.test.junit.main.LaunchResult;
import io.quarkus.test.junit.main.QuarkusMainIntegrationTest;
import io.quarkus.test.junit.main.QuarkusMainLauncher;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.logging.Handler;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.logmanager.handlers.OutputStreamHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

public class QuarkusMainTestExtension
extends AbstractJvmQuarkusTestExtension
implements InvocationInterceptor,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver,
BeforeAllCallback,
AfterAllCallback,
ExecutionCondition {
    AbstractJvmQuarkusTestExtension.PrepareResult prepareResult;
    LinkedBlockingDeque<Runnable> shutdownTasks;
    LaunchResult result;
    private static Handler ORIGINAL_QUARKUS_CONSOLE_HANDLER = null;
    private static Handler REDIRECT_QUARKUS_CONSOLE_HANDLER = null;

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.isIntegrationTest(context.getRequiredTestClass())) {
            return;
        }
        Class<? extends QuarkusTestProfile> profile = this.getQuarkusTestProfile(context);
        this.ensurePrepared(context, profile);
    }

    private void ensurePrepared(ExtensionContext extensionContext, Class<? extends QuarkusTestProfile> profile) throws Exception {
        boolean isNewTestClass;
        JBossVersion.disableVersionLogging();
        QuarkusTestExtensionState state = this.getState(extensionContext);
        boolean wrongProfile = !Objects.equals(profile, quarkusTestProfile);
        boolean bl = isNewTestClass = !Objects.equals(extensionContext.getRequiredTestClass(), currentJUnitTestClass);
        if (wrongProfile || isNewTestClass && TestResourceUtil.testResourcesRequireReload(state, extensionContext.getRequiredTestClass(), profile)) {
            if (state != null) {
                try {
                    state.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            this.prepareResult = null;
        }
        if (isNewTestClass && extensionContext.getRequiredTestClass().isAnnotationPresent(Nested.class)) {
            this.prepareResult = null;
        }
        if (this.prepareResult == null) {
            this.shutdownTasks = new LinkedBlockingDeque();
            this.prepareResult = this.createAugmentor(extensionContext, profile, this.shutdownTasks);
        }
    }

    @Override
    protected CuratedApplication getCuratedApplication(Class<?> requiredTestClass, ExtensionContext context, Collection<Runnable> shutdownTasks) throws BootstrapException, AppModelResolverException, IOException {
        CuratedApplication curatedApplication;
        if (CurrentTestApplication.curatedApplication != null) {
            curatedApplication = CurrentTestApplication.curatedApplication;
        } else {
            Path testClassLocation;
            Path projectRoot = Paths.get("", new String[0]).normalize().toAbsolutePath();
            PathList.Builder rootBuilder = PathList.builder();
            Consumer<Path> addToBuilderIfConditionMet = path -> {
                if (path != null && Files.exists(path, new LinkOption[0]) && !rootBuilder.contains(path)) {
                    rootBuilder.add(path);
                }
            };
            ApplicationModel gradleAppModel = AppMakerHelper.getGradleAppModelForIDE(projectRoot);
            if (gradleAppModel != null && gradleAppModel.getApplicationModule() != null) {
                WorkspaceModule module = gradleAppModel.getApplicationModule();
                String testClassFileName = ClassLoaderHelper.fromClassNameToResourceName((String)requiredTestClass.getName());
                Path testClassesDir = null;
                for (String classifier : module.getSourceClassifiers()) {
                    ArtifactSources sources = module.getSources(classifier);
                    if (!sources.isOutputAvailable() || !sources.getOutputTree().contains(testClassFileName)) continue;
                    for (SourceDir src : sources.getSourceDirs()) {
                        addToBuilderIfConditionMet.accept(src.getOutputDir());
                        if (!Files.exists(src.getOutputDir().resolve(testClassFileName), new LinkOption[0])) continue;
                        testClassesDir = src.getOutputDir();
                    }
                    for (SourceDir src : sources.getResourceDirs()) {
                        addToBuilderIfConditionMet.accept(src.getOutputDir());
                    }
                    for (SourceDir src : module.getMainSources().getSourceDirs()) {
                        addToBuilderIfConditionMet.accept(src.getOutputDir());
                    }
                    for (SourceDir src : module.getMainSources().getResourceDirs()) {
                        addToBuilderIfConditionMet.accept(src.getOutputDir());
                    }
                }
                PathTestHelper.validateTestDir(requiredTestClass, testClassesDir, (WorkspaceModule)module);
                testClassLocation = testClassesDir;
            } else {
                Path appClassLocation;
                if (System.getProperty("OUTPUT_SOURCES_DIR") != null) {
                    String[] sourceDirectories;
                    for (String sourceDirectory : sourceDirectories = System.getProperty("OUTPUT_SOURCES_DIR").split(",")) {
                        Path directory = Paths.get(sourceDirectory, new String[0]);
                        addToBuilderIfConditionMet.accept(directory);
                    }
                }
                if (!(appClassLocation = PathTestHelper.getAppClassLocationForTestLocation((Path)(testClassLocation = PathTestHelper.getTestClassesLocation(requiredTestClass)))).equals(testClassLocation)) {
                    addToBuilderIfConditionMet.accept(testClassLocation);
                    Path testResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)testClassLocation, (String)"test");
                    addToBuilderIfConditionMet.accept(testResourcesLocation);
                }
                addToBuilderIfConditionMet.accept(appClassLocation);
                Path appResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)appClassLocation, (String)"main");
                addToBuilderIfConditionMet.accept(appResourcesLocation);
            }
            curatedApplication = QuarkusBootstrap.builder().setBaseName(context.getDisplayName() + " (QuarkusTest)").setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.TEST).setTest(true).setTargetDirectory(PathTestHelper.getProjectBuildDir((Path)projectRoot, (Path)testClassLocation)).setProjectRoot(projectRoot).setApplicationRoot((PathCollection)rootBuilder.build()).build().bootstrap();
            shutdownTasks.add(() -> ((CuratedApplication)curatedApplication).close());
        }
        if (curatedApplication.getApplicationModel().getRuntimeDependencies().isEmpty()) {
            throw new RuntimeException("The tests were run against a directory that does not contain a Quarkus project. Please ensure that the test is configured to use the proper working directory.");
        }
        return curatedApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LaunchResult doLaunch(ExtensionContext context, Class<? extends QuarkusTestProfile> selectedProfile, String[] arguments) throws Exception {
        this.ensurePrepared(context, selectedProfile);
        LogCapturingOutputFilter filter = new LogCapturingOutputFilter(this.prepareResult.curatedApplication, false, false, () -> true);
        QuarkusConsole.addOutputFilter((BiPredicate)filter);
        try {
            final int result = this.doJavaStart(context, selectedProfile, arguments);
            final List<String> out = Arrays.asList(String.join((CharSequence)"", filter.captureOutput()).replaceAll("\\u001B\\[(.*?)[a-zA-Z]", "").split("\n"));
            final List<String> err = Arrays.asList(String.join((CharSequence)"", filter.captureErrorOutput()).replaceAll("\\u001B\\[(.*?)[a-zA-Z]", "").split("\n"));
            LaunchResult launchResult = new LaunchResult(){

                @Override
                public List<String> getOutputStream() {
                    return out;
                }

                @Override
                public List<String> getErrorStream() {
                    return err;
                }

                @Override
                public int exitCode() {
                    return result;
                }
            };
            return launchResult;
        }
        finally {
            QuarkusConsole.removeOutputFilter((BiPredicate)filter);
            Thread.currentThread().setContextClassLoader(this.originalCl);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.result = null;
    }

    private static void installLoggerRedirect() throws Exception {
        Logger rootLogger = LogContext.getLogContext().getLogger("");
        ORIGINAL_QUARKUS_CONSOLE_HANDLER = null;
        REDIRECT_QUARKUS_CONSOLE_HANDLER = null;
        block0: for (Handler topLevelHandler : rootLogger.getHandlers()) {
            if (!(topLevelHandler instanceof QuarkusDelayedHandler)) continue;
            ORIGINAL_QUARKUS_CONSOLE_HANDLER = topLevelHandler;
            for (Handler h : ((QuarkusDelayedHandler)topLevelHandler).getHandlers()) {
                if (!(h instanceof ConsoleHandler)) continue;
                REDIRECT_QUARKUS_CONSOLE_HANDLER = new OutputStreamHandler((OutputStream)QuarkusConsole.REDIRECT_OUT, h.getFormatter());
                break block0;
            }
            break;
        }
        if (REDIRECT_QUARKUS_CONSOLE_HANDLER != null) {
            rootLogger.removeHandler(ORIGINAL_QUARKUS_CONSOLE_HANDLER);
            rootLogger.addHandler(REDIRECT_QUARKUS_CONSOLE_HANDLER);
        }
    }

    private static void uninstallLoggerRedirect() throws Exception {
        Logger rootLogger = LogContext.getLogContext().getLogger("");
        if (REDIRECT_QUARKUS_CONSOLE_HANDLER != null) {
            rootLogger.addHandler(ORIGINAL_QUARKUS_CONSOLE_HANDLER);
            rootLogger.removeHandler(REDIRECT_QUARKUS_CONSOLE_HANDLER);
        }
    }

    private void flushAllLoggers() {
        Enumeration loggerNames = LogContext.getLogContext().getLoggerNames();
        while (loggerNames != null && loggerNames.hasMoreElements()) {
            String loggerName = (String)loggerNames.nextElement();
            Logger logger = LogContext.getLogContext().getLogger(loggerName);
            for (Handler h : logger.getHandlers()) {
                h.flush();
            }
        }
    }

    private int doJavaStart(ExtensionContext context, Class<? extends QuarkusTestProfile> profile, String[] arguments) throws Exception {
        JBossVersion.disableVersionLogging();
        TracingHandler.quarkusStarting();
        Closeable testResourceManager = null;
        try {
            StartupAction startupAction = this.prepareResult.augmentAction.createInitialRuntimeApplication();
            Thread.currentThread().setContextClassLoader((ClassLoader)startupAction.getClassLoader());
            QuarkusConsole.installRedirects();
            this.flushAllLoggers();
            QuarkusMainTestExtension.installLoggerRedirect();
            QuarkusTestProfile profileInstance = this.prepareResult.profileInstance;
            Class testResourceManagerClass = startupAction.getClassLoader().loadClass(TestResourceManager.class.getName());
            testResourceManager = TestResourceUtil.TestResourceManagerReflections.createReflectively(testResourceManagerClass, context.getRequiredTestClass(), profile, TestResourceUtil.TestResourceManagerReflections.copyEntriesFromProfile(profileInstance, (ClassLoader)startupAction.getClassLoader()), profileInstance != null && profileInstance.disableGlobalTestResources(), startupAction.getDevServicesProperties(), Optional.ofNullable(startupAction.getDevServicesNetworkId()));
            TestResourceUtil.TestResourceManagerReflections.initReflectively(testResourceManager, profile);
            Map<String, String> properties = TestResourceUtil.TestResourceManagerReflections.startReflectively(testResourceManager);
            startupAction.overrideConfig(properties);
            testResourceManager.getClass().getMethod("inject", Object.class).invoke((Object)testResourceManager, context.getRequiredTestInstance());
            int result = startupAction.runMainClassBlocking(arguments);
            this.flushAllLoggers();
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (!InitialConfigurator.DELAYED_HANDLER.isActivated()) {
                IntegrationTestUtil.activateLogging();
            }
            throw e;
        }
        finally {
            try {
                if (testResourceManager != null) {
                    testResourceManager.close();
                }
            }
            catch (Exception e) {
                System.err.println("Unable to shutdown resource: " + e.getMessage());
            }
            QuarkusMainTestExtension.uninstallLoggerRedirect();
            QuarkusConsole.uninstallRedirects();
            if (this.originalCl != null) {
                Thread.currentThread().setContextClassLoader(this.originalCl);
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.isIntegrationTest(extensionContext.getRequiredTestClass())) {
            return false;
        }
        Class<?> type = parameterContext.getParameter().getType();
        return type == LaunchResult.class || type == QuarkusMainLauncher.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, final ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        final Class<? extends QuarkusTestProfile> profile = this.getQuarkusTestProfile(extensionContext);
        if (type == LaunchResult.class) {
            Launch launch = extensionContext.getRequiredTestMethod().getAnnotation(Launch.class);
            if (launch == null) {
                throw new RuntimeException("To use 'LaunchResult' as a method parameter, the test must be annotated with '@Launch'");
            }
            this.doLaunchAndAssertExitCode(extensionContext, profile, launch);
            return this.result;
        }
        if (type == QuarkusMainLauncher.class) {
            return new QuarkusMainLauncher(){

                @Override
                public LaunchResult launch(String ... args) {
                    try {
                        return QuarkusMainTestExtension.this.doLaunch(extensionContext, profile, args);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        throw new RuntimeException("Parameter type not supported");
    }

    private void doLaunchAndAssertExitCode(ExtensionContext extensionContext, Class<? extends QuarkusTestProfile> profile, Launch launch) {
        LaunchResult r;
        String[] arguments = launch.value();
        try {
            r = this.doLaunch(extensionContext, profile, arguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Assertions.assertEquals((int)launch.exitCode(), (int)r.exitCode(), (String)("Exit code did not match, output: " + r.getOutput() + " " + r.getErrorOutput()));
        this.result = r;
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        Launch launch;
        Class<? extends QuarkusTestProfile> profile = this.getQuarkusTestProfile(extensionContext);
        if (invocationContext.getArguments().isEmpty() && (launch = extensionContext.getRequiredTestMethod().getAnnotation(Launch.class)) != null) {
            this.doLaunchAndAssertExitCode(extensionContext, profile, launch);
        }
        invocation.proceed();
    }

    private boolean isIntegrationTest(Class<?> clazz) {
        for (Class i : currentTestClassStack) {
            if (!i.isAnnotationPresent(QuarkusMainIntegrationTest.class)) continue;
            return true;
        }
        return clazz.isAnnotationPresent(QuarkusMainIntegrationTest.class);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        currentTestClassStack.pop();
        try {
            if (this.shutdownTasks != null) {
                for (Runnable shutdownTask : this.shutdownTasks) {
                    shutdownTask.run();
                }
            }
            this.shutdownTasks = null;
        }
        catch (Exception e) {
            System.err.println("Unable to run shutdown tasks: " + e.getMessage());
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        currentTestClassStack.push(context.getRequiredTestClass());
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return super.evaluateExecutionCondition(context);
    }
}

