/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.launcher;

import io.quarkus.test.junit.classloading.FacadeClassLoader;
import org.junit.platform.launcher.LauncherInterceptor;

public class CustomLauncherInterceptor
implements LauncherInterceptor {
    private FacadeClassLoader facadeLoader = null;
    private ClassLoader origCl = null;

    public <T> T intercept(LauncherInterceptor.Invocation<T> invocation) {
        if (System.getProperty("prod.mode.tests") != null) {
            return (T)invocation.proceed();
        }
        return this.actuallyIntercept(invocation);
    }

    private <T> T actuallyIntercept(LauncherInterceptor.Invocation<T> invocation) {
        ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
        if (currentCl == null || currentCl != this.facadeLoader && !currentCl.getClass().getName().equals(FacadeClassLoader.class.getName())) {
            this.origCl = currentCl;
            if (this.facadeLoader == null) {
                this.facadeLoader = new FacadeClassLoader(currentCl);
            }
            Thread.currentThread().setContextClassLoader(this.facadeLoader);
            return (T)invocation.proceed();
        }
        return (T)invocation.proceed();
    }

    public void close() {
        try {
            if (this.facadeLoader != null) {
                if (Thread.currentThread().getContextClassLoader() == this.facadeLoader) {
                    Thread.currentThread().setContextClassLoader(this.origCl);
                }
                this.facadeLoader.close();
                this.facadeLoader = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close custom classloader", e);
        }
    }
}

