/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.TestAnnotationBuildItem;
import io.quarkus.deployment.builditem.TestClassBeanBuildItem;
import io.quarkus.deployment.builditem.TestClassPredicateBuildItem;
import io.quarkus.dev.testing.ExceptionReporting;
import io.quarkus.dev.testing.TracingHandler;
import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.DurationConverter;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.runtime.logging.JBossVersion;
import io.quarkus.runtime.test.TestHttpEndpointProvider;
import io.quarkus.test.TestMethodInvoker;
import io.quarkus.test.common.GroovyClassValue;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.RestorableSystemProperties;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestScopeManager;
import io.quarkus.test.common.http.TestHTTPEndpoint;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit.AbstractJvmQuarkusTestExtension;
import io.quarkus.test.junit.DotNames;
import io.quarkus.test.junit.IntegrationTestUtil;
import io.quarkus.test.junit.MockSupport;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.QuarkusTestExtensionState;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.RunningAppConfigResolver;
import io.quarkus.test.junit.TestInfoImpl;
import io.quarkus.test.junit.buildchain.TestBuildChainCustomizerProducer;
import io.quarkus.test.junit.callback.QuarkusTestContext;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import io.quarkus.test.junit.internal.DeepClone;
import io.quarkus.test.junit.internal.SerializationWithXStreamFallbackDeepClone;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.opentest4j.TestAbortedException;

public class QuarkusTestExtension
extends AbstractJvmQuarkusTestExtension
implements BeforeEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
AfterEachCallback,
BeforeAllCallback,
InvocationInterceptor,
AfterAllCallback,
ParameterResolver,
ExecutionCondition {
    private static final Logger log = Logger.getLogger(QuarkusTestExtension.class);
    public static final String QUARKUS_TEST_HANG_DETECTION_TIMEOUT = "quarkus.test.hang-detection-timeout";
    private static boolean failedBoot;
    private static Class<?> actualTestClass;
    private static Object actualTestInstance;
    private static Deque<Object> outerInstances;
    private static RunningQuarkusApplication runningQuarkusApplication;
    private static Pattern clonePattern;
    private static Throwable firstException;
    private static Class<?> quarkusTestMethodContextClass;
    private static boolean hasPerTestResources;
    private static List<Function<Class<?>, String>> testHttpEndpointProviders;
    private static List<Object> testMethodInvokers;
    private static DeepClone deepClone;
    private static volatile ScheduledExecutorService hangDetectionExecutor;
    private static volatile Duration hangTimeout;
    private static volatile ScheduledFuture<?> hangTaskKey;
    private static final Runnable hangDetectionTask;

    private ExtensionState doJavaStart(ExtensionContext context, Class<? extends QuarkusTestProfile> profile) throws Throwable {
        JBossVersion.disableVersionLogging();
        TracingHandler.quarkusStarting();
        hangDetectionExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Quarkus hang detection timer thread");
            }
        });
        String time = "10m";
        String sysPropString = System.getProperty(QUARKUS_TEST_HANG_DETECTION_TIMEOUT);
        if (sysPropString != null) {
            time = sysPropString;
        }
        hangTimeout = new DurationConverter().convert(time);
        hangTaskKey = hangDetectionExecutor.schedule(hangDetectionTask, hangTimeout.toMillis(), TimeUnit.MILLISECONDS);
        quarkusTestProfile = profile;
        final Class requiredTestClass = context.getRequiredTestClass();
        Closeable testResourceManager = null;
        try {
            ExtensionState state;
            final LinkedBlockingDeque<Runnable> shutdownTasks = new LinkedBlockingDeque<Runnable>();
            AbstractJvmQuarkusTestExtension.PrepareResult result = this.createAugmentor(context, profile, shutdownTasks);
            AugmentAction augmentAction = result.augmentAction;
            QuarkusTestProfile profileInstance = result.profileInstance;
            testHttpEndpointProviders = TestHttpEndpointProvider.load();
            StartupAction startupAction = augmentAction.createInitialRuntimeApplication();
            Thread.currentThread().setContextClassLoader(startupAction.getClassLoader());
            this.populateDeepCloneField(startupAction);
            testResourceManager = (Closeable)startupAction.getClassLoader().loadClass(TestResourceManager.class.getName()).getConstructor(Class.class, Class.class, List.class, Boolean.TYPE, Map.class, Optional.class, Path.class).newInstance(requiredTestClass, profile != null ? profile : null, IntegrationTestUtil.getAdditionalTestResources(profileInstance, startupAction.getClassLoader()), profileInstance != null && profileInstance.disableGlobalTestResources(), startupAction.getDevServicesProperties(), Optional.empty(), result.testClassLocation);
            testResourceManager.getClass().getMethod("init", String.class).invoke((Object)testResourceManager, profile != null ? profile.getName() : null);
            Map properties = (Map)testResourceManager.getClass().getMethod("start", new Class[0]).invoke((Object)testResourceManager, new Object[0]);
            startupAction.overrideConfig(properties);
            hasPerTestResources = (Boolean)testResourceManager.getClass().getMethod("hasPerTestResources", new Class[0]).invoke((Object)testResourceManager, new Object[0]);
            quarkusTestMethodContextClass = null;
            this.populateCallbacks(startupAction.getClassLoader());
            this.populateTestMethodInvokers(startupAction.getClassLoader());
            if (profileInstance == null || !profileInstance.runMainMethod()) {
                runningQuarkusApplication = startupAction.run(profileInstance == null ? new String[]{} : profileInstance.commandLineParameters());
            } else {
                Class<?> lifecycleManager = Class.forName(ApplicationLifecycleManager.class.getName(), true, startupAction.getClassLoader());
                lifecycleManager.getDeclaredMethod("setDefaultExitCodeHandler", Consumer.class).invoke(null, integer -> {});
                runningQuarkusApplication = startupAction.runMainClass(profileInstance.commandLineParameters());
            }
            String patternString = runningQuarkusApplication.getConfigValue("quarkus.test.class-clone-pattern", String.class).orElse("java\\..*");
            clonePattern = Pattern.compile(patternString);
            TracingHandler.quarkusStarted();
            if (hangTaskKey != null) {
                hangTaskKey.cancel(false);
                hangTimeout = runningQuarkusApplication.getConfigValue(QUARKUS_TEST_HANG_DETECTION_TIMEOUT, Duration.class).orElse(Duration.of(10L, ChronoUnit.MINUTES));
                hangTaskKey = hangDetectionExecutor.schedule(hangDetectionTask, hangTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            ConfigProviderResolver.setInstance((ConfigProviderResolver)new RunningAppConfigResolver(runningQuarkusApplication));
            final RestorableSystemProperties restorableSystemProperties = RestorableSystemProperties.setProperties(Collections.singletonMap("test.url", TestHTTPResourceManager.getUri((RunningQuarkusApplication)runningQuarkusApplication)), (String[])new String[0]);
            final Closeable tm = testResourceManager;
            Closeable shutdownTask = new Closeable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    TracingHandler.quarkusStopping();
                    try {
                        runningQuarkusApplication.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        TracingHandler.quarkusStopped();
                        try {
                            while (!shutdownTasks.isEmpty()) {
                                ((Runnable)shutdownTasks.pop()).run();
                            }
                        }
                        finally {
                            try {
                                tm.close();
                            }
                            finally {
                                restorableSystemProperties.close();
                                QuarkusTestExtension.this.shutdownHangDetection();
                            }
                        }
                        try {
                            TestClassIndexer.removeIndex((Class)requiredTestClass);
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            ExtensionState extensionState = state = new ExtensionState(testResourceManager, shutdownTask);
            return extensionState;
        }
        catch (Throwable e) {
            if (!InitialConfigurator.DELAYED_HANDLER.isActivated()) {
                IntegrationTestUtil.activateLogging();
            }
            Throwable effectiveException = this.determineEffectiveException(e);
            try {
                if (testResourceManager != null) {
                    testResourceManager.close();
                }
            }
            catch (Exception ex) {
                effectiveException.addSuppressed(this.determineEffectiveException(ex));
            }
            throw effectiveException;
        }
        finally {
            if (this.originalCl != null) {
                Thread.currentThread().setContextClassLoader(this.originalCl);
            }
        }
    }

    private Throwable determineEffectiveException(Throwable e) {
        Throwable effectiveException = e;
        if (e instanceof InvocationTargetException && e.getCause() != null && (effectiveException = e.getCause()) instanceof CompletionException && effectiveException.getCause() != null) {
            effectiveException = effectiveException.getCause();
        }
        return effectiveException;
    }

    private void shutdownHangDetection() {
        ScheduledExecutorService h;
        if (hangTaskKey != null) {
            hangTaskKey.cancel(true);
            hangTaskKey = null;
        }
        if ((h = hangDetectionExecutor) != null) {
            h.shutdownNow();
            hangDetectionExecutor = null;
        }
    }

    private void populateDeepCloneField(StartupAction startupAction) {
        deepClone = new SerializationWithXStreamFallbackDeepClone(startupAction.getClassLoader());
    }

    private void populateTestMethodInvokers(ClassLoader quarkusClassLoader) {
        testMethodInvokers = new ArrayList<Object>();
        try {
            ServiceLoader<?> loader = ServiceLoader.load(quarkusClassLoader.loadClass(TestMethodInvoker.class.getName()), quarkusClassLoader);
            for (Object testMethodInvoker : loader) {
                testMethodInvokers.add(testMethodInvoker);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTestExecution(ExtensionContext context) throws Exception {
        if (this.isNativeOrIntegrationTest(context.getRequiredTestClass()) || this.isBeforeTestCallbacksEmpty()) {
            return;
        }
        if (!failedBoot) {
            ClassLoader original = QuarkusTestExtension.setCCL(runningQuarkusApplication.getClassLoader());
            try {
                Map.Entry<Class<?>, ?> tuple = this.createQuarkusTestMethodContextTuple(context);
                this.invokeBeforeTestExecutionCallbacks(tuple.getKey(), tuple.getValue());
            }
            finally {
                QuarkusTestExtension.setCCL(original);
            }
        } else {
            this.throwBootFailureException();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.isNativeOrIntegrationTest(context.getRequiredTestClass())) {
            return;
        }
        QuarkusTestExtension.resetHangTimeout();
        if (!failedBoot) {
            ClassLoader original = QuarkusTestExtension.setCCL(runningQuarkusApplication.getClassLoader());
            try {
                this.pushMockContext();
                Map.Entry<Class<?>, ?> tuple = this.createQuarkusTestMethodContextTuple(context);
                this.invokeBeforeEachCallbacks(tuple.getKey(), tuple.getValue());
                String endpointPath = QuarkusTestExtension.getEndpointPath(context, testHttpEndpointProviders);
                if (runningQuarkusApplication == null) return;
                boolean secure = false;
                Optional insecureAllowed = runningQuarkusApplication.getConfigValue("quarkus.http.insecure-requests", String.class);
                if (insecureAllowed.isPresent()) {
                    secure = !((String)insecureAllowed.get()).toLowerCase(Locale.ENGLISH).equals("enabled");
                }
                runningQuarkusApplication.getClassLoader().loadClass(RestAssuredURLManager.class.getName()).getDeclaredMethod("setURL", Boolean.TYPE, String.class).invoke(null, secure, endpointPath);
                runningQuarkusApplication.getClassLoader().loadClass(TestScopeManager.class.getName()).getDeclaredMethod("setup", Boolean.TYPE).invoke(null, false);
                return;
            }
            finally {
                QuarkusTestExtension.setCCL(original);
            }
        } else {
            this.throwBootFailureException();
            return;
        }
    }

    public static String getEndpointPath(ExtensionContext context, List<Function<Class<?>, String>> testHttpEndpointProviders) {
        String endpointPath = null;
        TestHTTPEndpoint testHTTPEndpoint = context.getRequiredTestMethod().getAnnotation(TestHTTPEndpoint.class);
        if (testHTTPEndpoint == null) {
            Class clazz = context.getRequiredTestClass();
            while ((testHTTPEndpoint = clazz.getAnnotation(TestHTTPEndpoint.class)) == null && (clazz = clazz.getSuperclass()) != Object.class) {
            }
        }
        if (testHTTPEndpoint != null) {
            Function<Class<?>, String> i;
            Iterator<Function<Class<?>, String>> iterator = testHttpEndpointProviders.iterator();
            while (iterator.hasNext() && (endpointPath = (i = iterator.next()).apply(testHTTPEndpoint.value())) == null) {
            }
            if (endpointPath == null) {
                throw new RuntimeException("Cannot determine HTTP path for endpoint " + testHTTPEndpoint.value() + " for test method " + context.getRequiredTestMethod());
            }
        }
        if (endpointPath != null && endpointPath.indexOf(58) != -1) {
            return QuarkusTestExtension.sanitizeEndpointPath(endpointPath);
        }
        return endpointPath;
    }

    private static String sanitizeEndpointPath(String path) {
        int openBrackets = 0;
        boolean inRegex = false;
        StringBuilder replaced = new StringBuilder(path.length() - 1);
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '{') {
                ++openBrackets;
            } else if (c == '}') {
                if (--openBrackets == 0) {
                    inRegex = false;
                }
            } else if (c == ':' && openBrackets > 0) {
                inRegex = true;
            }
            if (inRegex) continue;
            replaced.append(c);
        }
        return replaced.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTestExecution(ExtensionContext context) throws Exception {
        if (this.isNativeOrIntegrationTest(context.getRequiredTestClass()) || this.isAfterTestCallbacksEmpty()) {
            return;
        }
        if (!failedBoot) {
            ClassLoader original = QuarkusTestExtension.setCCL(runningQuarkusApplication.getClassLoader());
            try {
                Map.Entry<Class<?>, ?> tuple = this.createQuarkusTestMethodContextTuple(context);
                this.invokeAfterTestExecutionCallbacks(tuple.getKey(), tuple.getValue());
            }
            finally {
                QuarkusTestExtension.setCCL(original);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterEach(ExtensionContext context) throws Exception {
        if (this.isNativeOrIntegrationTest(context.getRequiredTestClass())) {
            return;
        }
        QuarkusTestExtension.resetHangTimeout();
        if (!failedBoot) {
            this.popMockContext();
            ClassLoader original = QuarkusTestExtension.setCCL(runningQuarkusApplication.getClassLoader());
            try {
                Map.Entry<Class<?>, ?> tuple = this.createQuarkusTestMethodContextTuple(context);
                this.invokeAfterEachCallbacks(tuple.getKey(), tuple.getValue());
                runningQuarkusApplication.getClassLoader().loadClass(RestAssuredURLManager.class.getName()).getDeclaredMethod("clearURL", new Class[0]).invoke(null, new Object[0]);
                runningQuarkusApplication.getClassLoader().loadClass(TestScopeManager.class.getName()).getDeclaredMethod("tearDown", Boolean.TYPE).invoke(null, false);
            }
            finally {
                QuarkusTestExtension.setCCL(original);
            }
        }
    }

    private Map.Entry<Class<?>, ?> createQuarkusTestMethodContextTuple(ExtensionContext context) throws Exception {
        ClassLoader classLoader = runningQuarkusApplication.getClassLoader();
        if (quarkusTestMethodContextClass == null) {
            quarkusTestMethodContextClass = Class.forName(QuarkusTestMethodContext.class.getName(), true, classLoader);
        }
        Method originalTestMethod = context.getRequiredTestMethod();
        Class<?>[] originalParameterTypes = originalTestMethod.getParameterTypes();
        Method actualTestMethod = null;
        Class<?> c = this.resolveDeclaringClass(originalTestMethod, actualTestClass);
        ArrayList parameterTypesFromTccl = new ArrayList(originalParameterTypes.length);
        for (Class<?> type : originalParameterTypes) {
            if (type.isPrimitive()) {
                parameterTypesFromTccl.add(type);
                continue;
            }
            parameterTypesFromTccl.add(Class.forName(type.getName(), true, classLoader));
        }
        Class[] parameterTypes = parameterTypesFromTccl.toArray(new Class[0]);
        try {
            if (c != null) {
                actualTestMethod = c.getDeclaredMethod(originalTestMethod.getName(), parameterTypes);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (actualTestMethod == null) {
            throw new RuntimeException("Could not find method " + originalTestMethod + " on test class");
        }
        QuarkusTestExtensionState state = this.getState(context);
        Constructor<?> constructor = quarkusTestMethodContextClass.getConstructor(Object.class, List.class, Method.class, Throwable.class);
        return new AbstractMap.SimpleEntry(quarkusTestMethodContextClass, constructor.newInstance(actualTestInstance, new ArrayList<Object>(outerInstances), actualTestMethod, state.getTestErrorCause()));
    }

    private boolean isNativeOrIntegrationTest(Class<?> clazz) {
        for (Class i : currentTestClassStack) {
            if (!i.isAnnotationPresent(QuarkusIntegrationTest.class)) continue;
            return true;
        }
        return clazz.isAnnotationPresent(QuarkusIntegrationTest.class);
    }

    private QuarkusTestExtensionState ensureStarted(ExtensionContext extensionContext) {
        boolean reloadTestResources;
        ExtensionContext.Store store = this.getStoreFromContext(extensionContext);
        QuarkusTestExtensionState state = this.getState(extensionContext);
        Class<? extends QuarkusTestProfile> selectedProfile = this.getQuarkusTestProfile(extensionContext);
        boolean wrongProfile = !Objects.equals(selectedProfile, quarkusTestProfile);
        boolean bl = reloadTestResources = !Objects.equals(extensionContext.getRequiredTestClass(), currentJUnitTestClass) && !this.isNested(currentJUnitTestClass, extensionContext.getRequiredTestClass()) && (hasPerTestResources || QuarkusTestExtension.hasPerTestResources(extensionContext));
        if (state == null && !failedBoot || wrongProfile || reloadTestResources) {
            if ((wrongProfile || reloadTestResources) && state != null) {
                try {
                    state.close();
                }
                catch (Throwable throwable) {
                    this.markTestAsFailed(extensionContext, throwable);
                }
            }
            PropertyTestUtil.setLogFileProperty();
            try {
                state = this.doJavaStart(extensionContext, selectedProfile);
                this.setState(extensionContext, state);
            }
            catch (Throwable e) {
                failedBoot = true;
                this.markTestAsFailed(extensionContext, e);
                firstException = e;
                this.getStoreFromContext(extensionContext).put((Object)FailedCleanup.class.getName(), (Object)new FailedCleanup());
            }
        }
        return state;
    }

    private boolean isNested(Class<?> testClass, Class<?> currentTestClass) {
        if (testClass == null || currentTestClass.getEnclosingClass() == null) {
            return false;
        }
        Class<?> enclosingTestClass = currentTestClass.getEnclosingClass();
        return Objects.equals(testClass, enclosingTestClass) || this.isNested(testClass, enclosingTestClass);
    }

    private static ClassLoader setCCL(ClassLoader cl) {
        Thread thread = Thread.currentThread();
        ClassLoader original = thread.getContextClassLoader();
        thread.setContextClassLoader(cl);
        return original;
    }

    private void throwBootFailureException() {
        if (firstException != null) {
            Throwable throwable = firstException;
            firstException = null;
            throw new RuntimeException(throwable);
        }
        throw new TestAbortedException("Boot failed");
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        GroovyClassValue.disable();
        currentTestClassStack.push(context.getRequiredTestClass());
        ProfileManager.setLaunchMode((LaunchMode)LaunchMode.TEST);
        if (this.isNativeOrIntegrationTest(context.getRequiredTestClass())) {
            return;
        }
        QuarkusTestExtension.resetHangTimeout();
        this.ensureStarted(context);
        if (runningQuarkusApplication != null) {
            this.pushMockContext();
        }
    }

    private void pushMockContext() {
        try {
            Method pushContext = runningQuarkusApplication.getClassLoader().loadClass(MockSupport.class.getName()).getDeclaredMethod("pushContext", new Class[0]);
            pushContext.setAccessible(true);
            pushContext.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void popMockContext() {
        try {
            Method popContext = runningQuarkusApplication.getClassLoader().loadClass(MockSupport.class.getName()).getDeclaredMethod("popContext", new Class[0]);
            popContext.setAccessible(true);
            popContext.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            invocation.proceed();
            return;
        }
        QuarkusTestExtension.resetHangTimeout();
        this.ensureStarted(extensionContext);
        if (failedBoot) {
            this.throwBootFailureException();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T interceptTestClassConstructor(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Constructor<T>> invocationContext, ExtensionContext extensionContext) throws Throwable {
        Object result;
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            return (T)invocation.proceed();
        }
        QuarkusTestExtension.resetHangTimeout();
        QuarkusTestExtensionState state = this.ensureStarted(extensionContext);
        if (failedBoot) {
            this.throwBootFailureException();
            return null;
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Class requiredTestClass = extensionContext.getRequiredTestClass();
        if (runningQuarkusApplication != null) {
            try {
                Thread.currentThread().setContextClassLoader(runningQuarkusApplication.getClassLoader());
                this.invokeBeforeClassCallbacks(Class.class, runningQuarkusApplication.getClassLoader().loadClass(requiredTestClass.getName()));
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        } else {
            this.invokeBeforeClassCallbacks(Class.class, requiredTestClass);
        }
        try {
            Thread.currentThread().setContextClassLoader(requiredTestClass.getClassLoader());
            result = invocation.proceed();
        }
        catch (NullPointerException e) {
            throw new RuntimeException("When using constructor injection in a test, the only legal operation is to assign the constructor values to fields. Offending class is " + requiredTestClass, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        old = null;
        if (runningQuarkusApplication != null) {
            old = QuarkusTestExtension.setCCL(runningQuarkusApplication.getClassLoader());
        }
        try {
            this.initTestState(extensionContext, state);
        }
        finally {
            if (old != null) {
                QuarkusTestExtension.setCCL(old);
            }
        }
        return (T)result;
    }

    private void initTestState(ExtensionContext extensionContext, QuarkusTestExtensionState state) {
        try {
            actualTestClass = Class.forName(extensionContext.getRequiredTestClass().getName(), true, Thread.currentThread().getContextClassLoader());
            if (extensionContext.getRequiredTestClass().isAnnotationPresent(Nested.class)) {
                Class<?> outerClass = actualTestClass.getEnclosingClass();
                Constructor<?> declaredConstructor = actualTestClass.getDeclaredConstructor(outerClass);
                declaredConstructor.setAccessible(true);
                if (outerClass.isInstance(actualTestInstance)) {
                    outerInstances.add(actualTestInstance);
                    actualTestInstance = declaredConstructor.newInstance(actualTestInstance);
                } else {
                    Object outerInstance = this.createActualTestInstance(outerClass, state);
                    this.invokeAfterConstructCallbacks(Object.class, outerInstance);
                    actualTestInstance = declaredConstructor.newInstance(outerInstance);
                    outerInstances.add(outerInstance);
                }
            } else {
                outerInstances.clear();
                actualTestInstance = this.createActualTestInstance(actualTestClass, state);
            }
            this.invokeAfterConstructCallbacks(Object.class, actualTestInstance);
        }
        catch (Exception e) {
            throw new TestInstantiationException("Failed to create test instance", e instanceof InvocationTargetException ? e.getCause() : e);
        }
    }

    private Object createActualTestInstance(Class<?> testClass, QuarkusTestExtensionState state) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object testInstance = runningQuarkusApplication.instance(testClass, new Annotation[0]);
        Class<?> resM = Thread.currentThread().getContextClassLoader().loadClass(TestHTTPResourceManager.class.getName());
        resM.getDeclaredMethod("inject", Object.class, List.class).invoke(null, testInstance, testHttpEndpointProviders);
        state.testResourceManager.getClass().getMethod("inject", Object.class).invoke((Object)state.testResourceManager, testInstance);
        return testInstance;
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext, true);
        invocation.skip();
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            invocation.proceed();
            return;
        }
        CopyOnWriteArrayList serverExceptions = new CopyOnWriteArrayList();
        ExceptionReporting.setListener(serverExceptions::add);
        try {
            this.runExtensionMethod(invocationContext, extensionContext, true);
            invocation.skip();
        }
        catch (Throwable t) {
            for (Throwable serverException : serverExceptions) {
                if (t == serverException) continue;
                t.addSuppressed(serverException);
            }
            throw t;
        }
        finally {
            ExceptionReporting.setListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interceptDynamicTest(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext) throws Throwable {
        if (runningQuarkusApplication == null) {
            invocation.proceed();
            return;
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(runningQuarkusApplication.getClassLoader());
            invocation.proceed();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            return (T)invocation.proceed();
        }
        Object result = this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
        return (T)result;
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext, true);
        invocation.skip();
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    private Object runExtensionMethod(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        return this.runExtensionMethod(invocationContext, extensionContext, false);
    }

    private Object runExtensionMethod(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, boolean testMethodInvokersAllowed) throws Throwable {
        QuarkusTestExtension.resetHangTimeout();
        ClassLoader old = QuarkusTestExtension.setCCL(runningQuarkusApplication.getClassLoader());
        try {
            Class<?> testClassFromTCCL = Class.forName(extensionContext.getRequiredTestClass().getName(), true, Thread.currentThread().getContextClassLoader());
            HashMap allTestsClasses = new HashMap();
            allTestsClasses.put(testClassFromTCCL, actualTestInstance);
            outerInstances.forEach(i -> allTestsClasses.put(i.getClass(), i));
            Method newMethod = null;
            Object effectiveTestInstance = null;
            for (Map.Entry entry : allTestsClasses.entrySet()) {
                newMethod = this.determineTCCLExtensionMethod((Method)invocationContext.getExecutable(), (Class)entry.getKey());
                if (newMethod == null) continue;
                effectiveTestInstance = entry.getValue();
                break;
            }
            if (newMethod == null) {
                throw new RuntimeException("Could not find method " + invocationContext.getExecutable() + " on test class");
            }
            newMethod.setAccessible(true);
            Object testMethodInvokerToUse = null;
            if (testMethodInvokersAllowed) {
                for (Object object : testMethodInvokers) {
                    boolean supportsMethod = (Boolean)object.getClass().getMethod("supportsMethod", Class.class, Method.class).invoke(object, extensionContext.getRequiredTestClass(), invocationContext.getExecutable());
                    if (!supportsMethod) continue;
                    testMethodInvokerToUse = object;
                    break;
                }
            }
            List list = invocationContext.getArguments();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Parameter[] parameters = ((Method)invocationContext.getExecutable()).getParameters();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object arg = list.get(i2);
                boolean cloneRequired = false;
                TestInfoImpl replacement = null;
                Class<?> argClass = parameters[i2].getType();
                if (arg != null) {
                    Class<?> theclass = argClass;
                    while (theclass.isArray()) {
                        theclass = theclass.getComponentType();
                    }
                    if (theclass.isPrimitive()) {
                        cloneRequired = false;
                    } else if (TestInfo.class.isAssignableFrom(theclass)) {
                        TestInfo info = (TestInfo)arg;
                        Method newTestMethod = info.getTestMethod().isPresent() ? this.determineTCCLExtensionMethod((Method)info.getTestMethod().get(), testClassFromTCCL) : null;
                        replacement = new TestInfoImpl(info.getDisplayName(), info.getTags(), Optional.of(testClassFromTCCL), Optional.ofNullable(newTestMethod));
                    } else if (clonePattern.matcher(theclass.getName()).matches()) {
                        cloneRequired = true;
                    } else {
                        try {
                            cloneRequired = runningQuarkusApplication.getClassLoader().loadClass(theclass.getName()) != theclass;
                        }
                        catch (ClassNotFoundException e) {
                            if (arg instanceof Supplier) {
                                cloneRequired = true;
                            }
                            throw e;
                        }
                    }
                }
                if (replacement != null) {
                    arrayList.add(replacement);
                    continue;
                }
                if (cloneRequired) {
                    arrayList.add(deepClone.clone(arg));
                    continue;
                }
                if (testMethodInvokerToUse != null) {
                    arrayList.add(testMethodInvokerToUse.getClass().getMethod("methodParamInstance", String.class).invoke(testMethodInvokerToUse, argClass.getName()));
                    continue;
                }
                arrayList.add(arg);
            }
            if (testMethodInvokerToUse != null) {
                Object object = testMethodInvokerToUse.getClass().getMethod("invoke", Object.class, Method.class, List.class, String.class).invoke(testMethodInvokerToUse, effectiveTestInstance, newMethod, arrayList, extensionContext.getRequiredTestClass().getName());
                return object;
            }
            Object object = newMethod.invoke(effectiveTestInstance, arrayList.toArray(new Object[0]));
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        finally {
            QuarkusTestExtension.setCCL(old);
        }
    }

    private Method determineTCCLExtensionMethod(Method originalMethod, Class<?> c) throws ClassNotFoundException {
        Class<?> declaringClass = this.resolveDeclaringClass(originalMethod, c);
        if (declaringClass == null) {
            return null;
        }
        try {
            Class<?>[] originalParameterTypes = originalMethod.getParameterTypes();
            ArrayList parameterTypesFromTccl = new ArrayList(originalParameterTypes.length);
            for (Class<?> type : originalParameterTypes) {
                if (type.isPrimitive()) {
                    parameterTypesFromTccl.add(type);
                    continue;
                }
                parameterTypesFromTccl.add(Class.forName(type.getName(), true, Thread.currentThread().getContextClassLoader()));
            }
            return declaringClass.getDeclaredMethod(originalMethod.getName(), parameterTypesFromTccl.toArray(new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Class<?> resolveDeclaringClass(Method method, Class<?> c) {
        if (c == Object.class || c == null) {
            return null;
        }
        if (c.getName().equals(method.getDeclaringClass().getName())) {
            return c;
        }
        Class<?> declaringClass = this.resolveDeclaringClass(method, c.getSuperclass());
        if (declaringClass != null) {
            return declaringClass;
        }
        for (Class<?> anInterface : c.getInterfaces()) {
            declaringClass = this.resolveDeclaringClass(method, anInterface);
            if (declaringClass == null) continue;
            return declaringClass;
        }
        return null;
    }

    public void afterAll(ExtensionContext context) throws Exception {
        QuarkusTestExtension.resetHangTimeout();
        this.runAfterAllCallbacks(context);
        try {
            if (!this.isNativeOrIntegrationTest(context.getRequiredTestClass()) && runningQuarkusApplication != null) {
                this.popMockContext();
            }
            if (this.originalCl != null) {
                QuarkusTestExtension.setCCL(this.originalCl);
            }
        }
        finally {
            currentTestClassStack.pop();
            if (!outerInstances.isEmpty()) {
                actualTestInstance = outerInstances.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAfterAllCallbacks(ExtensionContext context) throws Exception {
        if (this.isNativeOrIntegrationTest(context.getRequiredTestClass()) || failedBoot) {
            return;
        }
        if (this.isAfterAllCallbacksEmpty()) {
            return;
        }
        QuarkusTestExtensionState state = this.getState(context);
        Class<?> quarkusTestContextClass = Class.forName(QuarkusTestContext.class.getName(), true, runningQuarkusApplication.getClassLoader());
        Object quarkusTestContextInstance = quarkusTestContextClass.getConstructor(Object.class, List.class, Throwable.class).newInstance(actualTestInstance, new ArrayList<Object>(outerInstances), state.getTestErrorCause());
        ClassLoader original = QuarkusTestExtension.setCCL(runningQuarkusApplication.getClassLoader());
        try {
            this.invokeAfterAllCallbacks(quarkusTestContextClass, quarkusTestContextInstance);
        }
        finally {
            QuarkusTestExtension.setCCL(original);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        boolean isConstructor = parameterContext.getDeclaringExecutable() instanceof Constructor;
        if (isConstructor) {
            return true;
        }
        if (!(parameterContext.getDeclaringExecutable() instanceof Method)) {
            return false;
        }
        if (testMethodInvokers == null) {
            return false;
        }
        for (Object testMethodInvoker : testMethodInvokers) {
            boolean handlesMethodParamType = this.testMethodInvokerHandlesParamType(testMethodInvoker, parameterContext);
            if (!handlesMethodParamType) continue;
            return true;
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        String className;
        if (parameterContext.getDeclaringExecutable() instanceof Method && testMethodInvokers != null) {
            for (Object testMethodInvoker : testMethodInvokers) {
                if (!this.testMethodInvokerHandlesParamType(testMethodInvoker, parameterContext)) continue;
                return null;
            }
        }
        switch (className = parameterContext.getParameter().getType().getName()) {
            case "boolean": {
                return false;
            }
            case "byte": 
            case "short": 
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
            case "char": {
                return Character.valueOf('\u0000');
            }
        }
        return null;
    }

    private boolean testMethodInvokerHandlesParamType(Object testMethodInvoker, ParameterContext parameterContext) {
        try {
            return (Boolean)testMethodInvoker.getClass().getMethod("handlesMethodParamType", String.class).invoke(testMethodInvoker, parameterContext.getParameter().getType().getName());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to determine if TestMethodInvoker supports parameter");
        }
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        String[] tags;
        QuarkusTestProfile profileInstance;
        if (!context.getTestClass().isPresent()) {
            return ConditionEvaluationResult.enabled((String)"No test class specified");
        }
        if (context.getTestInstance().isPresent()) {
            return ConditionEvaluationResult.enabled((String)"Quarkus Test Profile tags only affect classes");
        }
        String tagsStr = System.getProperty("quarkus.test.profile.tags");
        if (tagsStr == null || tagsStr.isEmpty()) {
            return ConditionEvaluationResult.enabled((String)"No Quarkus Test Profile tags");
        }
        Class<? extends QuarkusTestProfile> testProfile = this.getQuarkusTestProfile(context);
        if (testProfile == null) {
            return ConditionEvaluationResult.disabled((String)("Test '" + context.getRequiredTestClass() + "' is not annotated with '@QuarkusTestProfile' but 'quarkus.profile.test.tags' was set"));
        }
        try {
            profileInstance = testProfile.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set<String> testProfileTags = profileInstance.tags();
        for (String tag : tags = tagsStr.split(",")) {
            String trimmedTag = tag.trim();
            if (!testProfileTags.contains(trimmedTag)) continue;
            return ConditionEvaluationResult.enabled((String)("Tag '" + trimmedTag + "' is present on '" + testProfile + "' which is used on test '" + context.getRequiredTestClass()));
        }
        return ConditionEvaluationResult.disabled((String)("Test '" + context.getRequiredTestClass() + "' disabled because 'quarkus.profile.test.tags' don't match the tags of '" + testProfile + "'"));
    }

    private static void resetHangTimeout() {
        if (hangTaskKey != null) {
            hangTaskKey.cancel(false);
            ScheduledExecutorService h = hangDetectionExecutor;
            if (h != null) {
                try {
                    hangTaskKey = h.schedule(hangDetectionTask, hangTimeout.toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        outerInstances = new ArrayDeque<Object>(1);
        hangDetectionTask = new Runnable(){
            final AtomicBoolean runOnce = new AtomicBoolean();

            @Override
            public void run() {
                ThreadInfo[] threads;
                if (!this.runOnce.compareAndSet(false, true)) {
                    return;
                }
                System.err.println("@QuarkusTest has detected a hang, as there has been no test activity in " + hangTimeout);
                System.err.println("To configure this timeout use the quarkus.test.hang-detection-timeout config property");
                System.err.println("A stack trace is below to help diagnose the potential hang");
                System.err.println("=== Stack Trace ===");
                for (ThreadInfo info : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                    if (info == null) {
                        System.err.println("  Inactive");
                        continue;
                    }
                    Thread.State state = info.getThreadState();
                    System.err.println("Thread " + info.getThreadName() + ": " + state);
                    if (state == Thread.State.WAITING) {
                        System.err.println("  Waiting on " + info.getLockName());
                    } else if (state == Thread.State.BLOCKED) {
                        System.err.println("  Blocked on " + info.getLockName());
                        System.err.println("  Blocked by " + info.getLockOwnerName());
                    }
                    System.err.println("  Stack:");
                    for (StackTraceElement frame : info.getStackTrace()) {
                        System.err.println("    " + frame.toString());
                    }
                }
                System.err.println("=== End Stack Trace ===");
            }
        };
        ClassLoader classLoader = QuarkusTestExtension.class.getClassLoader();
        if (classLoader instanceof QuarkusClassLoader) {
            ((QuarkusClassLoader)classLoader).addCloseTask(new Runnable(){

                @Override
                public void run() {
                    ScheduledExecutorService h = hangDetectionExecutor;
                    if (h != null) {
                        h.shutdownNow();
                        hangDetectionExecutor = null;
                    }
                }
            });
        }
    }

    public static class TestBuildChainFunction
    implements Function<Map<String, Object>, List<Consumer<BuildChainBuilder>>> {
        @Override
        public List<Consumer<BuildChainBuilder>> apply(Map<String, Object> stringObjectMap) {
            final Path testLocation = (Path)stringObjectMap.get("test-location");
            final Index testClassesIndex = TestClassIndexer.readIndex((Path)testLocation, (Class)((Class)stringObjectMap.get("test-class")));
            ArrayList<Consumer<BuildChainBuilder>> allCustomizers = new ArrayList<Consumer<BuildChainBuilder>>(1);
            Consumer<BuildChainBuilder> defaultCustomizer = new Consumer<BuildChainBuilder>(){

                @Override
                public void accept(BuildChainBuilder buildChainBuilder) {
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new TestClassPredicateBuildItem((Predicate)new Predicate<String>(){

                                @Override
                                public boolean test(String className) {
                                    return PathTestHelper.isTestClass((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader(), (Path)testLocation);
                                }
                            }));
                        }
                    }).produces(TestClassPredicateBuildItem.class).build();
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new ApplicationClassPredicateBuildItem((Predicate)new Predicate<String>(){

                                @Override
                                public boolean test(String s) {
                                    QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
                                    List res = cl.getElementsWithResource(s.replace(".", "/") + ".class", true);
                                    return !res.isEmpty();
                                }
                            }));
                        }
                    }).produces(ApplicationClassPredicateBuildItem.class).build();
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new TestAnnotationBuildItem(QuarkusTest.class.getName()));
                        }
                    }).produces(TestAnnotationBuildItem.class).build();
                    final ArrayList<String> testClassBeans = new ArrayList<String>();
                    List extendWith = testClassesIndex.getAnnotations(DotNames.EXTEND_WITH);
                    for (AnnotationInstance annotationInstance : extendWith) {
                        Type[] extendsWithTypes;
                        ClassInfo classInfo;
                        if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS || (classInfo = annotationInstance.target().asClass()).isAnnotation()) continue;
                        for (Type type : extendsWithTypes = annotationInstance.value().asClassArray()) {
                            if (!DotNames.QUARKUS_TEST_EXTENSION.equals((Object)type.name())) continue;
                            testClassBeans.add(classInfo.name().toString());
                        }
                    }
                    List registerExtension = testClassesIndex.getAnnotations(DotNames.REGISTER_EXTENSION);
                    for (AnnotationInstance annotationInstance : registerExtension) {
                        FieldInfo fieldInfo;
                        if (annotationInstance.target().kind() != AnnotationTarget.Kind.FIELD || !DotNames.QUARKUS_TEST_EXTENSION.equals((Object)(fieldInfo = annotationInstance.target().asField()).type().name())) continue;
                        testClassBeans.add(fieldInfo.declaringClass().name().toString());
                    }
                    if (!testClassBeans.isEmpty()) {
                        buildChainBuilder.addBuildStep(new BuildStep(){

                            public void execute(BuildContext context) {
                                for (String quarkusExtendWithTestClass : testClassBeans) {
                                    context.produce((BuildItem)new TestClassBeanBuildItem(quarkusExtendWithTestClass));
                                }
                            }
                        }).produces(TestClassBeanBuildItem.class).build();
                    }
                }
            };
            allCustomizers.add(defaultCustomizer);
            for (TestBuildChainCustomizerProducer testBuildChainCustomizerProducer : ServiceLoader.load(TestBuildChainCustomizerProducer.class, this.getClass().getClassLoader())) {
                allCustomizers.add(testBuildChainCustomizerProducer.produce(testClassesIndex));
            }
            return allCustomizers;
        }
    }

    class FailedCleanup
    implements ExtensionContext.Store.CloseableResource {
        FailedCleanup() {
        }

        public void close() {
            QuarkusTestExtension.this.shutdownHangDetection();
            firstException = null;
            failedBoot = false;
            ConfigProviderResolver.setInstance(null);
        }
    }

    public class ExtensionState
    extends QuarkusTestExtensionState {
        public ExtensionState(Closeable testResourceManager, Closeable resource) {
            super(testResourceManager, resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doClose() throws IOException {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            if (runningQuarkusApplication != null) {
                Thread.currentThread().setContextClassLoader(runningQuarkusApplication.getClassLoader());
            }
            try {
                this.resource.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to shutdown Quarkus", e);
            }
            finally {
                runningQuarkusApplication = null;
                clonePattern = null;
                try {
                    if (QuarkusTestExtension.this.originalCl != null) {
                        QuarkusTestExtension.setCCL(QuarkusTestExtension.this.originalCl);
                    }
                    this.testResourceManager.close();
                }
                catch (Exception e) {
                    log.error((Object)"Failed to shutdown Quarkus test resources", (Throwable)e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                    ConfigProviderResolver.setInstance(null);
                }
            }
        }
    }
}

