/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.kafka.client.deployment.KafkaBuildTimeConfig;
import io.quarkus.kafka.client.runtime.KafkaBindingConverter;
import io.quarkus.kafka.client.runtime.KafkaRecorder;
import io.quarkus.kafka.client.runtime.KafkaRuntimeConfigProducer;
import io.quarkus.kafka.client.serialization.JsonbDeserializer;
import io.quarkus.kafka.client.serialization.JsonbSerializer;
import io.quarkus.kafka.client.serialization.ObjectMapperDeserializer;
import io.quarkus.kafka.client.serialization.ObjectMapperSerializer;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.spi.LoginModule;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.security.authenticator.AbstractLogin;
import org.apache.kafka.common.security.authenticator.DefaultLogin;
import org.apache.kafka.common.security.authenticator.SaslClientCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerRefreshingLogin;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslClient;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.ByteBufferDeserializer;
import org.apache.kafka.common.serialization.ByteBufferSerializer;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.BytesSerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.FloatDeserializer;
import org.apache.kafka.common.serialization.FloatSerializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.ShortDeserializer;
import org.apache.kafka.common.serialization.ShortSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class KafkaProcessor {
    static final Class<?>[] BUILT_INS = new Class[]{ShortSerializer.class, DoubleSerializer.class, LongSerializer.class, BytesSerializer.class, ByteArraySerializer.class, IntegerSerializer.class, ByteBufferSerializer.class, StringSerializer.class, FloatSerializer.class, ShortDeserializer.class, DoubleDeserializer.class, LongDeserializer.class, BytesDeserializer.class, ByteArrayDeserializer.class, IntegerDeserializer.class, ByteBufferDeserializer.class, StringDeserializer.class, FloatDeserializer.class};
    static final DotName OBJECT_MAPPER = DotName.createSimple((String)"com.fasterxml.jackson.databind.ObjectMapper");

    @BuildStep
    void contributeClassesToIndex(BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClasses, BuildProducer<IndexDependencyBuildItem> indexDependency) {
        additionalIndexedClasses.produce((BuildItem)new AdditionalIndexedClassesBuildItem(new String[]{LoginModule.class.getName(), Subject.class.getName(), AppConfigurationEntry.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.class.getName()}));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.apache.kafka", "kafka-clients"));
    }

    @BuildStep
    public void build(KafkaBuildTimeConfig config, CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServiceProviderBuildItem> serviceProviders, BuildProducer<NativeImageProxyDefinitionBuildItem> proxies, Capabilities capabilities, BuildProducer<UnremovableBeanBuildItem> beans, BuildProducer<NativeImageResourceBuildItem> nativeLibs, NativeConfig nativeConfig) {
        HashSet<DotName> toRegister = new HashSet<DotName>();
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, Serializer.class);
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, Deserializer.class);
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, Partitioner.class);
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, PartitionAssignor.class);
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, ConsumerPartitionAssignor.class);
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, ConsumerInterceptor.class);
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, ProducerInterceptor.class);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{OAuthBearerSaslClient.class, OAuthBearerSaslClient.OAuthBearerSaslClientFactory.class, OAuthBearerToken.class, OAuthBearerRefreshingLogin.class}));
        for (Class<?> i : BUILT_INS) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{i.getName()}));
            KafkaProcessor.collectSubclasses(toRegister, indexBuildItem, i);
        }
        if (capabilities.isPresent(Capability.JSONB)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{JsonbSerializer.class, JsonbDeserializer.class}));
            KafkaProcessor.collectSubclasses(toRegister, indexBuildItem, JsonbSerializer.class);
            KafkaProcessor.collectSubclasses(toRegister, indexBuildItem, JsonbDeserializer.class);
        }
        if (capabilities.isPresent(Capability.JACKSON)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{ObjectMapperSerializer.class, ObjectMapperDeserializer.class}));
            KafkaProcessor.collectSubclasses(toRegister, indexBuildItem, ObjectMapperSerializer.class);
            KafkaProcessor.collectSubclasses(toRegister, indexBuildItem, ObjectMapperDeserializer.class);
            beans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{OBJECT_MAPPER}));
        }
        for (DotName s : toRegister) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{s.toString()}));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{DefaultPartitioner.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{RangeAssignor.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{RoundRobinAssignor.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{StickyAssignor.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"java.nio.DirectByteBuffer"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"sun.misc.Cleaner"}));
        this.handleAvro(reflectiveClass, proxies, serviceProviders);
        this.handleOpenTracing(reflectiveClass, capabilities);
        this.handleStrimziOAuth(reflectiveClass);
        if (config.snappyEnabled) {
            this.handleSnappy(reflectiveClass, nativeLibs, nativeConfig);
        }
    }

    private void handleSnappy(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> nativeLibs, NativeConfig nativeConfig) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{"org.xerial.snappy.SnappyInputStream", "org.xerial.snappy.SnappyOutputStream"}));
        String root = "org/xerial/snappy/native/";
        if (nativeConfig.containerRuntime.isPresent() || nativeConfig.containerBuild) {
            String dir = "Linux/x86_64";
            String snappyNativeLibraryName = "libsnappyjava.so";
            String path = root + dir + "/" + snappyNativeLibraryName;
            nativeLibs.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{path}));
        } else {
            String dir = KafkaProcessor.getOs() + "/" + KafkaProcessor.getArch();
            String snappyNativeLibraryName = System.mapLibraryName("snappyjava");
            if (snappyNativeLibraryName.toLowerCase().endsWith(".dylib")) {
                snappyNativeLibraryName = snappyNativeLibraryName.replace(".dylib", ".jnilib");
            }
            String path = root + dir + "/" + snappyNativeLibraryName;
            nativeLibs.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{path}));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void loadSnappyIfEnabled(KafkaRecorder recorder, KafkaBuildTimeConfig config) {
        if (config.snappyEnabled) {
            recorder.loadSnappy();
        }
    }

    private void handleOpenTracing(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Capabilities capabilities) {
        if (capabilities.isPresent(Capability.OPENTRACING)) {
            try {
                Class.forName("io.opentracing.contrib.kafka.TracingProducerInterceptor", false, Thread.currentThread().getContextClassLoader());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"io.opentracing.contrib.kafka.TracingProducerInterceptor", "io.opentracing.contrib.kafka.TracingConsumerInterceptor"}));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void handleStrimziOAuth(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        try {
            Class.forName("io.strimzi.kafka.oauth.client.JaasClientOauthLoginCallbackHandler", false, Thread.currentThread().getContextClassLoader());
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{"io.strimzi.kafka.oauth.client.JaasClientOauthLoginCallbackHandler"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{"org.keycloak.jose.jws.JWSHeader", "org.keycloak.representations.AccessToken", "org.keycloak.representations.AccessToken$Access", "org.keycloak.representations.AccessTokenResponse", "org.keycloak.representations.IDToken", "org.keycloak.representations.JsonWebToken", "org.keycloak.jose.jwk.JSONWebKeySet", "org.keycloak.jose.jwk.JWK", "org.keycloak.json.StringOrArrayDeserializer", "org.keycloak.json.StringListMapDeserializer"}));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void handleAvro(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageProxyDefinitionBuildItem> proxies, BuildProducer<ServiceProviderBuildItem> serviceProviders) {
        try {
            Class.forName("io.confluent.kafka.serializers.KafkaAvroDeserializer", false, Thread.currentThread().getContextClassLoader());
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"io.confluent.kafka.serializers.KafkaAvroDeserializer", "io.confluent.kafka.serializers.KafkaAvroSerializer"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"io.confluent.kafka.serializers.subject.TopicNameStrategy", "io.confluent.kafka.serializers.subject.TopicRecordNameStrategy", "io.confluent.kafka.serializers.subject.RecordNameStrategy"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage", "io.confluent.kafka.schemaregistry.client.rest.entities.Schema", "io.confluent.kafka.schemaregistry.client.rest.entities.Config", "io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference", "io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString", "io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTypeConverter", "io.confluent.kafka.schemaregistry.client.rest.entities.ServerClusterId", "io.confluent.kafka.schemaregistry.client.rest.entities.SujectVersion"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"io.confluent.kafka.schemaregistry.client.rest.entities.requests.CompatibilityCheckResponse", "io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest", "io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeGetResponse", "io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest", "io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest", "io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse"}));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider", false, Thread.currentThread().getContextClassLoader());
            serviceProviders.produce((BuildItem)new ServiceProviderBuildItem("io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider", new String[]{"io.confluent.kafka.schemaregistry.client.security.basicauth.SaslBasicAuthCredentialProvider", "io.confluent.kafka.schemaregistry.client.security.basicauth.UrlBasicAuthCredentialProvider", "io.confluent.kafka.schemaregistry.client.security.basicauth.UserInfoCredentialProvider"}));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("io.apicurio.registry.utils.serde.AvroKafkaDeserializer", false, Thread.currentThread().getContextClassLoader());
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"io.apicurio.registry.utils.serde.AvroKafkaDeserializer", "io.apicurio.registry.utils.serde.AvroKafkaSerializer"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"io.apicurio.registry.utils.serde.avro.ReflectAvroDatumProvider", "io.apicurio.registry.utils.serde.strategy.AutoRegisterIdStrategy", "io.apicurio.registry.utils.serde.strategy.CachedSchemaIdStrategy", "io.apicurio.registry.utils.serde.strategy.FindBySchemaIdStrategy", "io.apicurio.registry.utils.serde.strategy.FindLatestIdStrategy", "io.apicurio.registry.utils.serde.strategy.GetOrCreateIdStrategy", "io.apicurio.registry.utils.serde.strategy.RecordIdStrategy", "io.apicurio.registry.utils.serde.strategy.SimpleTopicIdStrategy", "io.apicurio.registry.utils.serde.strategy.TopicIdStrategy", "io.apicurio.registry.utils.serde.strategy.TopicRecordIdStrategy"}));
            proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"io.apicurio.registry.client.RegistryService", "java.lang.AutoCloseable"}));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @BuildStep
    public AdditionalBeanBuildItem runtimeConfig() {
        return AdditionalBeanBuildItem.builder().addBeanClass(KafkaRuntimeConfigProducer.class).setUnremovable().build();
    }

    @BuildStep
    public void withSasl(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{AbstractLogin.DefaultLoginCallbackHandler.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{SaslClientCallbackHandler.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{DefaultLogin.class}));
        Type loginModuleType = Type.create((DotName)DotName.createSimple((String)LoginModule.class.getName()), (Type.Kind)Type.Kind.CLASS);
        reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(loginModuleType).source(this.getClass().getSimpleName() + " > " + loginModuleType.name().toString()).build());
    }

    private static void collectImplementors(Set<DotName> set, CombinedIndexBuildItem indexBuildItem, Class<?> cls) {
        KafkaProcessor.collectClassNames(set, indexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)cls.getName())));
    }

    private static void collectSubclasses(Set<DotName> set, CombinedIndexBuildItem indexBuildItem, Class<?> cls) {
        KafkaProcessor.collectClassNames(set, indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)cls.getName())));
    }

    private static void collectClassNames(final Set<DotName> set, Collection<ClassInfo> classInfos) {
        classInfos.forEach(new Consumer<ClassInfo>(){

            @Override
            public void accept(ClassInfo c) {
                set.add(c.name());
            }
        });
    }

    @BuildStep
    HealthBuildItem addHealthCheck(KafkaBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkus.kafka.client.health.KafkaHealthCheck", buildTimeConfig.healthEnabled);
    }

    @BuildStep
    UnremovableBeanBuildItem ensureJsonParserAvailable() {
        return UnremovableBeanBuildItem.beanClassNames((String[])new String[]{"io.quarkus.jackson.ObjectMapperProducer", "com.fasterxml.jackson.databind.ObjectMapper", "io.quarkus.jsonb.JsonbProducer", "javax.json.bind.Jsonb"});
    }

    @BuildStep
    void registerServiceBinding(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        if (capabilities.isPresent(Capability.KUBERNETES_SERVICE_BINDING)) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter", new String[]{KafkaBindingConverter.class.getName()}));
        }
    }

    public static String getArch() {
        String osArch = System.getProperty("os.arch");
        return osArch.replaceAll("\\W", "");
    }

    static String getOs() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            return "Windows";
        }
        if (osName.contains("Mac")) {
            return "Mac";
        }
        if (osName.contains("Linux")) {
            return "Linux";
        }
        return osName.replaceAll("\\W", "");
    }
}

