/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.kafka.client.deployment.KafkaBuildTimeConfig;
import io.quarkus.kafka.client.serialization.JsonbDeserializer;
import io.quarkus.kafka.client.serialization.JsonbSerializer;
import io.quarkus.kafka.client.serialization.ObjectMapperDeserializer;
import io.quarkus.kafka.client.serialization.ObjectMapperSerializer;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.HashSet;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.ByteBufferDeserializer;
import org.apache.kafka.common.serialization.ByteBufferSerializer;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.BytesSerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.FloatDeserializer;
import org.apache.kafka.common.serialization.FloatSerializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.ShortDeserializer;
import org.apache.kafka.common.serialization.ShortSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class KafkaProcessor {
    static final Class[] BUILT_INS = new Class[]{ShortSerializer.class, DoubleSerializer.class, LongSerializer.class, BytesSerializer.class, ByteArraySerializer.class, IntegerSerializer.class, ByteBufferSerializer.class, StringSerializer.class, FloatSerializer.class, ShortDeserializer.class, DoubleDeserializer.class, LongDeserializer.class, BytesDeserializer.class, ByteArrayDeserializer.class, IntegerDeserializer.class, ByteBufferDeserializer.class, StringDeserializer.class, FloatDeserializer.class};

    @BuildStep
    public void build(CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Capabilities capabilities) {
        HashSet toRegister = new HashSet();
        toRegister.addAll(indexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)Serializer.class.getName())));
        toRegister.addAll(indexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)Deserializer.class.getName())));
        toRegister.addAll(indexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)Partitioner.class.getName())));
        toRegister.addAll(indexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)PartitionAssignor.class.getName())));
        for (Class i : BUILT_INS) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{i.getName()}));
            toRegister.addAll(indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)i.getName())));
        }
        if (capabilities.isCapabilityPresent("io.quarkus.jsonb")) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{JsonbSerializer.class, JsonbDeserializer.class}));
            toRegister.addAll(indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)JsonbSerializer.class.getName())));
            toRegister.addAll(indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)JsonbDeserializer.class.getName())));
        }
        if (capabilities.isCapabilityPresent("io.quarkus.jackson")) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{ObjectMapperSerializer.class, ObjectMapperDeserializer.class}));
            toRegister.addAll(indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)ObjectMapperSerializer.class.getName())));
            toRegister.addAll(indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)ObjectMapperDeserializer.class.getName())));
        }
        for (ClassInfo s : toRegister) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{s.toString()}));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{DefaultPartitioner.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{RangeAssignor.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{RoundRobinAssignor.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{StickyAssignor.class.getName()}));
    }

    @BuildStep
    HealthBuildItem addHealthCheck(KafkaBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkus.kafka.client.health.KafkaHealthCheck", buildTimeConfig.healthEnabled, "kafka");
    }
}

