/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.serialization;

import io.quarkus.kafka.client.serialization.JsonbProducer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.json.bind.Jsonb;
import org.apache.kafka.common.serialization.Serializer;

public class JsonbSerializer<T>
implements Serializer<T> {
    private final Jsonb jsonb;
    private final boolean jsonbNeedsClosing;

    public JsonbSerializer() {
        this(JsonbProducer.get(), true);
    }

    public JsonbSerializer(Jsonb jsonb) {
        this(jsonb, false);
    }

    private JsonbSerializer(Jsonb jsonb, boolean jsonbNeedsClosing) {
        this.jsonb = jsonb;
        this.jsonbNeedsClosing = jsonbNeedsClosing;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] serialize(String topic, T data) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            this.jsonb.toJson(data, (OutputStream)output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (!this.jsonbNeedsClosing) {
            return;
        }
        try {
            this.jsonb.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

