/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.kafka.client.serialization.ObjectMapperProducer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;

public class ObjectMapperSerializer<T>
implements Serializer<T> {
    private final ObjectMapper objectMapper;

    public ObjectMapperSerializer() {
        this(ObjectMapperProducer.get());
    }

    public ObjectMapperSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, T data) {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.objectMapper.writeValue((OutputStream)output, data);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        output.close();
        return byArray;
    }

    public void close() {
    }
}

