/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime.ui;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.arc.Arc;
import io.quarkus.kafka.client.runtime.KafkaAdminClient;
import io.quarkus.kafka.client.runtime.ui.AbstractHttpRequestHandler;
import io.quarkus.kafka.client.runtime.ui.KafkaUiUtils;
import io.quarkus.kafka.client.runtime.ui.model.request.KafkaCreateTopicRequest;
import io.quarkus.kafka.client.runtime.ui.model.request.KafkaMessageCreateRequest;
import io.quarkus.kafka.client.runtime.ui.model.request.KafkaMessagesRequest;
import io.quarkus.kafka.client.runtime.ui.model.request.KafkaOffsetRequest;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutionException;

public class KafkaUiHandler
extends AbstractHttpRequestHandler {
    @Override
    public void handlePost(RoutingContext event) {
        if (event.body() == null) {
            this.endResponse(event, HttpResponseStatus.BAD_REQUEST, "Request body is null");
            return;
        }
        KafkaUiUtils webUtils = this.kafkaWebUiUtils();
        JsonObject body = webUtils.fromJson(event.body().buffer());
        if (body == null) {
            this.endResponse(event, HttpResponseStatus.BAD_REQUEST, "Request JSON body is null");
            return;
        }
        String action = body.getString("action");
        Object message = "OK";
        String error = "";
        KafkaAdminClient adminClient = this.kafkaAdminClient();
        boolean res = false;
        if (null != action) {
            try {
                switch (action) {
                    case "getInfo": {
                        message = webUtils.toJson(webUtils.getKafkaInfo());
                        res = true;
                        break;
                    }
                    case "getAclInfo": {
                        message = webUtils.toJson(webUtils.getAclInfo());
                        res = true;
                        break;
                    }
                    case "createTopic": {
                        KafkaCreateTopicRequest topicCreateRq = webUtils.fromJson(event.body().buffer(), KafkaCreateTopicRequest.class);
                        res = adminClient.createTopic(topicCreateRq);
                        message = webUtils.toJson(webUtils.getTopics());
                        break;
                    }
                    case "deleteTopic": {
                        res = adminClient.deleteTopic(body.getString("key"));
                        message = "{}";
                        res = true;
                        break;
                    }
                    case "getTopics": {
                        message = webUtils.toJson(webUtils.getTopics());
                        res = true;
                        break;
                    }
                    case "topicMessages": {
                        KafkaMessagesRequest msgRequest = webUtils.fromJson(event.body().buffer(), KafkaMessagesRequest.class);
                        message = webUtils.toJson(webUtils.getMessages(msgRequest));
                        res = true;
                        break;
                    }
                    case "getOffset": {
                        KafkaOffsetRequest request = webUtils.fromJson(event.body().buffer(), KafkaOffsetRequest.class);
                        message = webUtils.toJson(webUtils.getOffset(request));
                        res = true;
                        break;
                    }
                    case "createMessage": {
                        KafkaMessageCreateRequest rq = webUtils.fromJson(event.body().buffer(), KafkaMessageCreateRequest.class);
                        webUtils.createMessage(rq);
                        message = "{}";
                        res = true;
                        break;
                    }
                    case "getPartitions": {
                        String topicName = body.getString("topicName");
                        message = webUtils.toJson(webUtils.partitions(topicName));
                        res = true;
                        break;
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (res) {
            this.endResponse(event, HttpResponseStatus.OK, (String)message);
        } else {
            message = "ERROR: " + error;
            this.endResponse(event, HttpResponseStatus.BAD_REQUEST, (String)message);
        }
    }

    private void endResponse(RoutingContext event, HttpResponseStatus status, String message) {
        event.response().setStatusCode(status.code());
        event.response().end(message);
    }

    private KafkaUiUtils kafkaWebUiUtils() {
        return (KafkaUiUtils)Arc.container().instance(KafkaUiUtils.class, new Annotation[0]).get();
    }

    @Override
    public void handleGet(RoutingContext event) {
        HttpServerRequest request = event.request();
        String path = request.path();
        this.endResponse(event, HttpResponseStatus.OK, "GET method is not supported yet. Path is: " + path);
    }

    @Override
    public void handleOptions(RoutingContext event) {
        this.endResponse(event, HttpResponseStatus.OK, "OPTION method is not supported yet");
    }

    private KafkaAdminClient kafkaAdminClient() {
        return (KafkaAdminClient)Arc.container().instance(KafkaAdminClient.class, new Annotation[0]).get();
    }
}

