/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.tls;

import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.KeyStore;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.jboss.logging.Logger;

public class QuarkusKafkaSslEngineFactory
implements SslEngineFactory {
    private static final Logger log = Logger.getLogger(QuarkusKafkaSslEngineFactory.class);
    private static final Set<String> KAFKA_SSL_CONFIGS = Set.of("ssl.keystore.type", "ssl.keystore.location", "ssl.keystore.password", "ssl.key.password", "ssl.truststore.type", "ssl.truststore.location", "ssl.truststore.password", "ssl.keystore.certificate.chain", "ssl.keystore.key", "ssl.truststore.certificates", "ssl.protocol", "ssl.provider", "ssl.cipher.suites", "ssl.enabled.protocols", "ssl.keymanager.algorithm", "ssl.trustmanager.algorithm", "ssl.secure.random.implementation");
    private TlsConfiguration configuration;
    private SSLContext sslContext;

    public SSLEngine createClientSslEngine(String peerHost, int peerPort, String endpointIdentification) {
        SSLEngine sslEngine = this.sslContext.createSSLEngine(peerHost, peerPort);
        sslEngine.setUseClientMode(true);
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm(endpointIdentification);
        sslEngine.setSSLParameters(sslParameters);
        return sslEngine;
    }

    public SSLEngine createServerSslEngine(String peerHost, int peerPort) {
        throw new IllegalStateException("Server mode is not supported");
    }

    public boolean shouldBeRebuilt(Map<String, Object> nextConfigs) {
        return false;
    }

    public Set<String> reconfigurableConfigs() {
        return Set.of();
    }

    public KeyStore keystore() {
        return this.configuration.getKeyStore();
    }

    public KeyStore truststore() {
        return this.configuration.getTrustStore();
    }

    public void close() throws IOException {
        this.sslContext = null;
        this.configuration = null;
    }

    public void configure(Map<String, ?> configs) {
        String tlsConfigName = (String)configs.get("tls-configuration-name");
        Instance tlsConfig = CDI.current().getBeanManager().createInstance().select(TlsConfigurationRegistry.class, new Annotation[0]);
        if (!tlsConfig.isUnsatisfied()) {
            TlsConfigurationRegistry registry = (TlsConfigurationRegistry)tlsConfig.get();
            this.configuration = (TlsConfiguration)registry.get(tlsConfigName).orElseThrow(() -> new IllegalArgumentException("No TLS configuration found for name " + tlsConfigName));
            try {
                this.sslContext = this.configuration.createSSLContext();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create SSLContext", e);
            }
            String clientId = (String)configs.get("client.id");
            log.debugf("Configured Kafka client '%s' QuarkusKafkaSslEngineFactory with TLS configuration : %s", (Object)clientId, (Object)tlsConfigName);
        }
    }

    public static void checkForOtherSslConfigs(Map<String, ?> configs) {
        String tlsConfigName = (String)configs.get("tls-configuration-name");
        for (String sslConfig : KAFKA_SSL_CONFIGS) {
            if (!configs.containsKey(sslConfig)) continue;
            log.warnf("The SSL configuration '%s' is set for Kafka client '%s' but it will be ignored because the TLS configuration '%s' is set", (Object)sslConfig, configs.get("client.id"), (Object)tlsConfigName);
        }
    }
}

