/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.streams.runtime;

import io.quarkus.kafka.streams.runtime.SaslConfig;
import io.quarkus.kafka.streams.runtime.SslConfig;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@ConfigRoot(name="kafka-streams", phase=ConfigPhase.RUN_TIME)
public class KafkaStreamsRuntimeConfig {
    public static final String DEFAULT_KAFKA_BROKER = "localhost:9012";
    @ConfigItem(defaultValue="${quarkus.application.name}")
    public String applicationId;
    @ConfigItem(defaultValue="localhost:9012")
    public List<InetSocketAddress> bootstrapServers;
    @ConfigItem
    public Optional<String> applicationServer;
    @ConfigItem
    public List<String> topics;
    @ConfigItem(defaultValue="schema.registry.url")
    public String schemaRegistryKey;
    @ConfigItem
    public Optional<String> schemaRegistryUrl;
    @ConfigItem(name="security.protocol")
    public Optional<String> securityProtocol;
    public SaslConfig sasl;
    public SslConfig ssl;

    public String toString() {
        return "KafkaStreamsRuntimeConfig{applicationId='" + this.applicationId + '\'' + ", bootstrapServers=" + this.bootstrapServers + ", applicationServer=" + this.applicationServer + ", topics=" + this.topics + ", schemaRegistryKey='" + this.schemaRegistryKey + '\'' + ", schemaRegistryUrl=" + this.schemaRegistryUrl + ", sasl=" + this.sasl + ", ssl=" + this.ssl + '}';
    }

    public List<String> getTrimmedTopics() {
        return this.topics.stream().map(String::trim).collect(Collectors.toList());
    }
}

