/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.streams.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.jboss.logging.Logger;

public class KafkaStreamsTopologyManager {
    private static final Logger LOGGER = Logger.getLogger((String)KafkaStreamsTopologyManager.class.getName());
    private final Admin adminClient;

    public KafkaStreamsTopologyManager(Admin adminClient) {
        this.adminClient = adminClient;
    }

    public Set<String> getMissingTopics(Collection<String> topicsToCheck) throws InterruptedException {
        HashSet<String> missing = new HashSet<String>(topicsToCheck);
        try {
            ListTopicsResult topics = this.adminClient.listTopics();
            Set topicNames = (Set)topics.names().get(10L, TimeUnit.SECONDS);
            if (topicNames.containsAll(topicsToCheck)) {
                return Collections.emptySet();
            }
            missing.removeAll(topicNames);
        }
        catch (ExecutionException | TimeoutException e) {
            LOGGER.error((Object)"Failed to get topic names from broker", (Throwable)e);
        }
        return missing;
    }
}

