/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.streams.runtime.devui;

import io.quarkus.kafka.streams.runtime.devui.TopologyParserContext;
import io.smallrye.common.annotation.NonBlocking;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyDescription;

public class KafkaStreamsJsonRPCService {
    @Inject
    Instance<Topology> topologyProvider;
    private static final RawTopologyItemParser SUB_TOPOLOGY = new RawTopologyItemParser(){
        private final Pattern subTopologyPattern = Pattern.compile("Sub-topology: (?<subTopology>[0-9]*).*");
        private Matcher matcher;

        @Override
        public boolean test(String line) {
            this.matcher = this.subTopologyPattern.matcher(line);
            return this.matcher.matches();
        }

        @Override
        public void accept(TopologyParserContext context) {
            context.addSubTopology(this.matcher.group("subTopology"));
        }
    };
    private static final RawTopologyItemParser SOURCE = new RawTopologyItemParser(){
        private final Pattern sourcePattern = Pattern.compile("Source:\\s+(?<source>\\S+)\\s+\\(topics:\\s+((\\[(?<topics>.*)\\])|(?<regex>.*)\\)).*");
        private Matcher matcher;

        @Override
        public boolean test(String line) {
            this.matcher = this.sourcePattern.matcher(line);
            return this.matcher.matches();
        }

        @Override
        public void accept(TopologyParserContext context) {
            if (this.matcher.group("topics") != null) {
                context.addSources(this.matcher.group("source"), this.matcher.group("topics").split(","));
            } else if (this.matcher.group("regex") != null) {
                context.addRegexSource(this.matcher.group("source"), this.matcher.group("regex"));
            }
        }
    };
    private static final RawTopologyItemParser PROCESSOR = new RawTopologyItemParser(){
        private final Pattern processorPattern = Pattern.compile("Processor:\\s+(?<processor>\\S+)\\s+\\(stores:\\s+\\[(?<stores>.*)\\]\\).*");
        private Matcher matcher;
        private String line;

        @Override
        public boolean test(String line) {
            this.line = line;
            this.matcher = this.processorPattern.matcher(line);
            return this.matcher.matches();
        }

        @Override
        public void accept(TopologyParserContext context) {
            context.addStores(this.matcher.group("stores").split(","), this.matcher.group("processor"), this.line.contains("JOIN"));
        }
    };
    private static final RawTopologyItemParser SINK = new RawTopologyItemParser(){
        private final Pattern sinkPattern = Pattern.compile("Sink:\\s+(?<sink>\\S+)\\s+\\(topic:\\s+(?<topic>.*)\\).*");
        private Matcher matcher;

        @Override
        public boolean test(String line) {
            this.matcher = this.sinkPattern.matcher(line);
            return this.matcher.matches();
        }

        @Override
        public void accept(TopologyParserContext context) {
            context.addSink(this.matcher.group("sink"), this.matcher.group("topic"));
        }
    };
    private static final RawTopologyItemParser RIGHT_ARROW = new RawTopologyItemParser(){
        private final Pattern rightArrowPattern = Pattern.compile("\\s*-->\\s+(?<targets>.*)");
        private Matcher matcher;

        @Override
        public boolean test(String line) {
            this.matcher = this.rightArrowPattern.matcher(line);
            return this.matcher.matches();
        }

        @Override
        public void accept(TopologyParserContext context) {
            context.addTargets(this.matcher.group("targets").split(","));
        }
    };

    @NonBlocking
    public JsonObject getTopology() {
        String topologyDescription = "";
        if (this.topologyProvider.isResolvable()) {
            TopologyDescription describe = ((Topology)this.topologyProvider.get()).describe();
            topologyDescription = describe != null ? describe.toString() : "";
        }
        return this.parseTopologyDescription(topologyDescription);
    }

    JsonObject parseTopologyDescription(String topologyDescription) {
        JsonObject res = new JsonObject();
        TopologyParserContext context = new TopologyParserContext();
        Arrays.stream(topologyDescription.split("\n")).map(String::trim).forEachOrdered(line -> Stream.of(SUB_TOPOLOGY, SOURCE, PROCESSOR, SINK, RIGHT_ARROW).filter(itemParser -> itemParser.test(line)).forEachOrdered(itemParser -> itemParser.accept(context)));
        res.put("describe", (Object)topologyDescription).put("subTopologies", context.subTopologies).put("sources", context.sources).put("sinks", context.sinks).put("stores", context.stores).put("graphviz", (Object)context.graphviz.toGraph()).put("mermaid", (Object)context.mermaid.toGraph());
        return res;
    }

    private static interface RawTopologyItemParser
    extends Predicate<String>,
    Consumer<TopologyParserContext> {
    }
}

