/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.admin.client.reactive.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.rest.client.reactive.jackson.runtime.serialisers.ClientJacksonMessageBodyWriter;
import java.lang.annotation.Annotation;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import org.jboss.resteasy.reactive.client.impl.ClientBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.server.jackson.JacksonBasicMessageBodyReader;
import org.keycloak.admin.client.spi.ResteasyClientProvider;

public class ResteasyReactiveClientProvider
implements ResteasyClientProvider {
    public Client newRestEasyClient(Object messageHandler, SSLContext sslContext, boolean disableTrustManager) {
        ClientBuilderImpl clientBuilder = new ClientBuilderImpl();
        return this.registerJacksonProviders(clientBuilder).build();
    }

    private ClientBuilderImpl registerJacksonProviders(ClientBuilderImpl clientBuilder) {
        ArcContainer arcContainer = Arc.container();
        if (arcContainer == null) {
            throw new IllegalStateException(this.getClass().getName() + " should only be used in a Quarkus application");
        }
        InstanceHandle objectMapperInstance = arcContainer.instance(ObjectMapper.class, new Annotation[0]);
        ObjectMapper objectMapper = null;
        InstanceHandle readerInstance = arcContainer.instance(JacksonBasicMessageBodyReader.class, new Annotation[0]);
        if (readerInstance.isAvailable()) {
            clientBuilder = clientBuilder.register(readerInstance.get());
        } else {
            objectMapper = this.getObjectMapper(objectMapper, (InstanceHandle<ObjectMapper>)objectMapperInstance);
            clientBuilder = clientBuilder.register((Object)new JacksonBasicMessageBodyReader(objectMapper));
        }
        InstanceHandle writerInstance = arcContainer.instance(ClientJacksonMessageBodyWriter.class, new Annotation[0]);
        if (writerInstance.isAvailable()) {
            clientBuilder = clientBuilder.register(writerInstance.get());
        } else {
            objectMapper = this.getObjectMapper(objectMapper, (InstanceHandle<ObjectMapper>)objectMapperInstance);
            clientBuilder = clientBuilder.register((Object)new ClientJacksonMessageBodyWriter(objectMapper));
        }
        return clientBuilder;
    }

    private ObjectMapper getObjectMapper(ObjectMapper value, InstanceHandle<ObjectMapper> objectMapperInstance) {
        if (value == null) {
            return objectMapperInstance.isAvailable() ? (ObjectMapper)objectMapperInstance.get() : new ObjectMapper();
        }
        return value;
    }

    public <R> R targetProxy(WebTarget target, Class<R> targetClass) {
        return (R)((WebTargetImpl)target).proxy(targetClass);
    }
}

