/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.admin.rest.client.deployment;

import io.quarkus.arc.BeanDestroyer;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.keycloak.admin.client.common.deployment.KeycloakAdminClientInjectionEnabled;
import io.quarkus.keycloak.admin.rest.client.runtime.KeycloakAdminRestClientProvider;
import io.quarkus.keycloak.admin.rest.client.runtime.KeycloakAdminRestClientRecorder;
import io.quarkus.tls.TlsRegistryBuildItem;
import jakarta.enterprise.context.RequestScoped;
import java.util.function.Predicate;
import org.jboss.jandex.DotName;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.spi.ResteasyClientProvider;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.json.StringListMapDeserializer;
import org.keycloak.json.StringOrArrayDeserializer;
import org.keycloak.json.StringOrArraySerializer;

public class KeycloakAdminRestClientProcessor {
    @BuildStep
    void marker(BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> producer) {
        producer.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem("org/keycloak/admin/client/"));
        producer.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem("org/keycloak/representations"));
    }

    @BuildStep
    public void nativeImage(BuildProducer<ServiceProviderBuildItem> serviceProviderProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> reflectiveHierarchyProducer) {
        serviceProviderProducer.produce((BuildItem)new ServiceProviderBuildItem(ResteasyClientProvider.class.getName(), new String[]{KeycloakAdminRestClientProvider.class.getName()}));
        reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{StringListMapDeserializer.class, StringOrArrayDeserializer.class, StringOrArraySerializer.class}).reason(this.getClass().getName()).methods().build());
        reflectiveHierarchyProducer.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem((Predicate)new ReflectiveHierarchyIgnoreWarningBuildItem.DotNameExclusion(DotName.createSimple((String)MultivaluedHashMap.class.getName()))));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void avoidRuntimeInitIssueInClientBuilderWrapper(KeycloakAdminRestClientRecorder recorder) {
        recorder.avoidRuntimeInitIssueInClientBuilderWrapper();
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Produce(value=ServiceStartBuildItem.class)
    @BuildStep
    public void integrate(KeycloakAdminRestClientRecorder recorder, TlsRegistryBuildItem tlsRegistryBuildItem) {
        recorder.setClientProvider(tlsRegistryBuildItem.registry());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={KeycloakAdminClientInjectionEnabled.class})
    public void registerKeycloakAdminClientBeans(KeycloakAdminRestClientRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Keycloak.class).scope(RequestScoped.class)).setRuntimeInit().defaultBean()).unremovable()).supplier(recorder.createAdminClient()).destroyer(BeanDestroyer.AutoCloseableDestroyer.class)).done());
    }
}

