/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.admin.client.reactive.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.rest.client.reactive.jackson.runtime.serialisers.ClientJacksonMessageBodyWriter;
import io.quarkus.tls.TlsConfiguration;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import jakarta.enterprise.inject.Instance;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.lang.annotation.Annotation;
import java.security.KeyStore;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.resteasy.reactive.client.TlsConfig;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.impl.ClientBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.server.jackson.JacksonBasicMessageBodyReader;
import org.keycloak.admin.client.spi.ResteasyClientProvider;

public class ResteasyReactiveClientProvider
implements ResteasyClientProvider {
    private static final List<String> HANDLED_MEDIA_TYPES = List.of("application/json");
    private static final int WRITER_PROVIDER_PRIORITY = 5100;
    private static final int READER_PROVIDER_PRIORITY = 4900;
    private final boolean tlsTrustAll;
    private final TlsConfig tlsConfig;

    public ResteasyReactiveClientProvider(boolean tlsTrustAll) {
        this.tlsTrustAll = tlsTrustAll;
        this.tlsConfig = null;
    }

    public ResteasyReactiveClientProvider(TlsConfiguration tlsConfiguration) {
        this.tlsTrustAll = tlsConfiguration.isTrustAll();
        this.tlsConfig = ResteasyReactiveClientProvider.createTlsConfig(tlsConfiguration);
    }

    public Client newRestEasyClient(Object messageHandler, SSLContext sslContext, boolean disableTrustManager) {
        ClientBuilderImpl clientBuilder = new ClientBuilderImpl();
        if (this.tlsConfig == null) {
            clientBuilder.trustAll(this.tlsTrustAll || disableTrustManager);
        } else {
            clientBuilder.tlsConfig(this.tlsConfig);
        }
        return this.registerJacksonProviders(clientBuilder).build();
    }

    private ClientBuilderImpl registerJacksonProviders(ClientBuilderImpl clientBuilder) {
        ArcContainer arcContainer = Arc.container();
        if (arcContainer == null) {
            throw new IllegalStateException(this.getClass().getName() + " should only be used in a Quarkus application");
        }
        InstanceHandle objectMapperInstance = arcContainer.instance(ObjectMapper.class, new Annotation[0]);
        boolean canReuseObjectMapper = this.canReuseObjectMapper((InstanceHandle<ObjectMapper>)objectMapperInstance, arcContainer);
        if (canReuseObjectMapper) {
            ObjectMapper objectMapper = null;
            InstanceHandle readerInstance = arcContainer.instance(JacksonBasicMessageBodyReader.class, new Annotation[0]);
            if (readerInstance.isAvailable()) {
                clientBuilder = clientBuilder.register(readerInstance.get());
            } else {
                objectMapper = this.getObjectMapper(objectMapper, (InstanceHandle<ObjectMapper>)objectMapperInstance);
                clientBuilder = clientBuilder.register((Object)new JacksonBasicMessageBodyReader(objectMapper));
            }
            InstanceHandle writerInstance = arcContainer.instance(ClientJacksonMessageBodyWriter.class, new Annotation[0]);
            if (writerInstance.isAvailable()) {
                clientBuilder = clientBuilder.register(writerInstance.get());
            } else {
                objectMapper = this.getObjectMapper(objectMapper, (InstanceHandle<ObjectMapper>)objectMapperInstance);
                clientBuilder = clientBuilder.register((Object)new ClientJacksonMessageBodyWriter(objectMapper));
            }
        } else {
            ObjectMapper newObjectMapper = new ObjectMapper();
            clientBuilder = clientBuilder.registerMessageBodyReader((MessageBodyReader)new JacksonBasicMessageBodyReader(newObjectMapper), Object.class, HANDLED_MEDIA_TYPES, true, Integer.valueOf(4900)).registerMessageBodyWriter((MessageBodyWriter)new ClientJacksonMessageBodyWriter(newObjectMapper), Object.class, HANDLED_MEDIA_TYPES, true, Integer.valueOf(5100));
        }
        InstanceHandle clientLogger = arcContainer.instance(ClientLogger.class, new Annotation[0]);
        if (clientLogger.isAvailable()) {
            clientBuilder.clientLogger((ClientLogger)clientLogger.get());
        }
        return clientBuilder;
    }

    private boolean canReuseObjectMapper(InstanceHandle<ObjectMapper> objectMapperInstance, ArcContainer arcContainer) {
        if (objectMapperInstance.isAvailable() && !objectMapperInstance.getBean().isDefaultBean()) {
            return false;
        }
        Instance customizers = arcContainer.beanManager().createInstance().select(ObjectMapperCustomizer.class, new Annotation[0]);
        if (!customizers.isUnsatisfied()) {
            return false;
        }
        for (String propertyName : ConfigProvider.getConfig().getPropertyNames()) {
            if (!propertyName.startsWith("quarkus.jackson")) continue;
            return false;
        }
        return true;
    }

    private ObjectMapper getObjectMapper(ObjectMapper value, InstanceHandle<ObjectMapper> objectMapperInstance) {
        if (value == null) {
            return objectMapperInstance.isAvailable() ? (ObjectMapper)objectMapperInstance.get() : new ObjectMapper();
        }
        return value;
    }

    public <R> R targetProxy(WebTarget target, Class<R> targetClass) {
        return (R)((WebTargetImpl)target).proxy(targetClass);
    }

    private static TlsConfig createTlsConfig(final TlsConfiguration tlsConfiguration) {
        return new TlsConfig(){

            public KeyStore getKeyStore() {
                return tlsConfiguration.getKeyStore();
            }

            public KeyCertOptions getKeyStoreOptions() {
                return tlsConfiguration.getKeyStoreOptions();
            }

            public KeyStore getTrustStore() {
                return tlsConfiguration.getTrustStore();
            }

            public TrustOptions getTrustStoreOptions() {
                return tlsConfiguration.getTrustStoreOptions();
            }

            public SSLOptions getSSLOptions() {
                return tlsConfiguration.getSSLOptions();
            }

            public SSLContext createSSLContext() throws Exception {
                return tlsConfiguration.createSSLContext();
            }

            public Optional<String> getHostnameVerificationAlgorithm() {
                return tlsConfiguration.getHostnameVerificationAlgorithm();
            }

            public boolean usesSni() {
                return tlsConfiguration.usesSni();
            }

            public boolean isTrustAll() {
                return tlsConfiguration.isTrustAll();
            }
        };
    }
}

