/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.adminclient;

import io.quarkus.keycloak.admin.client.common.KeycloakAdminClientConfig;
import io.quarkus.keycloak.admin.client.common.KeycloakAdminClientConfigUtil;
import io.quarkus.resteasy.common.runtime.jackson.QuarkusJacksonSerializer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientBuilderImpl;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.spi.ResteasyClientProvider;

@Recorder
public class ResteasyKeycloakAdminClientRecorder {
    private final RuntimeValue<KeycloakAdminClientConfig> keycloakAdminClientConfigRuntimeValue;

    public ResteasyKeycloakAdminClientRecorder(RuntimeValue<KeycloakAdminClientConfig> keycloakAdminClientConfigRuntimeValue) {
        this.keycloakAdminClientConfigRuntimeValue = keycloakAdminClientConfigRuntimeValue;
    }

    public Supplier<Keycloak> createAdminClient() {
        KeycloakAdminClientConfig config = (KeycloakAdminClientConfig)this.keycloakAdminClientConfigRuntimeValue.getValue();
        KeycloakAdminClientConfigUtil.validate((KeycloakAdminClientConfig)config);
        if (config.serverUrl().isEmpty()) {
            return new Supplier<Keycloak>(){

                @Override
                public Keycloak get() {
                    throw new IllegalStateException("'quarkus.keycloak.admin-client.server-url' must be set in order to use the Keycloak admin client as a CDI bean");
                }
            };
        }
        final KeycloakBuilder keycloakBuilder = KeycloakBuilder.builder().clientId(config.clientId()).clientSecret((String)config.clientSecret().orElse(null)).grantType(config.grantType().asString()).username((String)config.username().orElse(null)).password((String)config.password().orElse(null)).realm(config.realm()).serverUrl((String)config.serverUrl().get()).scope((String)config.scope().orElse(null));
        return new Supplier<Keycloak>(){

            @Override
            public Keycloak get() {
                return keycloakBuilder.build();
            }
        };
    }

    public void setClientProvider(final boolean areJSONBProvidersPresent, Supplier<TlsConfigurationRegistry> registrySupplier) {
        TlsConfigurationRegistry registry = registrySupplier.get();
        final TlsConfiguration namedTlsConfig = TlsConfiguration.from((TlsConfigurationRegistry)registry, (Optional)((KeycloakAdminClientConfig)this.keycloakAdminClientConfigRuntimeValue.getValue()).tlsConfigurationName()).orElse(null);
        final boolean globalTrustAll = registry.getDefault().isPresent() ? ((TlsConfiguration)registry.getDefault().get()).isTrustAll() : false;
        Keycloak.setClientProvider((ResteasyClientProvider)new ResteasyClientProvider(){

            public Client newRestEasyClient(Object customJacksonProvider, SSLContext sslContext, boolean disableTrustManager) {
                ResteasyClientBuilderImpl builder = new ResteasyClientBuilderImpl();
                builder.connectionPoolSize(10);
                if (namedTlsConfig == null) {
                    builder.sslContext(sslContext);
                    if (globalTrustAll) {
                        builder.disableTrustManager();
                    }
                } else {
                    if (namedTlsConfig.isTrustAll()) {
                        builder.disableTrustManager();
                    }
                    try {
                        builder.sslContext(namedTlsConfig.createSSLContext());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create Keycloak Admin client SSLContext", e);
                    }
                }
                if (areJSONBProvidersPresent) {
                    builder.register((Object)new AppJsonQuarkusJacksonSerializer(), 100);
                }
                return builder.build();
            }

            public <R> R targetProxy(WebTarget webTarget, Class<R> aClass) {
                return (R)((ResteasyWebTarget)ResteasyWebTarget.class.cast(webTarget)).proxy(aClass);
            }
        });
    }

    public void avoidRuntimeInitIssueInClientBuilderWrapper() {
        Keycloak.setClientProvider(null);
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    static class AppJsonQuarkusJacksonSerializer
    extends QuarkusJacksonSerializer {
        AppJsonQuarkusJacksonSerializer() {
        }
    }
}

