/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.keycloak.pep.runtime.KeycloakPoilcyEnforcerBuildTimeConfig;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerAuthorizer;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerConfig;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerRecorder;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerTenantConfig;
import io.quarkus.keycloak.pep.runtime.PolicyEnforcerResolver;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.vertx.http.deployment.RequireBodyHandlerBuildItem;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.inject.Singleton;

public class KeycloakPolicyEnforcerBuildStep {
    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.KEYCLOAK_AUTHORIZATION);
    }

    @BuildStep(onlyIf={IsEnabled.class})
    RequireBodyHandlerBuildItem requireBody(OidcBuildTimeConfig oidcBuildTimeConfig, KeycloakPolicyEnforcerConfig config) {
        if (oidcBuildTimeConfig.enabled) {
            if (KeycloakPolicyEnforcerBuildStep.isBodyHandlerRequired(config.defaultTenant)) {
                return new RequireBodyHandlerBuildItem();
            }
            for (KeycloakPolicyEnforcerTenantConfig tenantConfig : config.namedTenants.values()) {
                if (!KeycloakPolicyEnforcerBuildStep.isBodyHandlerRequired(tenantConfig)) continue;
                return new RequireBodyHandlerBuildItem();
            }
        }
        return null;
    }

    private static boolean isBodyHandlerRequired(KeycloakPolicyEnforcerTenantConfig config) {
        if (KeycloakPolicyEnforcerBuildStep.isBodyClaimInformationPointDefined(config.policyEnforcer.claimInformationPoint.simpleConfig)) {
            return true;
        }
        for (KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathConfig path : config.policyEnforcer.paths.values()) {
            if (!KeycloakPolicyEnforcerBuildStep.isBodyClaimInformationPointDefined(path.claimInformationPoint.simpleConfig)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBodyClaimInformationPointDefined(Map<String, Map<String, String>> claims) {
        for (Map.Entry<String, Map<String, String>> entry : claims.entrySet()) {
            Map<String, String> value = entry.getValue();
            for (String nestedValue : value.values()) {
                if (!nestedValue.contains("request.body")) continue;
                return true;
            }
        }
        return false;
    }

    @BuildStep(onlyIf={IsEnabled.class})
    public AdditionalBeanBuildItem beans(OidcBuildTimeConfig oidcBuildTimeConfig, KeycloakPolicyEnforcerConfig config) {
        if (oidcBuildTimeConfig.enabled) {
            return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(KeycloakPolicyEnforcerAuthorizer.class).build();
        }
        return null;
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem enableSslInNative() {
        return new ExtensionSslNativeSupportBuildItem(Feature.KEYCLOAK_AUTHORIZATION);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsEnabled.class})
    public SyntheticBeanBuildItem setup(OidcBuildTimeConfig oidcBuildTimeConfig, OidcConfig oidcRunTimeConfig, TlsConfig tlsConfig, KeycloakPolicyEnforcerConfig keycloakConfig, KeycloakPolicyEnforcerRecorder recorder) {
        if (oidcBuildTimeConfig.enabled) {
            return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(PolicyEnforcerResolver.class).unremovable()).types(new Class[]{PolicyEnforcerResolver.class})).supplier(recorder.setup(oidcRunTimeConfig, keycloakConfig, tlsConfig)).scope(Singleton.class)).setRuntimeInit().done();
        }
        return null;
    }

    public static class IsEnabled
    implements BooleanSupplier {
        KeycloakPoilcyEnforcerBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.policyEnforcer.enable;
        }
    }
}

